/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts.images;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskartifacts.images.requests.BodyPostTaskArtifactsUploadImageV1OortTaskArtifactsImagesUploadV1TaskArtifactIdPost;
import java.io.File;
import java.io.InputStream;

public class ImagesClient {
    protected final ClientOptions clientOptions;

    private final RawImagesClient rawClient;

    public ImagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawImagesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawImagesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Streams a task_artifact image file from S3 storage.
     */
    public InputStream getByMetadataIdV1(String taskArtifactS3ObjectMetadataId) {
        return this.rawClient.getByMetadataIdV1(taskArtifactS3ObjectMetadataId).body();
    }

    /**
     * Streams a task_artifact image file from S3 storage.
     */
    public InputStream getByMetadataIdV1(String taskArtifactS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getByMetadataIdV1(taskArtifactS3ObjectMetadataId, requestOptions)
                .body();
    }

    /**
     * Uploads an image file to a task_artifact with automatic blurhash generation.
     */
    public boolean uploadByTaskArtifactIdV1(
            String taskArtifactId,
            File image,
            BodyPostTaskArtifactsUploadImageV1OortTaskArtifactsImagesUploadV1TaskArtifactIdPost request) {
        return this.rawClient
                .uploadByTaskArtifactIdV1(taskArtifactId, image, request)
                .body();
    }

    /**
     * Uploads an image file to a task_artifact with automatic blurhash generation.
     */
    public boolean uploadByTaskArtifactIdV1(
            String taskArtifactId,
            File image,
            BodyPostTaskArtifactsUploadImageV1OortTaskArtifactsImagesUploadV1TaskArtifactIdPost request,
            RequestOptions requestOptions) {
        return this.rawClient
                .uploadByTaskArtifactIdV1(taskArtifactId, image, request, requestOptions)
                .body();
    }

    /**
     * Deletes a task_artifact image from both S3 storage and database metadata.
     */
    public boolean deleteByMetadataIdV1(String taskArtifactS3ObjectMetadataId) {
        return this.rawClient
                .deleteByMetadataIdV1(taskArtifactS3ObjectMetadataId)
                .body();
    }

    /**
     * Deletes a task_artifact image from both S3 storage and database metadata.
     */
    public boolean deleteByMetadataIdV1(String taskArtifactS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteByMetadataIdV1(taskArtifactS3ObjectMetadataId, requestOptions)
                .body();
    }
}
