/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.TaskArtifactTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskArtifactAddToTaskReq.Builder.class)
public final class TaskArtifactAddToTaskReq {
    private final String taskId;

    private final TaskArtifactTypeEnum1 taskArtifactType;

    private final boolean taskArtifactIsCompleted;

    private final Optional<String> completorComments;

    private final Optional<LocationFeature> location;

    private final Map<String, Object> additionalProperties;

    private TaskArtifactAddToTaskReq(
            String taskId,
            TaskArtifactTypeEnum1 taskArtifactType,
            boolean taskArtifactIsCompleted,
            Optional<String> completorComments,
            Optional<LocationFeature> location,
            Map<String, Object> additionalProperties) {
        this.taskId = taskId;
        this.taskArtifactType = taskArtifactType;
        this.taskArtifactIsCompleted = taskArtifactIsCompleted;
        this.completorComments = completorComments;
        this.location = location;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_id")
    public String getTaskId() {
        return taskId;
    }

    @JsonProperty("task_artifact_type")
    public TaskArtifactTypeEnum1 getTaskArtifactType() {
        return taskArtifactType;
    }

    @JsonProperty("task_artifact_is_completed")
    public boolean getTaskArtifactIsCompleted() {
        return taskArtifactIsCompleted;
    }

    @JsonIgnore
    public Optional<String> getCompletorComments() {
        if (completorComments == null) {
            return Optional.empty();
        }
        return completorComments;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (location == null) {
            return Optional.empty();
        }
        return location;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completor_comments")
    private Optional<String> _getCompletorComments() {
        return completorComments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("location")
    private Optional<LocationFeature> _getLocation() {
        return location;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskArtifactAddToTaskReq && equalTo((TaskArtifactAddToTaskReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskArtifactAddToTaskReq other) {
        return taskId.equals(other.taskId)
                && taskArtifactType.equals(other.taskArtifactType)
                && taskArtifactIsCompleted == other.taskArtifactIsCompleted
                && completorComments.equals(other.completorComments)
                && location.equals(other.location);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.taskId,
                this.taskArtifactType,
                this.taskArtifactIsCompleted,
                this.completorComments,
                this.location);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskIdStage builder() {
        return new Builder();
    }

    public interface TaskIdStage {
        TaskArtifactTypeStage taskId(@NotNull String taskId);

        Builder from(TaskArtifactAddToTaskReq other);
    }

    public interface TaskArtifactTypeStage {
        TaskArtifactIsCompletedStage taskArtifactType(@NotNull TaskArtifactTypeEnum1 taskArtifactType);
    }

    public interface TaskArtifactIsCompletedStage {
        _FinalStage taskArtifactIsCompleted(boolean taskArtifactIsCompleted);
    }

    public interface _FinalStage {
        TaskArtifactAddToTaskReq build();

        _FinalStage completorComments(Optional<String> completorComments);

        _FinalStage completorComments(String completorComments);

        _FinalStage completorComments(Nullable<String> completorComments);

        _FinalStage location(Optional<LocationFeature> location);

        _FinalStage location(LocationFeature location);

        _FinalStage location(Nullable<LocationFeature> location);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements TaskIdStage, TaskArtifactTypeStage, TaskArtifactIsCompletedStage, _FinalStage {
        private String taskId;

        private TaskArtifactTypeEnum1 taskArtifactType;

        private boolean taskArtifactIsCompleted;

        private Optional<LocationFeature> location = Optional.empty();

        private Optional<String> completorComments = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskArtifactAddToTaskReq other) {
            taskId(other.getTaskId());
            taskArtifactType(other.getTaskArtifactType());
            taskArtifactIsCompleted(other.getTaskArtifactIsCompleted());
            completorComments(other.getCompletorComments());
            location(other.getLocation());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_id")
        public TaskArtifactTypeStage taskId(@NotNull String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_artifact_type")
        public TaskArtifactIsCompletedStage taskArtifactType(@NotNull TaskArtifactTypeEnum1 taskArtifactType) {
            this.taskArtifactType = Objects.requireNonNull(taskArtifactType, "taskArtifactType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_artifact_is_completed")
        public _FinalStage taskArtifactIsCompleted(boolean taskArtifactIsCompleted) {
            this.taskArtifactIsCompleted = taskArtifactIsCompleted;
            return this;
        }

        @java.lang.Override
        public _FinalStage location(Nullable<LocationFeature> location) {
            if (location.isNull()) {
                this.location = null;
            } else if (location.isEmpty()) {
                this.location = Optional.empty();
            } else {
                this.location = Optional.of(location.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public _FinalStage location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        @java.lang.Override
        public _FinalStage completorComments(Nullable<String> completorComments) {
            if (completorComments.isNull()) {
                this.completorComments = null;
            } else if (completorComments.isEmpty()) {
                this.completorComments = Optional.empty();
            } else {
                this.completorComments = Optional.of(completorComments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage completorComments(String completorComments) {
            this.completorComments = Optional.ofNullable(completorComments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "completor_comments", nulls = Nulls.SKIP)
        public _FinalStage completorComments(Optional<String> completorComments) {
            this.completorComments = completorComments;
            return this;
        }

        @java.lang.Override
        public TaskArtifactAddToTaskReq build() {
            return new TaskArtifactAddToTaskReq(
                    taskId,
                    taskArtifactType,
                    taskArtifactIsCompleted,
                    completorComments,
                    location,
                    additionalProperties);
        }
    }
}
