/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskgroups.expanded.AsyncExpandedClient;
import com.chrt.api.resources.taskgroups.expandedlist.AsyncExpandedListClient;
import com.chrt.api.resources.taskgroups.requests.SetTaskGroupPauseReq;
import com.chrt.api.resources.taskgroups.requests.UpdateTaskGroupReq;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTaskGroupsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupsClient rawClient;

    protected final Supplier<AsyncExpandedClient> expandedClient;

    protected final Supplier<AsyncExpandedListClient> expandedListClient;

    public AsyncTaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupsClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
        this.expandedListClient = Suppliers.memoize(() -> new AsyncExpandedListClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Updates task group driver assignments by adding or removing drivers.
     */
    public CompletableFuture<Boolean> updateV1(UpdateTaskGroupReq request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates task group driver assignments by adding or removing drivers.
     */
    public CompletableFuture<Boolean> updateV1(UpdateTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Starts a task group by changing its status to in-progress and updating the order status. Only authorized personas (task_group_driver or task_group_courier_org_administrator) can start a task group.
     */
    public CompletableFuture<Boolean> startV1(String taskGroupId) {
        return this.rawClient.startV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Starts a task group by changing its status to in-progress and updating the order status. Only authorized personas (task_group_driver or task_group_courier_org_administrator) can start a task group.
     */
    public CompletableFuture<Boolean> startV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.startV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Toggles the pause status of an in-progress task group.
     */
    public CompletableFuture<Boolean> togglePauseV1(String id, SetTaskGroupPauseReq request) {
        return this.rawClient.togglePauseV1(id, request).thenApply(response -> response.body());
    }

    /**
     * Toggles the pause status of an in-progress task group.
     */
    public CompletableFuture<Boolean> togglePauseV1(
            String id, SetTaskGroupPauseReq request, RequestOptions requestOptions) {
        return this.rawClient.togglePauseV1(id, request, requestOptions).thenApply(response -> response.body());
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }

    public AsyncExpandedListClient expandedList() {
        return this.expandedListClient.get();
    }
}
