/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskgroups.expanded.ExpandedClient;
import com.chrt.api.resources.taskgroups.expandedlist.ExpandedListClient;
import com.chrt.api.resources.taskgroups.requests.SetTaskGroupPauseReq;
import com.chrt.api.resources.taskgroups.requests.UpdateTaskGroupReq;
import java.util.function.Supplier;

public class TaskGroupsClient {
    protected final ClientOptions clientOptions;

    private final RawTaskGroupsClient rawClient;

    protected final Supplier<ExpandedClient> expandedClient;

    protected final Supplier<ExpandedListClient> expandedListClient;

    public TaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskGroupsClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new ExpandedClient(clientOptions));
        this.expandedListClient = Suppliers.memoize(() -> new ExpandedListClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Updates task group driver assignments by adding or removing drivers.
     */
    public boolean updateV1(UpdateTaskGroupReq request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates task group driver assignments by adding or removing drivers.
     */
    public boolean updateV1(UpdateTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    /**
     * Starts a task group by changing its status to in-progress and updating the order status. Only authorized personas (task_group_driver or task_group_courier_org_administrator) can start a task group.
     */
    public boolean startV1(String taskGroupId) {
        return this.rawClient.startV1(taskGroupId).body();
    }

    /**
     * Starts a task group by changing its status to in-progress and updating the order status. Only authorized personas (task_group_driver or task_group_courier_org_administrator) can start a task group.
     */
    public boolean startV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.startV1(taskGroupId, requestOptions).body();
    }

    /**
     * Toggles the pause status of an in-progress task group.
     */
    public boolean togglePauseV1(String id, SetTaskGroupPauseReq request) {
        return this.rawClient.togglePauseV1(id, request).body();
    }

    /**
     * Toggles the pause status of an in-progress task group.
     */
    public boolean togglePauseV1(String id, SetTaskGroupPauseReq request, RequestOptions requestOptions) {
        return this.rawClient.togglePauseV1(id, request, requestOptions).body();
    }

    public ExpandedClient expanded() {
        return this.expandedClient.get();
    }

    public ExpandedListClient expandedList() {
        return this.expandedListClient.get();
    }
}
