/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expanded;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.taskgroups.expanded.requests.TaskGroupExpandedForShipperReq;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.TaskGroupExpandedForCourierAdministrator;
import com.chrt.api.types.TaskGroupExpandedForCourierAdministratorReq;
import com.chrt.api.types.TaskGroupExpandedForCourierDriver;
import com.chrt.api.types.TaskGroupExpandedForCourierDriverReq;
import com.chrt.api.types.TaskGroupExpandedForShipper;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawExpandedClient {
    protected final ClientOptions clientOptions;

    public AsyncRawExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Fetches an expanded task group for the courier org with expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierAdministrator>>
            forCourierAdministratorByIdV1(String id) {
        return forCourierAdministratorByIdV1(
                id, TaskGroupExpandedForCourierAdministratorReq.builder().build());
    }

    /**
     * Fetches an expanded task group for the courier org with expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierAdministrator>>
            forCourierAdministratorByIdV1(String id, TaskGroupExpandedForCourierAdministratorReq request) {
        return forCourierAdministratorByIdV1(id, request, null);
    }

    /**
     * Fetches an expanded task group for the courier org with expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierAdministrator>>
            forCourierAdministratorByIdV1(
                    String id, TaskGroupExpandedForCourierAdministratorReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/expanded/for_courier_administrator/v1")
                .addPathSegment(id)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierAdministrator>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, TaskGroupExpandedForCourierAdministrator.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Fetches an expanded task group assigned to a courier driver with optional expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierDriver>> forCourierDriverByIdV1(String id) {
        return forCourierDriverByIdV1(
                id, TaskGroupExpandedForCourierDriverReq.builder().build());
    }

    /**
     * Fetches an expanded task group assigned to a courier driver with optional expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierDriver>> forCourierDriverByIdV1(
            String id, TaskGroupExpandedForCourierDriverReq request) {
        return forCourierDriverByIdV1(id, request, null);
    }

    /**
     * Fetches an expanded task group assigned to a courier driver with optional expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierDriver>> forCourierDriverByIdV1(
            String id, TaskGroupExpandedForCourierDriverReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/expanded/for_courier_driver/v1")
                .addPathSegment(id)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForCourierDriver>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, TaskGroupExpandedForCourierDriver.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Fetches an expanded task group for the shipper org with expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForShipper>> forShipperByIdV1(String id) {
        return forShipperByIdV1(id, TaskGroupExpandedForShipperReq.builder().build());
    }

    /**
     * Fetches an expanded task group for the shipper org with expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForShipper>> forShipperByIdV1(
            String id, TaskGroupExpandedForShipperReq request) {
        return forShipperByIdV1(id, request, null);
    }

    /**
     * Fetches an expanded task group for the shipper org with expanded related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForShipper>> forShipperByIdV1(
            String id, TaskGroupExpandedForShipperReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/expanded/for_shipper/v1")
                .addPathSegment(id)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<TaskGroupExpandedForShipper>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, TaskGroupExpandedForShipper.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
