/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.expanded.requests.TaskGroupExpandedForShipperReq;
import com.chrt.api.types.TaskGroupExpandedForCourierAdministrator;
import com.chrt.api.types.TaskGroupExpandedForCourierAdministratorReq;
import com.chrt.api.types.TaskGroupExpandedForCourierDriver;
import com.chrt.api.types.TaskGroupExpandedForCourierDriverReq;
import com.chrt.api.types.TaskGroupExpandedForShipper;

public class ExpandedClient {
    protected final ClientOptions clientOptions;

    private final RawExpandedClient rawClient;

    public ExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawExpandedClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetches an expanded task group for the courier org with expanded related data.
     */
    public TaskGroupExpandedForCourierAdministrator forCourierAdministratorByIdV1(String id) {
        return this.rawClient.forCourierAdministratorByIdV1(id).body();
    }

    /**
     * Fetches an expanded task group for the courier org with expanded related data.
     */
    public TaskGroupExpandedForCourierAdministrator forCourierAdministratorByIdV1(
            String id, TaskGroupExpandedForCourierAdministratorReq request) {
        return this.rawClient.forCourierAdministratorByIdV1(id, request).body();
    }

    /**
     * Fetches an expanded task group for the courier org with expanded related data.
     */
    public TaskGroupExpandedForCourierAdministrator forCourierAdministratorByIdV1(
            String id, TaskGroupExpandedForCourierAdministratorReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierAdministratorByIdV1(id, request, requestOptions)
                .body();
    }

    /**
     * Fetches an expanded task group assigned to a courier driver with optional expanded related data.
     */
    public TaskGroupExpandedForCourierDriver forCourierDriverByIdV1(String id) {
        return this.rawClient.forCourierDriverByIdV1(id).body();
    }

    /**
     * Fetches an expanded task group assigned to a courier driver with optional expanded related data.
     */
    public TaskGroupExpandedForCourierDriver forCourierDriverByIdV1(
            String id, TaskGroupExpandedForCourierDriverReq request) {
        return this.rawClient.forCourierDriverByIdV1(id, request).body();
    }

    /**
     * Fetches an expanded task group assigned to a courier driver with optional expanded related data.
     */
    public TaskGroupExpandedForCourierDriver forCourierDriverByIdV1(
            String id, TaskGroupExpandedForCourierDriverReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierDriverByIdV1(id, request, requestOptions)
                .body();
    }

    /**
     * Fetches an expanded task group for the shipper org with expanded related data.
     */
    public TaskGroupExpandedForShipper forShipperByIdV1(String id) {
        return this.rawClient.forShipperByIdV1(id).body();
    }

    /**
     * Fetches an expanded task group for the shipper org with expanded related data.
     */
    public TaskGroupExpandedForShipper forShipperByIdV1(String id, TaskGroupExpandedForShipperReq request) {
        return this.rawClient.forShipperByIdV1(id, request).body();
    }

    /**
     * Fetches an expanded task group for the shipper org with expanded related data.
     */
    public TaskGroupExpandedForShipper forShipperByIdV1(
            String id, TaskGroupExpandedForShipperReq request, RequestOptions requestOptions) {
        return this.rawClient.forShipperByIdV1(id, request, requestOptions).body();
    }
}
