/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expandedlist;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.expandedlist.requests.ExpandedListForCourierAdministratorV1Request;
import com.chrt.api.resources.taskgroups.expandedlist.requests.ExpandedListForCourierDriverV1Request;
import com.chrt.api.types.TaskGroupsExpandedForCourierAdministratorRes;
import com.chrt.api.types.TaskGroupsExpandedForCourierDriverRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedListClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawExpandedListClient rawClient;

    public AsyncExpandedListClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedListClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawExpandedListClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetches expanded task groups for the courier org with optional filters and expanded related data.
     */
    public CompletableFuture<TaskGroupsExpandedForCourierAdministratorRes> forCourierAdministratorV1(
            ExpandedListForCourierAdministratorV1Request request) {
        return this.rawClient.forCourierAdministratorV1(request).thenApply(response -> response.body());
    }

    /**
     * Fetches expanded task groups for the courier org with optional filters and expanded related data.
     */
    public CompletableFuture<TaskGroupsExpandedForCourierAdministratorRes> forCourierAdministratorV1(
            ExpandedListForCourierAdministratorV1Request request, RequestOptions requestOptions) {
        return this.rawClient.forCourierAdministratorV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Fetches expanded task groups assigned to a courier driver with optional expanded related data.
     */
    public CompletableFuture<TaskGroupsExpandedForCourierDriverRes> forCourierDriverV1(
            ExpandedListForCourierDriverV1Request request) {
        return this.rawClient.forCourierDriverV1(request).thenApply(response -> response.body());
    }

    /**
     * Fetches expanded task groups assigned to a courier driver with optional expanded related data.
     */
    public CompletableFuture<TaskGroupsExpandedForCourierDriverRes> forCourierDriverV1(
            ExpandedListForCourierDriverV1Request request, RequestOptions requestOptions) {
        return this.rawClient.forCourierDriverV1(request, requestOptions).thenApply(response -> response.body());
    }
}
