/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expandedlist;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.expandedlist.requests.ExpandedListForCourierAdministratorV1Request;
import com.chrt.api.resources.taskgroups.expandedlist.requests.ExpandedListForCourierDriverV1Request;
import com.chrt.api.types.TaskGroupsExpandedForCourierAdministratorRes;
import com.chrt.api.types.TaskGroupsExpandedForCourierDriverRes;

public class ExpandedListClient {
    protected final ClientOptions clientOptions;

    private final RawExpandedListClient rawClient;

    public ExpandedListClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawExpandedListClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawExpandedListClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetches expanded task groups for the courier org with optional filters and expanded related data.
     */
    public TaskGroupsExpandedForCourierAdministratorRes forCourierAdministratorV1(
            ExpandedListForCourierAdministratorV1Request request) {
        return this.rawClient.forCourierAdministratorV1(request).body();
    }

    /**
     * Fetches expanded task groups for the courier org with optional filters and expanded related data.
     */
    public TaskGroupsExpandedForCourierAdministratorRes forCourierAdministratorV1(
            ExpandedListForCourierAdministratorV1Request request, RequestOptions requestOptions) {
        return this.rawClient.forCourierAdministratorV1(request, requestOptions).body();
    }

    /**
     * Fetches expanded task groups assigned to a courier driver with optional expanded related data.
     */
    public TaskGroupsExpandedForCourierDriverRes forCourierDriverV1(ExpandedListForCourierDriverV1Request request) {
        return this.rawClient.forCourierDriverV1(request).body();
    }

    /**
     * Fetches expanded task groups assigned to a courier driver with optional expanded related data.
     */
    public TaskGroupsExpandedForCourierDriverRes forCourierDriverV1(
            ExpandedListForCourierDriverV1Request request, RequestOptions requestOptions) {
        return this.rawClient.forCourierDriverV1(request, requestOptions).body();
    }
}
