/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expandedlist;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.taskgroups.expandedlist.requests.ExpandedListForCourierAdministratorV1Request;
import com.chrt.api.resources.taskgroups.expandedlist.requests.ExpandedListForCourierDriverV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.TaskGroupsExpandedForCourierAdministratorRes;
import com.chrt.api.types.TaskGroupsExpandedForCourierDriverRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawExpandedListClient {
    protected final ClientOptions clientOptions;

    public RawExpandedListClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Fetches expanded task groups for the courier org with optional filters and expanded related data.
     */
    public ChrtApiHttpResponse<TaskGroupsExpandedForCourierAdministratorRes> forCourierAdministratorV1(
            ExpandedListForCourierAdministratorV1Request request) {
        return forCourierAdministratorV1(request, null);
    }

    /**
     * Fetches expanded task groups for the courier org with optional filters and expanded related data.
     */
    public ChrtApiHttpResponse<TaskGroupsExpandedForCourierAdministratorRes> forCourierAdministratorV1(
            ExpandedListForCourierAdministratorV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/expanded/list/for_courier_administrator/v1");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getFilterCreatedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_created_at_gte",
                    request.getFilterCreatedAtGte().get(),
                    false);
        }
        if (request.getFilterCreatedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_created_at_lte",
                    request.getFilterCreatedAtLte().get(),
                    false);
        }
        if (request.getFilterStartedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_started_at_gte",
                    request.getFilterStartedAtGte().get(),
                    false);
        }
        if (request.getFilterStartedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_started_at_lte",
                    request.getFilterStartedAtLte().get(),
                    false);
        }
        if (request.getFilterCompletedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_gte",
                    request.getFilterCompletedAtGte().get(),
                    false);
        }
        if (request.getFilterCompletedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_lte",
                    request.getFilterCompletedAtLte().get(),
                    false);
        }
        if (request.getFilterOrderCancelled().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled",
                    request.getFilterOrderCancelled().get(),
                    false);
        }
        if (request.getFilterCompleted().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_completed", request.getFilterCompleted().get(), false);
        }
        if (request.getFilterPaused().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_paused", request.getFilterPaused().get(), false);
        }
        if (request.getFilterStatuses().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_statuses", request.getFilterStatuses().get(), true);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, TaskGroupsExpandedForCourierAdministratorRes.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Fetches expanded task groups assigned to a courier driver with optional expanded related data.
     */
    public ChrtApiHttpResponse<TaskGroupsExpandedForCourierDriverRes> forCourierDriverV1(
            ExpandedListForCourierDriverV1Request request) {
        return forCourierDriverV1(request, null);
    }

    /**
     * Fetches expanded task groups assigned to a courier driver with optional expanded related data.
     */
    public ChrtApiHttpResponse<TaskGroupsExpandedForCourierDriverRes> forCourierDriverV1(
            ExpandedListForCourierDriverV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/expanded/list/for_courier_driver/v1");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getFilterCreatedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_created_at_gte",
                    request.getFilterCreatedAtGte().get(),
                    false);
        }
        if (request.getFilterCreatedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_created_at_lte",
                    request.getFilterCreatedAtLte().get(),
                    false);
        }
        if (request.getFilterStartedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_started_at_gte",
                    request.getFilterStartedAtGte().get(),
                    false);
        }
        if (request.getFilterStartedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_started_at_lte",
                    request.getFilterStartedAtLte().get(),
                    false);
        }
        if (request.getFilterCompletedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_gte",
                    request.getFilterCompletedAtGte().get(),
                    false);
        }
        if (request.getFilterCompletedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_lte",
                    request.getFilterCompletedAtLte().get(),
                    false);
        }
        if (request.getFilterOrderCancelled().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled",
                    request.getFilterOrderCancelled().get(),
                    false);
        }
        if (request.getFilterCompleted().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_completed", request.getFilterCompleted().get(), false);
        }
        if (request.getFilterPaused().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_paused", request.getFilterPaused().get(), false);
        }
        if (request.getFilterStatuses().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_statuses", request.getFilterStatuses().get(), true);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, TaskGroupsExpandedForCourierDriverRes.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
