/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expandedlist.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.SortOrderEnum;
import com.chrt.api.types.TaskGroupExpandedForCourierAdministratorReq;
import com.chrt.api.types.TaskGroupExpandedSortFieldEnum;
import com.chrt.api.types.TaskGroupStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ExpandedListForCourierAdministratorV1Request.Builder.class)
public final class ExpandedListForCourierAdministratorV1Request {
    private final Optional<List<TaskGroupStatusEnum1>> filterStatuses;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<TaskGroupExpandedSortFieldEnum> sortBy;

    private final Optional<SortOrderEnum> sortOrder;

    private final Optional<OffsetDateTime> filterCreatedAtGte;

    private final Optional<OffsetDateTime> filterCreatedAtLte;

    private final Optional<OffsetDateTime> filterStartedAtGte;

    private final Optional<OffsetDateTime> filterStartedAtLte;

    private final Optional<OffsetDateTime> filterCompletedAtGte;

    private final Optional<OffsetDateTime> filterCompletedAtLte;

    private final Optional<Boolean> filterOrderCancelled;

    private final Optional<Boolean> filterCompleted;

    private final Optional<Boolean> filterPaused;

    private final TaskGroupExpandedForCourierAdministratorReq body;

    private final Map<String, Object> additionalProperties;

    private ExpandedListForCourierAdministratorV1Request(
            Optional<List<TaskGroupStatusEnum1>> filterStatuses,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<TaskGroupExpandedSortFieldEnum> sortBy,
            Optional<SortOrderEnum> sortOrder,
            Optional<OffsetDateTime> filterCreatedAtGte,
            Optional<OffsetDateTime> filterCreatedAtLte,
            Optional<OffsetDateTime> filterStartedAtGte,
            Optional<OffsetDateTime> filterStartedAtLte,
            Optional<OffsetDateTime> filterCompletedAtGte,
            Optional<OffsetDateTime> filterCompletedAtLte,
            Optional<Boolean> filterOrderCancelled,
            Optional<Boolean> filterCompleted,
            Optional<Boolean> filterPaused,
            TaskGroupExpandedForCourierAdministratorReq body,
            Map<String, Object> additionalProperties) {
        this.filterStatuses = filterStatuses;
        this.page = page;
        this.pageSize = pageSize;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.filterCreatedAtGte = filterCreatedAtGte;
        this.filterCreatedAtLte = filterCreatedAtLte;
        this.filterStartedAtGte = filterStartedAtGte;
        this.filterStartedAtLte = filterStartedAtLte;
        this.filterCompletedAtGte = filterCompletedAtGte;
        this.filterCompletedAtLte = filterCompletedAtLte;
        this.filterOrderCancelled = filterOrderCancelled;
        this.filterCompleted = filterCompleted;
        this.filterPaused = filterPaused;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<TaskGroupStatusEnum1>> getFilterStatuses() {
        if (filterStatuses == null) {
            return Optional.empty();
        }
        return filterStatuses;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonIgnore
    public Optional<TaskGroupExpandedSortFieldEnum> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    @JsonIgnore
    public Optional<SortOrderEnum> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCreatedAtGte() {
        if (filterCreatedAtGte == null) {
            return Optional.empty();
        }
        return filterCreatedAtGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCreatedAtLte() {
        if (filterCreatedAtLte == null) {
            return Optional.empty();
        }
        return filterCreatedAtLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStartedAtGte() {
        if (filterStartedAtGte == null) {
            return Optional.empty();
        }
        return filterStartedAtGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStartedAtLte() {
        if (filterStartedAtLte == null) {
            return Optional.empty();
        }
        return filterStartedAtLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCompletedAtGte() {
        if (filterCompletedAtGte == null) {
            return Optional.empty();
        }
        return filterCompletedAtGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCompletedAtLte() {
        if (filterCompletedAtLte == null) {
            return Optional.empty();
        }
        return filterCompletedAtLte;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterOrderCancelled() {
        if (filterOrderCancelled == null) {
            return Optional.empty();
        }
        return filterOrderCancelled;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterCompleted() {
        if (filterCompleted == null) {
            return Optional.empty();
        }
        return filterCompleted;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterPaused() {
        if (filterPaused == null) {
            return Optional.empty();
        }
        return filterPaused;
    }

    @JsonProperty("body")
    public TaskGroupExpandedForCourierAdministratorReq getBody() {
        return body;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_statuses")
    private Optional<List<TaskGroupStatusEnum1>> _getFilterStatuses() {
        return filterStatuses;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<TaskGroupExpandedSortFieldEnum> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<SortOrderEnum> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_created_at_gte")
    private Optional<OffsetDateTime> _getFilterCreatedAtGte() {
        return filterCreatedAtGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_created_at_lte")
    private Optional<OffsetDateTime> _getFilterCreatedAtLte() {
        return filterCreatedAtLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_started_at_gte")
    private Optional<OffsetDateTime> _getFilterStartedAtGte() {
        return filterStartedAtGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_started_at_lte")
    private Optional<OffsetDateTime> _getFilterStartedAtLte() {
        return filterStartedAtLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed_at_gte")
    private Optional<OffsetDateTime> _getFilterCompletedAtGte() {
        return filterCompletedAtGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed_at_lte")
    private Optional<OffsetDateTime> _getFilterCompletedAtLte() {
        return filterCompletedAtLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_order_cancelled")
    private Optional<Boolean> _getFilterOrderCancelled() {
        return filterOrderCancelled;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed")
    private Optional<Boolean> _getFilterCompleted() {
        return filterCompleted;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_paused")
    private Optional<Boolean> _getFilterPaused() {
        return filterPaused;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ExpandedListForCourierAdministratorV1Request
                && equalTo((ExpandedListForCourierAdministratorV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpandedListForCourierAdministratorV1Request other) {
        return filterStatuses.equals(other.filterStatuses)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && filterCreatedAtGte.equals(other.filterCreatedAtGte)
                && filterCreatedAtLte.equals(other.filterCreatedAtLte)
                && filterStartedAtGte.equals(other.filterStartedAtGte)
                && filterStartedAtLte.equals(other.filterStartedAtLte)
                && filterCompletedAtGte.equals(other.filterCompletedAtGte)
                && filterCompletedAtLte.equals(other.filterCompletedAtLte)
                && filterOrderCancelled.equals(other.filterOrderCancelled)
                && filterCompleted.equals(other.filterCompleted)
                && filterPaused.equals(other.filterPaused)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.filterStatuses,
                this.page,
                this.pageSize,
                this.sortBy,
                this.sortOrder,
                this.filterCreatedAtGte,
                this.filterCreatedAtLte,
                this.filterStartedAtGte,
                this.filterStartedAtLte,
                this.filterCompletedAtGte,
                this.filterCompletedAtLte,
                this.filterOrderCancelled,
                this.filterCompleted,
                this.filterPaused,
                this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    public interface BodyStage {
        _FinalStage body(@NotNull TaskGroupExpandedForCourierAdministratorReq body);

        Builder from(ExpandedListForCourierAdministratorV1Request other);
    }

    public interface _FinalStage {
        ExpandedListForCourierAdministratorV1Request build();

        _FinalStage filterStatuses(Optional<List<TaskGroupStatusEnum1>> filterStatuses);

        _FinalStage filterStatuses(List<TaskGroupStatusEnum1> filterStatuses);

        _FinalStage filterStatuses(Nullable<List<TaskGroupStatusEnum1>> filterStatuses);

        _FinalStage filterStatuses(TaskGroupStatusEnum1 filterStatuses);

        _FinalStage page(Optional<Integer> page);

        _FinalStage page(Integer page);

        _FinalStage page(Nullable<Integer> page);

        _FinalStage pageSize(Optional<Integer> pageSize);

        _FinalStage pageSize(Integer pageSize);

        _FinalStage pageSize(Nullable<Integer> pageSize);

        _FinalStage sortBy(Optional<TaskGroupExpandedSortFieldEnum> sortBy);

        _FinalStage sortBy(TaskGroupExpandedSortFieldEnum sortBy);

        _FinalStage sortBy(Nullable<TaskGroupExpandedSortFieldEnum> sortBy);

        _FinalStage sortOrder(Optional<SortOrderEnum> sortOrder);

        _FinalStage sortOrder(SortOrderEnum sortOrder);

        _FinalStage sortOrder(Nullable<SortOrderEnum> sortOrder);

        _FinalStage filterCreatedAtGte(Optional<OffsetDateTime> filterCreatedAtGte);

        _FinalStage filterCreatedAtGte(OffsetDateTime filterCreatedAtGte);

        _FinalStage filterCreatedAtGte(Nullable<OffsetDateTime> filterCreatedAtGte);

        _FinalStage filterCreatedAtLte(Optional<OffsetDateTime> filterCreatedAtLte);

        _FinalStage filterCreatedAtLte(OffsetDateTime filterCreatedAtLte);

        _FinalStage filterCreatedAtLte(Nullable<OffsetDateTime> filterCreatedAtLte);

        _FinalStage filterStartedAtGte(Optional<OffsetDateTime> filterStartedAtGte);

        _FinalStage filterStartedAtGte(OffsetDateTime filterStartedAtGte);

        _FinalStage filterStartedAtGte(Nullable<OffsetDateTime> filterStartedAtGte);

        _FinalStage filterStartedAtLte(Optional<OffsetDateTime> filterStartedAtLte);

        _FinalStage filterStartedAtLte(OffsetDateTime filterStartedAtLte);

        _FinalStage filterStartedAtLte(Nullable<OffsetDateTime> filterStartedAtLte);

        _FinalStage filterCompletedAtGte(Optional<OffsetDateTime> filterCompletedAtGte);

        _FinalStage filterCompletedAtGte(OffsetDateTime filterCompletedAtGte);

        _FinalStage filterCompletedAtGte(Nullable<OffsetDateTime> filterCompletedAtGte);

        _FinalStage filterCompletedAtLte(Optional<OffsetDateTime> filterCompletedAtLte);

        _FinalStage filterCompletedAtLte(OffsetDateTime filterCompletedAtLte);

        _FinalStage filterCompletedAtLte(Nullable<OffsetDateTime> filterCompletedAtLte);

        _FinalStage filterOrderCancelled(Optional<Boolean> filterOrderCancelled);

        _FinalStage filterOrderCancelled(Boolean filterOrderCancelled);

        _FinalStage filterOrderCancelled(Nullable<Boolean> filterOrderCancelled);

        _FinalStage filterCompleted(Optional<Boolean> filterCompleted);

        _FinalStage filterCompleted(Boolean filterCompleted);

        _FinalStage filterCompleted(Nullable<Boolean> filterCompleted);

        _FinalStage filterPaused(Optional<Boolean> filterPaused);

        _FinalStage filterPaused(Boolean filterPaused);

        _FinalStage filterPaused(Nullable<Boolean> filterPaused);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BodyStage, _FinalStage {
        private TaskGroupExpandedForCourierAdministratorReq body;

        private Optional<Boolean> filterPaused = Optional.empty();

        private Optional<Boolean> filterCompleted = Optional.empty();

        private Optional<Boolean> filterOrderCancelled = Optional.empty();

        private Optional<OffsetDateTime> filterCompletedAtLte = Optional.empty();

        private Optional<OffsetDateTime> filterCompletedAtGte = Optional.empty();

        private Optional<OffsetDateTime> filterStartedAtLte = Optional.empty();

        private Optional<OffsetDateTime> filterStartedAtGte = Optional.empty();

        private Optional<OffsetDateTime> filterCreatedAtLte = Optional.empty();

        private Optional<OffsetDateTime> filterCreatedAtGte = Optional.empty();

        private Optional<SortOrderEnum> sortOrder = Optional.empty();

        private Optional<TaskGroupExpandedSortFieldEnum> sortBy = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<List<TaskGroupStatusEnum1>> filterStatuses = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ExpandedListForCourierAdministratorV1Request other) {
            filterStatuses(other.getFilterStatuses());
            page(other.getPage());
            pageSize(other.getPageSize());
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            filterCreatedAtGte(other.getFilterCreatedAtGte());
            filterCreatedAtLte(other.getFilterCreatedAtLte());
            filterStartedAtGte(other.getFilterStartedAtGte());
            filterStartedAtLte(other.getFilterStartedAtLte());
            filterCompletedAtGte(other.getFilterCompletedAtGte());
            filterCompletedAtLte(other.getFilterCompletedAtLte());
            filterOrderCancelled(other.getFilterOrderCancelled());
            filterCompleted(other.getFilterCompleted());
            filterPaused(other.getFilterPaused());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull TaskGroupExpandedForCourierAdministratorReq body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage filterPaused(Nullable<Boolean> filterPaused) {
            if (filterPaused.isNull()) {
                this.filterPaused = null;
            } else if (filterPaused.isEmpty()) {
                this.filterPaused = Optional.empty();
            } else {
                this.filterPaused = Optional.of(filterPaused.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterPaused(Boolean filterPaused) {
            this.filterPaused = Optional.ofNullable(filterPaused);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_paused", nulls = Nulls.SKIP)
        public _FinalStage filterPaused(Optional<Boolean> filterPaused) {
            this.filterPaused = filterPaused;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompleted(Nullable<Boolean> filterCompleted) {
            if (filterCompleted.isNull()) {
                this.filterCompleted = null;
            } else if (filterCompleted.isEmpty()) {
                this.filterCompleted = Optional.empty();
            } else {
                this.filterCompleted = Optional.of(filterCompleted.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompleted(Boolean filterCompleted) {
            this.filterCompleted = Optional.ofNullable(filterCompleted);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed", nulls = Nulls.SKIP)
        public _FinalStage filterCompleted(Optional<Boolean> filterCompleted) {
            this.filterCompleted = filterCompleted;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelled(Nullable<Boolean> filterOrderCancelled) {
            if (filterOrderCancelled.isNull()) {
                this.filterOrderCancelled = null;
            } else if (filterOrderCancelled.isEmpty()) {
                this.filterOrderCancelled = Optional.empty();
            } else {
                this.filterOrderCancelled = Optional.of(filterOrderCancelled.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelled(Boolean filterOrderCancelled) {
            this.filterOrderCancelled = Optional.ofNullable(filterOrderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage filterOrderCancelled(Optional<Boolean> filterOrderCancelled) {
            this.filterOrderCancelled = filterOrderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtLte(Nullable<OffsetDateTime> filterCompletedAtLte) {
            if (filterCompletedAtLte.isNull()) {
                this.filterCompletedAtLte = null;
            } else if (filterCompletedAtLte.isEmpty()) {
                this.filterCompletedAtLte = Optional.empty();
            } else {
                this.filterCompletedAtLte = Optional.of(filterCompletedAtLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtLte(OffsetDateTime filterCompletedAtLte) {
            this.filterCompletedAtLte = Optional.ofNullable(filterCompletedAtLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed_at_lte", nulls = Nulls.SKIP)
        public _FinalStage filterCompletedAtLte(Optional<OffsetDateTime> filterCompletedAtLte) {
            this.filterCompletedAtLte = filterCompletedAtLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtGte(Nullable<OffsetDateTime> filterCompletedAtGte) {
            if (filterCompletedAtGte.isNull()) {
                this.filterCompletedAtGte = null;
            } else if (filterCompletedAtGte.isEmpty()) {
                this.filterCompletedAtGte = Optional.empty();
            } else {
                this.filterCompletedAtGte = Optional.of(filterCompletedAtGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtGte(OffsetDateTime filterCompletedAtGte) {
            this.filterCompletedAtGte = Optional.ofNullable(filterCompletedAtGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed_at_gte", nulls = Nulls.SKIP)
        public _FinalStage filterCompletedAtGte(Optional<OffsetDateTime> filterCompletedAtGte) {
            this.filterCompletedAtGte = filterCompletedAtGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStartedAtLte(Nullable<OffsetDateTime> filterStartedAtLte) {
            if (filterStartedAtLte.isNull()) {
                this.filterStartedAtLte = null;
            } else if (filterStartedAtLte.isEmpty()) {
                this.filterStartedAtLte = Optional.empty();
            } else {
                this.filterStartedAtLte = Optional.of(filterStartedAtLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStartedAtLte(OffsetDateTime filterStartedAtLte) {
            this.filterStartedAtLte = Optional.ofNullable(filterStartedAtLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_started_at_lte", nulls = Nulls.SKIP)
        public _FinalStage filterStartedAtLte(Optional<OffsetDateTime> filterStartedAtLte) {
            this.filterStartedAtLte = filterStartedAtLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStartedAtGte(Nullable<OffsetDateTime> filterStartedAtGte) {
            if (filterStartedAtGte.isNull()) {
                this.filterStartedAtGte = null;
            } else if (filterStartedAtGte.isEmpty()) {
                this.filterStartedAtGte = Optional.empty();
            } else {
                this.filterStartedAtGte = Optional.of(filterStartedAtGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStartedAtGte(OffsetDateTime filterStartedAtGte) {
            this.filterStartedAtGte = Optional.ofNullable(filterStartedAtGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_started_at_gte", nulls = Nulls.SKIP)
        public _FinalStage filterStartedAtGte(Optional<OffsetDateTime> filterStartedAtGte) {
            this.filterStartedAtGte = filterStartedAtGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCreatedAtLte(Nullable<OffsetDateTime> filterCreatedAtLte) {
            if (filterCreatedAtLte.isNull()) {
                this.filterCreatedAtLte = null;
            } else if (filterCreatedAtLte.isEmpty()) {
                this.filterCreatedAtLte = Optional.empty();
            } else {
                this.filterCreatedAtLte = Optional.of(filterCreatedAtLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCreatedAtLte(OffsetDateTime filterCreatedAtLte) {
            this.filterCreatedAtLte = Optional.ofNullable(filterCreatedAtLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_created_at_lte", nulls = Nulls.SKIP)
        public _FinalStage filterCreatedAtLte(Optional<OffsetDateTime> filterCreatedAtLte) {
            this.filterCreatedAtLte = filterCreatedAtLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCreatedAtGte(Nullable<OffsetDateTime> filterCreatedAtGte) {
            if (filterCreatedAtGte.isNull()) {
                this.filterCreatedAtGte = null;
            } else if (filterCreatedAtGte.isEmpty()) {
                this.filterCreatedAtGte = Optional.empty();
            } else {
                this.filterCreatedAtGte = Optional.of(filterCreatedAtGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCreatedAtGte(OffsetDateTime filterCreatedAtGte) {
            this.filterCreatedAtGte = Optional.ofNullable(filterCreatedAtGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_created_at_gte", nulls = Nulls.SKIP)
        public _FinalStage filterCreatedAtGte(Optional<OffsetDateTime> filterCreatedAtGte) {
            this.filterCreatedAtGte = filterCreatedAtGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(Nullable<SortOrderEnum> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(SortOrderEnum sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public _FinalStage sortOrder(Optional<SortOrderEnum> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(Nullable<TaskGroupExpandedSortFieldEnum> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(TaskGroupExpandedSortFieldEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public _FinalStage sortBy(Optional<TaskGroupExpandedSortFieldEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public _FinalStage pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatuses(TaskGroupStatusEnum1 filterStatuses) {
            this.filterStatuses = Optional.of(Collections.singletonList(filterStatuses));
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatuses(Nullable<List<TaskGroupStatusEnum1>> filterStatuses) {
            if (filterStatuses.isNull()) {
                this.filterStatuses = null;
            } else if (filterStatuses.isEmpty()) {
                this.filterStatuses = Optional.empty();
            } else {
                this.filterStatuses = Optional.of(filterStatuses.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatuses(List<TaskGroupStatusEnum1> filterStatuses) {
            this.filterStatuses = Optional.ofNullable(filterStatuses);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_statuses", nulls = Nulls.SKIP)
        public _FinalStage filterStatuses(Optional<List<TaskGroupStatusEnum1>> filterStatuses) {
            this.filterStatuses = filterStatuses;
            return this;
        }

        @java.lang.Override
        public ExpandedListForCourierAdministratorV1Request build() {
            return new ExpandedListForCourierAdministratorV1Request(
                    filterStatuses,
                    page,
                    pageSize,
                    sortBy,
                    sortOrder,
                    filterCreatedAtGte,
                    filterCreatedAtLte,
                    filterStartedAtGte,
                    filterStartedAtLte,
                    filterCompletedAtGte,
                    filterCompletedAtLte,
                    filterOrderCancelled,
                    filterCompleted,
                    filterPaused,
                    body,
                    additionalProperties);
        }
    }
}
