/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateTaskGroupReq.Builder.class)
public final class UpdateTaskGroupReq {
    private final String taskGroupId;

    private final Optional<String> setDriverId;

    private final Optional<Boolean> removeDriver;

    private final Map<String, Object> additionalProperties;

    private UpdateTaskGroupReq(
            String taskGroupId,
            Optional<String> setDriverId,
            Optional<Boolean> removeDriver,
            Map<String, Object> additionalProperties) {
        this.taskGroupId = taskGroupId;
        this.setDriverId = setDriverId;
        this.removeDriver = removeDriver;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonIgnore
    public Optional<String> getSetDriverId() {
        if (setDriverId == null) {
            return Optional.empty();
        }
        return setDriverId;
    }

    @JsonProperty("remove_driver")
    public Optional<Boolean> getRemoveDriver() {
        return removeDriver;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("set_driver_id")
    private Optional<String> _getSetDriverId() {
        return setDriverId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateTaskGroupReq && equalTo((UpdateTaskGroupReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTaskGroupReq other) {
        return taskGroupId.equals(other.taskGroupId)
                && setDriverId.equals(other.setDriverId)
                && removeDriver.equals(other.removeDriver);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskGroupId, this.setDriverId, this.removeDriver);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupIdStage builder() {
        return new Builder();
    }

    public interface TaskGroupIdStage {
        _FinalStage taskGroupId(@NotNull String taskGroupId);

        Builder from(UpdateTaskGroupReq other);
    }

    public interface _FinalStage {
        UpdateTaskGroupReq build();

        _FinalStage setDriverId(Optional<String> setDriverId);

        _FinalStage setDriverId(String setDriverId);

        _FinalStage setDriverId(Nullable<String> setDriverId);

        _FinalStage removeDriver(Optional<Boolean> removeDriver);

        _FinalStage removeDriver(Boolean removeDriver);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupIdStage, _FinalStage {
        private String taskGroupId;

        private Optional<Boolean> removeDriver = Optional.empty();

        private Optional<String> setDriverId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateTaskGroupReq other) {
            taskGroupId(other.getTaskGroupId());
            setDriverId(other.getSetDriverId());
            removeDriver(other.getRemoveDriver());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage removeDriver(Boolean removeDriver) {
            this.removeDriver = Optional.ofNullable(removeDriver);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "remove_driver", nulls = Nulls.SKIP)
        public _FinalStage removeDriver(Optional<Boolean> removeDriver) {
            this.removeDriver = removeDriver;
            return this;
        }

        @java.lang.Override
        public _FinalStage setDriverId(Nullable<String> setDriverId) {
            if (setDriverId.isNull()) {
                this.setDriverId = null;
            } else if (setDriverId.isEmpty()) {
                this.setDriverId = Optional.empty();
            } else {
                this.setDriverId = Optional.of(setDriverId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage setDriverId(String setDriverId) {
            this.setDriverId = Optional.ofNullable(setDriverId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "set_driver_id", nulls = Nulls.SKIP)
        public _FinalStage setDriverId(Optional<String> setDriverId) {
            this.setDriverId = setDriverId;
            return this;
        }

        @java.lang.Override
        public UpdateTaskGroupReq build() {
            return new UpdateTaskGroupReq(taskGroupId, setDriverId, removeDriver, additionalProperties);
        }
    }
}
