/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.tracking.cargobydevice.AsyncCargoByDeviceClient;
import com.chrt.api.resources.tracking.cargobydriver.AsyncCargoByDriverClient;
import com.chrt.api.resources.tracking.devices.AsyncDevicesClient;
import com.chrt.api.resources.tracking.driver.AsyncDriverClient;
import com.chrt.api.resources.tracking.sessionbydevice.AsyncSessionByDeviceClient;
import com.chrt.api.resources.tracking.taskgroupbydriver.AsyncTaskGroupByDriverClient;
import java.util.function.Supplier;

public class AsyncTrackingClient {
    protected final ClientOptions clientOptions;

    protected final Supplier<AsyncCargoByDeviceClient> cargoByDeviceClient;

    protected final Supplier<AsyncCargoByDriverClient> cargoByDriverClient;

    protected final Supplier<AsyncDevicesClient> devicesClient;

    protected final Supplier<AsyncDriverClient> driverClient;

    protected final Supplier<AsyncSessionByDeviceClient> sessionByDeviceClient;

    protected final Supplier<AsyncTaskGroupByDriverClient> taskGroupByDriverClient;

    public AsyncTrackingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.cargoByDeviceClient = Suppliers.memoize(() -> new AsyncCargoByDeviceClient(clientOptions));
        this.cargoByDriverClient = Suppliers.memoize(() -> new AsyncCargoByDriverClient(clientOptions));
        this.devicesClient = Suppliers.memoize(() -> new AsyncDevicesClient(clientOptions));
        this.driverClient = Suppliers.memoize(() -> new AsyncDriverClient(clientOptions));
        this.sessionByDeviceClient = Suppliers.memoize(() -> new AsyncSessionByDeviceClient(clientOptions));
        this.taskGroupByDriverClient = Suppliers.memoize(() -> new AsyncTaskGroupByDriverClient(clientOptions));
    }

    public AsyncCargoByDeviceClient cargoByDevice() {
        return this.cargoByDeviceClient.get();
    }

    public AsyncCargoByDriverClient cargoByDriver() {
        return this.cargoByDriverClient.get();
    }

    public AsyncDevicesClient devices() {
        return this.devicesClient.get();
    }

    public AsyncDriverClient driver() {
        return this.driverClient.get();
    }

    public AsyncSessionByDeviceClient sessionByDevice() {
        return this.sessionByDeviceClient.get();
    }

    public AsyncTaskGroupByDriverClient taskGroupByDriver() {
        return this.taskGroupByDriverClient.get();
    }
}
