/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.tracking.cargobydevice.CargoByDeviceClient;
import com.chrt.api.resources.tracking.cargobydriver.CargoByDriverClient;
import com.chrt.api.resources.tracking.devices.DevicesClient;
import com.chrt.api.resources.tracking.driver.DriverClient;
import com.chrt.api.resources.tracking.sessionbydevice.SessionByDeviceClient;
import com.chrt.api.resources.tracking.taskgroupbydriver.TaskGroupByDriverClient;
import java.util.function.Supplier;

public class TrackingClient {
    protected final ClientOptions clientOptions;

    protected final Supplier<CargoByDeviceClient> cargoByDeviceClient;

    protected final Supplier<CargoByDriverClient> cargoByDriverClient;

    protected final Supplier<DevicesClient> devicesClient;

    protected final Supplier<DriverClient> driverClient;

    protected final Supplier<SessionByDeviceClient> sessionByDeviceClient;

    protected final Supplier<TaskGroupByDriverClient> taskGroupByDriverClient;

    public TrackingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.cargoByDeviceClient = Suppliers.memoize(() -> new CargoByDeviceClient(clientOptions));
        this.cargoByDriverClient = Suppliers.memoize(() -> new CargoByDriverClient(clientOptions));
        this.devicesClient = Suppliers.memoize(() -> new DevicesClient(clientOptions));
        this.driverClient = Suppliers.memoize(() -> new DriverClient(clientOptions));
        this.sessionByDeviceClient = Suppliers.memoize(() -> new SessionByDeviceClient(clientOptions));
        this.taskGroupByDriverClient = Suppliers.memoize(() -> new TaskGroupByDriverClient(clientOptions));
    }

    public CargoByDeviceClient cargoByDevice() {
        return this.cargoByDeviceClient.get();
    }

    public CargoByDriverClient cargoByDriver() {
        return this.cargoByDriverClient.get();
    }

    public DevicesClient devices() {
        return this.devicesClient.get();
    }

    public DriverClient driver() {
        return this.driverClient.get();
    }

    public SessionByDeviceClient sessionByDevice() {
        return this.sessionByDeviceClient.get();
    }

    public TaskGroupByDriverClient taskGroupByDriver() {
        return this.taskGroupByDriverClient.get();
    }
}
