/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.cargobydevice;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.cargobydevice.requests.CargoByDeviceLastSeenV1Request;
import com.chrt.api.types.TrackingCargoByDeviceDataPoint1;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCargoByDeviceClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCargoByDeviceClient rawClient;

    public AsyncCargoByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargoByDeviceClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCargoByDeviceClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent device location data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (TrackingCargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<TrackingCargoByDeviceDataPoint1>> lastSeenV1(
            CargoByDeviceLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent device location data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (TrackingCargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<TrackingCargoByDeviceDataPoint1>> lastSeenV1(
            CargoByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }
}
