/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.cargobydevice;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tracking.cargobydevice.requests.CargoByDeviceLastSeenV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.TrackingCargoByDeviceDataPoint1;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawCargoByDeviceClient {
    protected final ClientOptions clientOptions;

    public AsyncRawCargoByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Returns the most recent device location data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (TrackingCargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Optional<TrackingCargoByDeviceDataPoint1>>> lastSeenV1(
            CargoByDeviceLastSeenV1Request request) {
        return lastSeenV1(request, null);
    }

    /**
     * Returns the most recent device location data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (TrackingCargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Optional<TrackingCargoByDeviceDataPoint1>>> lastSeenV1(
            CargoByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/cargo_by_device/last_seen/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "cargo_id", request.getCargoId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "task_group_id", request.getTaskGroupId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Optional<TrackingCargoByDeviceDataPoint1>>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString,
                                        new TypeReference<Optional<TrackingCargoByDeviceDataPoint1>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
