/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.cargobydriver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.cargobydriver.requests.CargoByDriverLastSeenV1Request;
import com.chrt.api.types.TrackingCargoByDriverDataPoint1;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCargoByDriverClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCargoByDriverClient rawClient;

    public AsyncCargoByDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargoByDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCargoByDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent driver location data point for cargo within a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TrackingCargoByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TrackingCargoByDriverDataPoint1>> lastSeenV1(
            CargoByDriverLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for cargo within a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TrackingCargoByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TrackingCargoByDriverDataPoint1>> lastSeenV1(
            CargoByDriverLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }
}
