/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.cargobydriver.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CargoByDriverLastSeenV1Request.Builder.class)
public final class CargoByDriverLastSeenV1Request {
    private final String cargoId;

    private final String taskGroupId;

    private final Map<String, Object> additionalProperties;

    private CargoByDriverLastSeenV1Request(
            String cargoId, String taskGroupId, Map<String, Object> additionalProperties) {
        this.cargoId = cargoId;
        this.taskGroupId = taskGroupId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("cargo_id")
    public String getCargoId() {
        return cargoId;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CargoByDriverLastSeenV1Request && equalTo((CargoByDriverLastSeenV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoByDriverLastSeenV1Request other) {
        return cargoId.equals(other.cargoId) && taskGroupId.equals(other.taskGroupId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.cargoId, this.taskGroupId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CargoIdStage builder() {
        return new Builder();
    }

    public interface CargoIdStage {
        TaskGroupIdStage cargoId(@NotNull String cargoId);

        Builder from(CargoByDriverLastSeenV1Request other);
    }

    public interface TaskGroupIdStage {
        _FinalStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface _FinalStage {
        CargoByDriverLastSeenV1Request build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CargoIdStage, TaskGroupIdStage, _FinalStage {
        private String cargoId;

        private String taskGroupId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CargoByDriverLastSeenV1Request other) {
            cargoId(other.getCargoId());
            taskGroupId(other.getTaskGroupId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_id")
        public TaskGroupIdStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        public CargoByDriverLastSeenV1Request build() {
            return new CargoByDriverLastSeenV1Request(cargoId, taskGroupId, additionalProperties);
        }
    }
}
