/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.devices;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.devices.requests.DevicesDeleteV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesGetV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesLinkToCargoV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesRegisterToOrgReq1;
import com.chrt.api.resources.tracking.devices.requests.DevicesUnlinkFromCargoV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesUpdateRequest1;
import com.chrt.api.types.Device1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncDevicesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDevicesClient rawClient;

    public AsyncDevicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDevicesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDevicesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Registers a tracking device to the authenticated user's organization. If device is already registered to a different organization, registration is blocked. | (DevicesRegisterToOrgReq1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> registerToOrgV1(DevicesRegisterToOrgReq1 request) {
        return this.rawClient.registerToOrgV1(request).thenApply(response -> response.body());
    }

    /**
     * Registers a tracking device to the authenticated user's organization. If device is already registered to a different organization, registration is blocked. | (DevicesRegisterToOrgReq1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> registerToOrgV1(DevicesRegisterToOrgReq1 request, RequestOptions requestOptions) {
        return this.rawClient.registerToOrgV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates a device's type and/or comments. Can update one or both fields, or delete them by setting delete flags. | (DevicesUpdateRequest1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> response.body());
    }

    /**
     * Updates a device's type and/or comments. Can update one or both fields, or delete them by setting delete flags. | (DevicesUpdateRequest1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(DevicesUpdateRequest1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates a device's type and/or comments. Can update one or both fields, or delete them by setting delete flags. | (DevicesUpdateRequest1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(DevicesUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a device by ID or MAC address. Device must be unlinked from any session or cargo before deletion. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1() {
        return this.rawClient.deleteV1().thenApply(response -> response.body());
    }

    /**
     * Deletes a device by ID or MAC address. Device must be unlinked from any session or cargo before deletion. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(DevicesDeleteV1Request request) {
        return this.rawClient.deleteV1(request).thenApply(response -> response.body());
    }

    /**
     * Deletes a device by ID or MAC address. Device must be unlinked from any session or cargo before deletion. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(DevicesDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single device by its MAC address or ID. Access restricted to the device's organization. | () -&gt; (Device1)
     */
    public CompletableFuture<Device1> getV1() {
        return this.rawClient.getV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves a single device by its MAC address or ID. Access restricted to the device's organization. | () -&gt; (Device1)
     */
    public CompletableFuture<Device1> getV1(DevicesGetV1Request request) {
        return this.rawClient.getV1(request).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single device by its MAC address or ID. Access restricted to the device's organization. | () -&gt; (Device1)
     */
    public CompletableFuture<Device1> getV1(DevicesGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns all tracking devices registered to the authenticated user's organization. | () -&gt; (list[Device1])
     */
    public CompletableFuture<List<Device1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Returns all tracking devices registered to the authenticated user's organization. | () -&gt; (list[Device1])
     */
    public CompletableFuture<List<Device1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Links a device to cargo with bidirectional references. Device must not already be linked to a session or different cargo. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> linkToCargoV1(DevicesLinkToCargoV1Request request) {
        return this.rawClient.linkToCargoV1(request).thenApply(response -> response.body());
    }

    /**
     * Links a device to cargo with bidirectional references. Device must not already be linked to a session or different cargo. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> linkToCargoV1(
            DevicesLinkToCargoV1Request request, RequestOptions requestOptions) {
        return this.rawClient.linkToCargoV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Unlinks a device from its linked cargo, removing the bidirectional reference. Returns false if device is not linked to any cargo. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> unlinkFromCargoV1(DevicesUnlinkFromCargoV1Request request) {
        return this.rawClient.unlinkFromCargoV1(request).thenApply(response -> response.body());
    }

    /**
     * Unlinks a device from its linked cargo, removing the bidirectional reference. Returns false if device is not linked to any cargo. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> unlinkFromCargoV1(
            DevicesUnlinkFromCargoV1Request request, RequestOptions requestOptions) {
        return this.rawClient.unlinkFromCargoV1(request, requestOptions).thenApply(response -> response.body());
    }
}
