/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.devices;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.devices.requests.DevicesDeleteV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesGetV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesLinkToCargoV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesRegisterToOrgReq1;
import com.chrt.api.resources.tracking.devices.requests.DevicesUnlinkFromCargoV1Request;
import com.chrt.api.resources.tracking.devices.requests.DevicesUpdateRequest1;
import com.chrt.api.types.Device1;
import java.util.List;

public class DevicesClient {
    protected final ClientOptions clientOptions;

    private final RawDevicesClient rawClient;

    public DevicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDevicesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawDevicesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Registers a tracking device to the authenticated user's organization. If device is already registered to a different organization, registration is blocked. | (DevicesRegisterToOrgReq1) -&gt; (PydanticObjectId)
     */
    public String registerToOrgV1(DevicesRegisterToOrgReq1 request) {
        return this.rawClient.registerToOrgV1(request).body();
    }

    /**
     * Registers a tracking device to the authenticated user's organization. If device is already registered to a different organization, registration is blocked. | (DevicesRegisterToOrgReq1) -&gt; (PydanticObjectId)
     */
    public String registerToOrgV1(DevicesRegisterToOrgReq1 request, RequestOptions requestOptions) {
        return this.rawClient.registerToOrgV1(request, requestOptions).body();
    }

    /**
     * Updates a device's type and/or comments. Can update one or both fields, or delete them by setting delete flags. | (DevicesUpdateRequest1) -&gt; (bool)
     */
    public boolean updateV1() {
        return this.rawClient.updateV1().body();
    }

    /**
     * Updates a device's type and/or comments. Can update one or both fields, or delete them by setting delete flags. | (DevicesUpdateRequest1) -&gt; (bool)
     */
    public boolean updateV1(DevicesUpdateRequest1 request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates a device's type and/or comments. Can update one or both fields, or delete them by setting delete flags. | (DevicesUpdateRequest1) -&gt; (bool)
     */
    public boolean updateV1(DevicesUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    /**
     * Deletes a device by ID or MAC address. Device must be unlinked from any session or cargo before deletion. | () -&gt; (bool)
     */
    public boolean deleteV1() {
        return this.rawClient.deleteV1().body();
    }

    /**
     * Deletes a device by ID or MAC address. Device must be unlinked from any session or cargo before deletion. | () -&gt; (bool)
     */
    public boolean deleteV1(DevicesDeleteV1Request request) {
        return this.rawClient.deleteV1(request).body();
    }

    /**
     * Deletes a device by ID or MAC address. Device must be unlinked from any session or cargo before deletion. | () -&gt; (bool)
     */
    public boolean deleteV1(DevicesDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).body();
    }

    /**
     * Retrieves a single device by its MAC address or ID. Access restricted to the device's organization. | () -&gt; (Device1)
     */
    public Device1 getV1() {
        return this.rawClient.getV1().body();
    }

    /**
     * Retrieves a single device by its MAC address or ID. Access restricted to the device's organization. | () -&gt; (Device1)
     */
    public Device1 getV1(DevicesGetV1Request request) {
        return this.rawClient.getV1(request).body();
    }

    /**
     * Retrieves a single device by its MAC address or ID. Access restricted to the device's organization. | () -&gt; (Device1)
     */
    public Device1 getV1(DevicesGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).body();
    }

    /**
     * Returns all tracking devices registered to the authenticated user's organization. | () -&gt; (list[Device1])
     */
    public List<Device1> listV1() {
        return this.rawClient.listV1().body();
    }

    /**
     * Returns all tracking devices registered to the authenticated user's organization. | () -&gt; (list[Device1])
     */
    public List<Device1> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).body();
    }

    /**
     * Links a device to cargo with bidirectional references. Device must not already be linked to a session or different cargo. | () -&gt; (bool)
     */
    public boolean linkToCargoV1(DevicesLinkToCargoV1Request request) {
        return this.rawClient.linkToCargoV1(request).body();
    }

    /**
     * Links a device to cargo with bidirectional references. Device must not already be linked to a session or different cargo. | () -&gt; (bool)
     */
    public boolean linkToCargoV1(DevicesLinkToCargoV1Request request, RequestOptions requestOptions) {
        return this.rawClient.linkToCargoV1(request, requestOptions).body();
    }

    /**
     * Unlinks a device from its linked cargo, removing the bidirectional reference. Returns false if device is not linked to any cargo. | () -&gt; (bool)
     */
    public boolean unlinkFromCargoV1(DevicesUnlinkFromCargoV1Request request) {
        return this.rawClient.unlinkFromCargoV1(request).body();
    }

    /**
     * Unlinks a device from its linked cargo, removing the bidirectional reference. Returns false if device is not linked to any cargo. | () -&gt; (bool)
     */
    public boolean unlinkFromCargoV1(DevicesUnlinkFromCargoV1Request request, RequestOptions requestOptions) {
        return this.rawClient.unlinkFromCargoV1(request, requestOptions).body();
    }
}
