/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.driver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.driver.requests.DriverUpdateReq;
import com.chrt.api.types.DriverUpdateRes;
import java.util.concurrent.CompletableFuture;

public class AsyncDriverClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDriverClient rawClient;

    public AsyncDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Records driver location updates for a task group. Automatically writes to task group tracking if IN_PROGRESS and cargo tracking if IN_TRANSIT. Updates driver's last seen timestamp and location. | (DriverUpdateReq) -&gt; (DriverUpdateRes)
     */
    public CompletableFuture<DriverUpdateRes> updateV1(DriverUpdateReq request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Records driver location updates for a task group. Automatically writes to task group tracking if IN_PROGRESS and cargo tracking if IN_TRANSIT. Updates driver's last seen timestamp and location. | (DriverUpdateReq) -&gt; (DriverUpdateRes)
     */
    public CompletableFuture<DriverUpdateRes> updateV1(DriverUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }
}
