/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sessionbydevice;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceCreateSessionRequest1;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceDataPointsV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceDeleteV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceGetV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceLastSeenV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceMarkOutliersRequest1;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDevicePauseRecordingV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceResumeRecordingV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceStartV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceTerminateV1Request;
import com.chrt.api.resources.tracking.sessionbydevice.requests.SessionByDeviceUpdateRequest1;
import com.chrt.api.types.Session1;
import com.chrt.api.types.SessionByDeviceDeleteResponse1;
import com.chrt.api.types.SessionByDeviceMarkOutliersResponse1;
import com.chrt.api.types.TrackingSessionByDeviceDataPoint1;
import java.util.List;
import java.util.Optional;

public class SessionByDeviceClient {
    protected final ClientOptions clientOptions;

    private final RawSessionByDeviceClient rawClient;

    public SessionByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSessionByDeviceClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawSessionByDeviceClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns all tracking sessions for the authenticated user's organization. | () -&gt; (list[Session1])
     */
    public List<Session1> listV1() {
        return this.rawClient.listV1().body();
    }

    /**
     * Returns all tracking sessions for the authenticated user's organization. | () -&gt; (list[Session1])
     */
    public List<Session1> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).body();
    }

    /**
     * Retrieves a single session by its ID. Access restricted to the session's organization. | () -&gt; (Session1)
     */
    public Session1 getV1(SessionByDeviceGetV1Request request) {
        return this.rawClient.getV1(request).body();
    }

    /**
     * Retrieves a single session by its ID. Access restricted to the session's organization. | () -&gt; (Session1)
     */
    public Session1 getV1(SessionByDeviceGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).body();
    }

    /**
     * Returns the most recent data point for a session, excluding outliers. Access restricted to the session's organization. | () -&gt; (TrackingSessionByDeviceDataPoint1 | None)
     */
    public Optional<TrackingSessionByDeviceDataPoint1> lastSeenV1(SessionByDeviceLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).body();
    }

    /**
     * Returns the most recent data point for a session, excluding outliers. Access restricted to the session's organization. | () -&gt; (TrackingSessionByDeviceDataPoint1 | None)
     */
    public Optional<TrackingSessionByDeviceDataPoint1> lastSeenV1(
            SessionByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).body();
    }

    /**
     * Returns up to the specified number of data points for a session, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[TrackingSessionByDeviceDataPoint1])
     */
    public List<TrackingSessionByDeviceDataPoint1> dataPointsV1(SessionByDeviceDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).body();
    }

    /**
     * Returns up to the specified number of data points for a session, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[TrackingSessionByDeviceDataPoint1])
     */
    public List<TrackingSessionByDeviceDataPoint1> dataPointsV1(
            SessionByDeviceDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).body();
    }

    /**
     * Creates a new tracking session for a device and links the device to it. The device must be registered to the caller's organization. | (SessionByDeviceCreateSessionRequest1) -&gt; (PydanticObjectId)
     */
    public String createSessionV1(SessionByDeviceCreateSessionRequest1 request) {
        return this.rawClient.createSessionV1(request).body();
    }

    /**
     * Creates a new tracking session for a device and links the device to it. The device must be registered to the caller's organization. | (SessionByDeviceCreateSessionRequest1) -&gt; (PydanticObjectId)
     */
    public String createSessionV1(SessionByDeviceCreateSessionRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.createSessionV1(request, requestOptions).body();
    }

    /**
     * Updates a session's comments and/or public visibility status. Can update one or both fields. | (SessionByDeviceUpdateRequest1) -&gt; (bool)
     */
    public boolean updateV1(SessionByDeviceUpdateRequest1 request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates a session's comments and/or public visibility status. Can update one or both fields. | (SessionByDeviceUpdateRequest1) -&gt; (bool)
     */
    public boolean updateV1(SessionByDeviceUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    /**
     * Starts location recording for a session by setting recording status to true. Sets the recording initiated timestamp on first start. | () -&gt; (bool)
     */
    public boolean startV1(SessionByDeviceStartV1Request request) {
        return this.rawClient.startV1(request).body();
    }

    /**
     * Starts location recording for a session by setting recording status to true. Sets the recording initiated timestamp on first start. | () -&gt; (bool)
     */
    public boolean startV1(SessionByDeviceStartV1Request request, RequestOptions requestOptions) {
        return this.rawClient.startV1(request, requestOptions).body();
    }

    /**
     * Pauses location recording for a session by setting recording status to false. Device remains linked to the session. | () -&gt; (bool)
     */
    public boolean pauseRecordingV1(SessionByDevicePauseRecordingV1Request request) {
        return this.rawClient.pauseRecordingV1(request).body();
    }

    /**
     * Pauses location recording for a session by setting recording status to false. Device remains linked to the session. | () -&gt; (bool)
     */
    public boolean pauseRecordingV1(SessionByDevicePauseRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.pauseRecordingV1(request, requestOptions).body();
    }

    /**
     * Resumes location recording for a session by setting recording status to true. | () -&gt; (bool)
     */
    public boolean resumeRecordingV1(SessionByDeviceResumeRecordingV1Request request) {
        return this.rawClient.resumeRecordingV1(request).body();
    }

    /**
     * Resumes location recording for a session by setting recording status to true. | () -&gt; (bool)
     */
    public boolean resumeRecordingV1(SessionByDeviceResumeRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.resumeRecordingV1(request, requestOptions).body();
    }

    /**
     * Terminates a session by setting recording to false and marking it as terminated. Unlinks the device from the session. | () -&gt; (bool)
     */
    public boolean terminateV1(SessionByDeviceTerminateV1Request request) {
        return this.rawClient.terminateV1(request).body();
    }

    /**
     * Terminates a session by setting recording to false and marking it as terminated. Unlinks the device from the session. | () -&gt; (bool)
     */
    public boolean terminateV1(SessionByDeviceTerminateV1Request request, RequestOptions requestOptions) {
        return this.rawClient.terminateV1(request, requestOptions).body();
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | (SessionByDeviceMarkOutliersRequest1) -&gt; (SessionByDeviceMarkOutliersResponse1)
     */
    public SessionByDeviceMarkOutliersResponse1 outlierV1(SessionByDeviceMarkOutliersRequest1 request) {
        return this.rawClient.outlierV1(request).body();
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | (SessionByDeviceMarkOutliersRequest1) -&gt; (SessionByDeviceMarkOutliersResponse1)
     */
    public SessionByDeviceMarkOutliersResponse1 outlierV1(
            SessionByDeviceMarkOutliersRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.outlierV1(request, requestOptions).body();
    }

    /**
     * Deletes a terminated session and all its associated timeseries data points. Only sessions marked as terminated can be deleted. | () -&gt; (SessionByDeviceDeleteResponse1)
     */
    public SessionByDeviceDeleteResponse1 deleteV1(SessionByDeviceDeleteV1Request request) {
        return this.rawClient.deleteV1(request).body();
    }

    /**
     * Deletes a terminated session and all its associated timeseries data points. Only sessions marked as terminated can be deleted. | () -&gt; (SessionByDeviceDeleteResponse1)
     */
    public SessionByDeviceDeleteResponse1 deleteV1(
            SessionByDeviceDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).body();
    }

    /**
     * Returns the most recent data point for a public session, excluding outliers. No authentication required if session has public visibility enabled. | () -&gt; (TrackingSessionByDeviceDataPoint1 | None)
     */
    public Optional<TrackingSessionByDeviceDataPoint1> lastSeenPublicV1(
            SessionByDeviceLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).body();
    }

    /**
     * Returns the most recent data point for a public session, excluding outliers. No authentication required if session has public visibility enabled. | () -&gt; (TrackingSessionByDeviceDataPoint1 | None)
     */
    public Optional<TrackingSessionByDeviceDataPoint1> lastSeenPublicV1(
            SessionByDeviceLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).body();
    }

    /**
     * Returns up to the specified number of data points for a public session, intelligently sampled across the time range. Excludes outliers. No authentication required if session has public visibility enabled. | () -&gt; (list[TrackingSessionByDeviceDataPoint1])
     */
    public List<TrackingSessionByDeviceDataPoint1> dataPointsPublicV1(
            SessionByDeviceDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).body();
    }

    /**
     * Returns up to the specified number of data points for a public session, intelligently sampled across the time range. Excludes outliers. No authentication required if session has public visibility enabled. | () -&gt; (list[TrackingSessionByDeviceDataPoint1])
     */
    public List<TrackingSessionByDeviceDataPoint1> dataPointsPublicV1(
            SessionByDeviceDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).body();
    }
}
