/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.taskgroupbydriver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.taskgroupbydriver.requests.TaskGroupByDriverLastSeenV1Request;
import com.chrt.api.types.TrackingTaskGroupByDriverDataPoint1;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskGroupByDriverClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupByDriverClient rawClient;

    public AsyncTaskGroupByDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupByDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupByDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent driver location data point for a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TrackingTaskGroupByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TrackingTaskGroupByDriverDataPoint1>> lastSeenV1(
            TaskGroupByDriverLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TrackingTaskGroupByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TrackingTaskGroupByDriverDataPoint1>> lastSeenV1(
            TaskGroupByDriverLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }
}
