/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.taskgroupbydriver;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tracking.taskgroupbydriver.requests.TaskGroupByDriverLastSeenV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.TrackingTaskGroupByDriverDataPoint1;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawTaskGroupByDriverClient {
    protected final ClientOptions clientOptions;

    public RawTaskGroupByDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Returns the most recent driver location data point for a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TrackingTaskGroupByDriverDataPoint1 | None)
     */
    public ChrtApiHttpResponse<Optional<TrackingTaskGroupByDriverDataPoint1>> lastSeenV1(
            TaskGroupByDriverLastSeenV1Request request) {
        return lastSeenV1(request, null);
    }

    /**
     * Returns the most recent driver location data point for a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TrackingTaskGroupByDriverDataPoint1 | None)
     */
    public ChrtApiHttpResponse<Optional<TrackingTaskGroupByDriverDataPoint1>> lastSeenV1(
            TaskGroupByDriverLastSeenV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/task_group_by_driver/last_seen/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "task_group_id", request.getTaskGroupId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString,
                                new TypeReference<Optional<TrackingTaskGroupByDriverDataPoint1>>() {}),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
