/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.utils.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UtilsGetTimezoneV1Request.Builder.class)
public final class UtilsGetTimezoneV1Request {
    private final double lat;

    private final double lng;

    private final Map<String, Object> additionalProperties;

    private UtilsGetTimezoneV1Request(double lat, double lng, Map<String, Object> additionalProperties) {
        this.lat = lat;
        this.lng = lng;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Latitude in decimal degrees (range: -90 to 90)
     */
    @JsonProperty("lat")
    public double getLat() {
        return lat;
    }

    /**
     * @return Longitude in decimal degrees (range: -180 to 180)
     */
    @JsonProperty("lng")
    public double getLng() {
        return lng;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UtilsGetTimezoneV1Request && equalTo((UtilsGetTimezoneV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UtilsGetTimezoneV1Request other) {
        return lat == other.lat && lng == other.lng;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.lat, this.lng);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LatStage builder() {
        return new Builder();
    }

    public interface LatStage {
        /**
         * <p>Latitude in decimal degrees (range: -90 to 90)</p>
         */
        LngStage lat(double lat);

        Builder from(UtilsGetTimezoneV1Request other);
    }

    public interface LngStage {
        /**
         * <p>Longitude in decimal degrees (range: -180 to 180)</p>
         */
        _FinalStage lng(double lng);
    }

    public interface _FinalStage {
        UtilsGetTimezoneV1Request build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LatStage, LngStage, _FinalStage {
        private double lat;

        private double lng;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UtilsGetTimezoneV1Request other) {
            lat(other.getLat());
            lng(other.getLng());
            return this;
        }

        /**
         * <p>Latitude in decimal degrees (range: -90 to 90)</p>
         * <p>Latitude in decimal degrees (range: -90 to 90)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("lat")
        public LngStage lat(double lat) {
            this.lat = lat;
            return this;
        }

        /**
         * <p>Longitude in decimal degrees (range: -180 to 180)</p>
         * <p>Longitude in decimal degrees (range: -180 to 180)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("lng")
        public _FinalStage lng(double lng) {
            this.lng = lng;
            return this;
        }

        @java.lang.Override
        public UtilsGetTimezoneV1Request build() {
            return new UtilsGetTimezoneV1Request(lat, lng, additionalProperties);
        }
    }
}
