/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CargoClientUpdate1.Builder.class)
public final class CargoClientUpdate1 {
    private final Optional<CargoTypeEnum1> cargoType;

    private final Optional<Integer> quantity;

    private final Optional<Double> weightPounds;

    private final Optional<Double> lengthInches;

    private final Optional<Double> widthInches;

    private final Optional<Double> heightInches;

    private final Optional<Boolean> turnable;

    private final Optional<Boolean> stackable;

    private final Optional<String> description;

    private final Map<String, Object> additionalProperties;

    private CargoClientUpdate1(
            Optional<CargoTypeEnum1> cargoType,
            Optional<Integer> quantity,
            Optional<Double> weightPounds,
            Optional<Double> lengthInches,
            Optional<Double> widthInches,
            Optional<Double> heightInches,
            Optional<Boolean> turnable,
            Optional<Boolean> stackable,
            Optional<String> description,
            Map<String, Object> additionalProperties) {
        this.cargoType = cargoType;
        this.quantity = quantity;
        this.weightPounds = weightPounds;
        this.lengthInches = lengthInches;
        this.widthInches = widthInches;
        this.heightInches = heightInches;
        this.turnable = turnable;
        this.stackable = stackable;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<CargoTypeEnum1> getCargoType() {
        if (cargoType == null) {
            return Optional.empty();
        }
        return cargoType;
    }

    @JsonIgnore
    public Optional<Integer> getQuantity() {
        if (quantity == null) {
            return Optional.empty();
        }
        return quantity;
    }

    @JsonIgnore
    public Optional<Double> getWeightPounds() {
        if (weightPounds == null) {
            return Optional.empty();
        }
        return weightPounds;
    }

    @JsonIgnore
    public Optional<Double> getLengthInches() {
        if (lengthInches == null) {
            return Optional.empty();
        }
        return lengthInches;
    }

    @JsonIgnore
    public Optional<Double> getWidthInches() {
        if (widthInches == null) {
            return Optional.empty();
        }
        return widthInches;
    }

    @JsonIgnore
    public Optional<Double> getHeightInches() {
        if (heightInches == null) {
            return Optional.empty();
        }
        return heightInches;
    }

    @JsonIgnore
    public Optional<Boolean> getTurnable() {
        if (turnable == null) {
            return Optional.empty();
        }
        return turnable;
    }

    @JsonIgnore
    public Optional<Boolean> getStackable() {
        if (stackable == null) {
            return Optional.empty();
        }
        return stackable;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (description == null) {
            return Optional.empty();
        }
        return description;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargo_type")
    private Optional<CargoTypeEnum1> _getCargoType() {
        return cargoType;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("quantity")
    private Optional<Integer> _getQuantity() {
        return quantity;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("weight_pounds")
    private Optional<Double> _getWeightPounds() {
        return weightPounds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("length_inches")
    private Optional<Double> _getLengthInches() {
        return lengthInches;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("width_inches")
    private Optional<Double> _getWidthInches() {
        return widthInches;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("height_inches")
    private Optional<Double> _getHeightInches() {
        return heightInches;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("turnable")
    private Optional<Boolean> _getTurnable() {
        return turnable;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stackable")
    private Optional<Boolean> _getStackable() {
        return stackable;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("description")
    private Optional<String> _getDescription() {
        return description;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CargoClientUpdate1 && equalTo((CargoClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoClientUpdate1 other) {
        return cargoType.equals(other.cargoType)
                && quantity.equals(other.quantity)
                && weightPounds.equals(other.weightPounds)
                && lengthInches.equals(other.lengthInches)
                && widthInches.equals(other.widthInches)
                && heightInches.equals(other.heightInches)
                && turnable.equals(other.turnable)
                && stackable.equals(other.stackable)
                && description.equals(other.description);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.cargoType,
                this.quantity,
                this.weightPounds,
                this.lengthInches,
                this.widthInches,
                this.heightInches,
                this.turnable,
                this.stackable,
                this.description);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<CargoTypeEnum1> cargoType = Optional.empty();

        private Optional<Integer> quantity = Optional.empty();

        private Optional<Double> weightPounds = Optional.empty();

        private Optional<Double> lengthInches = Optional.empty();

        private Optional<Double> widthInches = Optional.empty();

        private Optional<Double> heightInches = Optional.empty();

        private Optional<Boolean> turnable = Optional.empty();

        private Optional<Boolean> stackable = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CargoClientUpdate1 other) {
            cargoType(other.getCargoType());
            quantity(other.getQuantity());
            weightPounds(other.getWeightPounds());
            lengthInches(other.getLengthInches());
            widthInches(other.getWidthInches());
            heightInches(other.getHeightInches());
            turnable(other.getTurnable());
            stackable(other.getStackable());
            description(other.getDescription());
            return this;
        }

        @JsonSetter(value = "cargo_type", nulls = Nulls.SKIP)
        public Builder cargoType(Optional<CargoTypeEnum1> cargoType) {
            this.cargoType = cargoType;
            return this;
        }

        public Builder cargoType(CargoTypeEnum1 cargoType) {
            this.cargoType = Optional.ofNullable(cargoType);
            return this;
        }

        public Builder cargoType(Nullable<CargoTypeEnum1> cargoType) {
            if (cargoType.isNull()) {
                this.cargoType = null;
            } else if (cargoType.isEmpty()) {
                this.cargoType = Optional.empty();
            } else {
                this.cargoType = Optional.of(cargoType.get());
            }
            return this;
        }

        @JsonSetter(value = "quantity", nulls = Nulls.SKIP)
        public Builder quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        public Builder quantity(Nullable<Integer> quantity) {
            if (quantity.isNull()) {
                this.quantity = null;
            } else if (quantity.isEmpty()) {
                this.quantity = Optional.empty();
            } else {
                this.quantity = Optional.of(quantity.get());
            }
            return this;
        }

        @JsonSetter(value = "weight_pounds", nulls = Nulls.SKIP)
        public Builder weightPounds(Optional<Double> weightPounds) {
            this.weightPounds = weightPounds;
            return this;
        }

        public Builder weightPounds(Double weightPounds) {
            this.weightPounds = Optional.ofNullable(weightPounds);
            return this;
        }

        public Builder weightPounds(Nullable<Double> weightPounds) {
            if (weightPounds.isNull()) {
                this.weightPounds = null;
            } else if (weightPounds.isEmpty()) {
                this.weightPounds = Optional.empty();
            } else {
                this.weightPounds = Optional.of(weightPounds.get());
            }
            return this;
        }

        @JsonSetter(value = "length_inches", nulls = Nulls.SKIP)
        public Builder lengthInches(Optional<Double> lengthInches) {
            this.lengthInches = lengthInches;
            return this;
        }

        public Builder lengthInches(Double lengthInches) {
            this.lengthInches = Optional.ofNullable(lengthInches);
            return this;
        }

        public Builder lengthInches(Nullable<Double> lengthInches) {
            if (lengthInches.isNull()) {
                this.lengthInches = null;
            } else if (lengthInches.isEmpty()) {
                this.lengthInches = Optional.empty();
            } else {
                this.lengthInches = Optional.of(lengthInches.get());
            }
            return this;
        }

        @JsonSetter(value = "width_inches", nulls = Nulls.SKIP)
        public Builder widthInches(Optional<Double> widthInches) {
            this.widthInches = widthInches;
            return this;
        }

        public Builder widthInches(Double widthInches) {
            this.widthInches = Optional.ofNullable(widthInches);
            return this;
        }

        public Builder widthInches(Nullable<Double> widthInches) {
            if (widthInches.isNull()) {
                this.widthInches = null;
            } else if (widthInches.isEmpty()) {
                this.widthInches = Optional.empty();
            } else {
                this.widthInches = Optional.of(widthInches.get());
            }
            return this;
        }

        @JsonSetter(value = "height_inches", nulls = Nulls.SKIP)
        public Builder heightInches(Optional<Double> heightInches) {
            this.heightInches = heightInches;
            return this;
        }

        public Builder heightInches(Double heightInches) {
            this.heightInches = Optional.ofNullable(heightInches);
            return this;
        }

        public Builder heightInches(Nullable<Double> heightInches) {
            if (heightInches.isNull()) {
                this.heightInches = null;
            } else if (heightInches.isEmpty()) {
                this.heightInches = Optional.empty();
            } else {
                this.heightInches = Optional.of(heightInches.get());
            }
            return this;
        }

        @JsonSetter(value = "turnable", nulls = Nulls.SKIP)
        public Builder turnable(Optional<Boolean> turnable) {
            this.turnable = turnable;
            return this;
        }

        public Builder turnable(Boolean turnable) {
            this.turnable = Optional.ofNullable(turnable);
            return this;
        }

        public Builder turnable(Nullable<Boolean> turnable) {
            if (turnable.isNull()) {
                this.turnable = null;
            } else if (turnable.isEmpty()) {
                this.turnable = Optional.empty();
            } else {
                this.turnable = Optional.of(turnable.get());
            }
            return this;
        }

        @JsonSetter(value = "stackable", nulls = Nulls.SKIP)
        public Builder stackable(Optional<Boolean> stackable) {
            this.stackable = stackable;
            return this;
        }

        public Builder stackable(Boolean stackable) {
            this.stackable = Optional.ofNullable(stackable);
            return this;
        }

        public Builder stackable(Nullable<Boolean> stackable) {
            if (stackable.isNull()) {
                this.stackable = null;
            } else if (stackable.isEmpty()) {
                this.stackable = Optional.empty();
            } else {
                this.stackable = Optional.of(stackable.get());
            }
            return this;
        }

        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            if (description.isNull()) {
                this.description = null;
            } else if (description.isEmpty()) {
                this.description = Optional.empty();
            } else {
                this.description = Optional.of(description.get());
            }
            return this;
        }

        public CargoClientUpdate1 build() {
            return new CargoClientUpdate1(
                    cargoType,
                    quantity,
                    weightPounds,
                    lengthInches,
                    widthInches,
                    heightInches,
                    turnable,
                    stackable,
                    description,
                    additionalProperties);
        }
    }
}
