/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierOrgProfile1.Builder.class)
public final class CourierOrgProfile1 {
    private final int schemaVersion;

    private final String description;

    private final String emailAddressPrimary;

    private final String phoneNumberPrimary;

    private final String orgId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private CourierOrgProfile1(
            int schemaVersion,
            String description,
            String emailAddressPrimary,
            String phoneNumberPrimary,
            String orgId,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.description = description;
        this.emailAddressPrimary = emailAddressPrimary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.orgId = orgId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("email_address_primary")
    public String getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonProperty("phone_number_primary")
    public String getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierOrgProfile1 && equalTo((CourierOrgProfile1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierOrgProfile1 other) {
        return schemaVersion == other.schemaVersion
                && description.equals(other.description)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && orgId.equals(other.orgId)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.description,
                this.emailAddressPrimary,
                this.phoneNumberPrimary,
                this.orgId,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        DescriptionStage schemaVersion(int schemaVersion);

        Builder from(CourierOrgProfile1 other);
    }

    public interface DescriptionStage {
        EmailAddressPrimaryStage description(@NotNull String description);
    }

    public interface EmailAddressPrimaryStage {
        PhoneNumberPrimaryStage emailAddressPrimary(@NotNull String emailAddressPrimary);
    }

    public interface PhoneNumberPrimaryStage {
        OrgIdStage phoneNumberPrimary(@NotNull String phoneNumberPrimary);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        IdStage orgId(@NotNull String orgId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        CourierOrgProfile1 build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    DescriptionStage,
                    EmailAddressPrimaryStage,
                    PhoneNumberPrimaryStage,
                    OrgIdStage,
                    IdStage,
                    _FinalStage {
        private int schemaVersion;

        private String description;

        private String emailAddressPrimary;

        private String phoneNumberPrimary;

        private String orgId;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CourierOrgProfile1 other) {
            schemaVersion(other.getSchemaVersion());
            description(other.getDescription());
            emailAddressPrimary(other.getEmailAddressPrimary());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            orgId(other.getOrgId());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public DescriptionStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public EmailAddressPrimaryStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("email_address_primary")
        public PhoneNumberPrimaryStage emailAddressPrimary(@NotNull String emailAddressPrimary) {
            this.emailAddressPrimary =
                    Objects.requireNonNull(emailAddressPrimary, "emailAddressPrimary must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("phone_number_primary")
        public OrgIdStage phoneNumberPrimary(@NotNull String phoneNumberPrimary) {
            this.phoneNumberPrimary = Objects.requireNonNull(phoneNumberPrimary, "phoneNumberPrimary must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public IdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public CourierOrgProfile1 build() {
            return new CourierOrgProfile1(
                    schemaVersion,
                    description,
                    emailAddressPrimary,
                    phoneNumberPrimary,
                    orgId,
                    id,
                    additionalProperties);
        }
    }
}
