/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierPayDriverLineItemGroup1.Builder.class)
public final class CourierPayDriverLineItemGroup1 {
    private final int schemaVersion;

    private final String driverId;

    private final String taskGroupId;

    private final String courierOrgId;

    private final Optional<Boolean> orderCancelled;

    private final List<LineItem1> lineItems;

    private final String rateSheetId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private CourierPayDriverLineItemGroup1(
            int schemaVersion,
            String driverId,
            String taskGroupId,
            String courierOrgId,
            Optional<Boolean> orderCancelled,
            List<LineItem1> lineItems,
            String rateSheetId,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.driverId = driverId;
        this.taskGroupId = taskGroupId;
        this.courierOrgId = courierOrgId;
        this.orderCancelled = orderCancelled;
        this.lineItems = lineItems;
        this.rateSheetId = rateSheetId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("driver_id")
    public String getDriverId() {
        return driverId;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    @JsonProperty("order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return orderCancelled;
    }

    @JsonProperty("line_items")
    public List<LineItem1> getLineItems() {
        return lineItems;
    }

    @JsonProperty("rate_sheet_id")
    public String getRateSheetId() {
        return rateSheetId;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierPayDriverLineItemGroup1 && equalTo((CourierPayDriverLineItemGroup1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverLineItemGroup1 other) {
        return schemaVersion == other.schemaVersion
                && driverId.equals(other.driverId)
                && taskGroupId.equals(other.taskGroupId)
                && courierOrgId.equals(other.courierOrgId)
                && orderCancelled.equals(other.orderCancelled)
                && lineItems.equals(other.lineItems)
                && rateSheetId.equals(other.rateSheetId)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.driverId,
                this.taskGroupId,
                this.courierOrgId,
                this.orderCancelled,
                this.lineItems,
                this.rateSheetId,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        DriverIdStage schemaVersion(int schemaVersion);

        Builder from(CourierPayDriverLineItemGroup1 other);
    }

    public interface DriverIdStage {
        TaskGroupIdStage driverId(@NotNull String driverId);
    }

    public interface TaskGroupIdStage {
        CourierOrgIdStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        RateSheetIdStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface RateSheetIdStage {
        IdStage rateSheetId(@NotNull String rateSheetId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        CourierPayDriverLineItemGroup1 build();

        _FinalStage orderCancelled(Optional<Boolean> orderCancelled);

        _FinalStage orderCancelled(Boolean orderCancelled);

        _FinalStage lineItems(List<LineItem1> lineItems);

        _FinalStage addLineItems(LineItem1 lineItems);

        _FinalStage addAllLineItems(List<LineItem1> lineItems);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    DriverIdStage,
                    TaskGroupIdStage,
                    CourierOrgIdStage,
                    RateSheetIdStage,
                    IdStage,
                    _FinalStage {
        private int schemaVersion;

        private String driverId;

        private String taskGroupId;

        private String courierOrgId;

        private String rateSheetId;

        private String id;

        private List<LineItem1> lineItems = new ArrayList<>();

        private Optional<Boolean> orderCancelled = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CourierPayDriverLineItemGroup1 other) {
            schemaVersion(other.getSchemaVersion());
            driverId(other.getDriverId());
            taskGroupId(other.getTaskGroupId());
            courierOrgId(other.getCourierOrgId());
            orderCancelled(other.getOrderCancelled());
            lineItems(other.getLineItems());
            rateSheetId(other.getRateSheetId());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public DriverIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("driver_id")
        public TaskGroupIdStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public CourierOrgIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public RateSheetIdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("rate_sheet_id")
        public IdStage rateSheetId(@NotNull String rateSheetId) {
            this.rateSheetId = Objects.requireNonNull(rateSheetId, "rateSheetId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllLineItems(List<LineItem1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addLineItems(LineItem1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_items", nulls = Nulls.SKIP)
        public _FinalStage lineItems(List<LineItem1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @java.lang.Override
        public CourierPayDriverLineItemGroup1 build() {
            return new CourierPayDriverLineItemGroup1(
                    schemaVersion,
                    driverId,
                    taskGroupId,
                    courierOrgId,
                    orderCancelled,
                    lineItems,
                    rateSheetId,
                    id,
                    additionalProperties);
        }
    }
}
