/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierPayDriverStatementClientCreate1.Builder.class)
public final class CourierPayDriverStatementClientCreate1 {
    private final int schemaVersion;

    private final List<String> courierPayDriverLineItemGroupIds;

    private final Map<String, Object> additionalProperties;

    private CourierPayDriverStatementClientCreate1(
            int schemaVersion,
            List<String> courierPayDriverLineItemGroupIds,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.courierPayDriverLineItemGroupIds = courierPayDriverLineItemGroupIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("courier_pay_driver_line_item_group_ids")
    public List<String> getCourierPayDriverLineItemGroupIds() {
        return courierPayDriverLineItemGroupIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierPayDriverStatementClientCreate1
                && equalTo((CourierPayDriverStatementClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverStatementClientCreate1 other) {
        return schemaVersion == other.schemaVersion
                && courierPayDriverLineItemGroupIds.equals(other.courierPayDriverLineItemGroupIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.courierPayDriverLineItemGroupIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        _FinalStage schemaVersion(int schemaVersion);

        Builder from(CourierPayDriverStatementClientCreate1 other);
    }

    public interface _FinalStage {
        CourierPayDriverStatementClientCreate1 build();

        _FinalStage courierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds);

        _FinalStage addCourierPayDriverLineItemGroupIds(String courierPayDriverLineItemGroupIds);

        _FinalStage addAllCourierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, _FinalStage {
        private int schemaVersion;

        private List<String> courierPayDriverLineItemGroupIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CourierPayDriverStatementClientCreate1 other) {
            schemaVersion(other.getSchemaVersion());
            courierPayDriverLineItemGroupIds(other.getCourierPayDriverLineItemGroupIds());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public _FinalStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCourierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds) {
            if (courierPayDriverLineItemGroupIds != null) {
                this.courierPayDriverLineItemGroupIds.addAll(courierPayDriverLineItemGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCourierPayDriverLineItemGroupIds(String courierPayDriverLineItemGroupIds) {
            this.courierPayDriverLineItemGroupIds.add(courierPayDriverLineItemGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_line_item_group_ids", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds) {
            this.courierPayDriverLineItemGroupIds.clear();
            if (courierPayDriverLineItemGroupIds != null) {
                this.courierPayDriverLineItemGroupIds.addAll(courierPayDriverLineItemGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public CourierPayDriverStatementClientCreate1 build() {
            return new CourierPayDriverStatementClientCreate1(
                    schemaVersion, courierPayDriverLineItemGroupIds, additionalProperties);
        }
    }
}
