/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierPayDriverStatementClientUpdate1.Builder.class)
public final class CourierPayDriverStatementClientUpdate1 {
    private final Optional<StatementStatusEnum> statementStatus;

    private final Optional<OffsetDateTime> statementCompletedAtTimestamp;

    private final Optional<String> statementCompletedByUserId;

    private final Map<String, Object> additionalProperties;

    private CourierPayDriverStatementClientUpdate1(
            Optional<StatementStatusEnum> statementStatus,
            Optional<OffsetDateTime> statementCompletedAtTimestamp,
            Optional<String> statementCompletedByUserId,
            Map<String, Object> additionalProperties) {
        this.statementStatus = statementStatus;
        this.statementCompletedAtTimestamp = statementCompletedAtTimestamp;
        this.statementCompletedByUserId = statementCompletedByUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<StatementStatusEnum> getStatementStatus() {
        if (statementStatus == null) {
            return Optional.empty();
        }
        return statementStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStatementCompletedAtTimestamp() {
        if (statementCompletedAtTimestamp == null) {
            return Optional.empty();
        }
        return statementCompletedAtTimestamp;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getStatementCompletedByUserId() {
        if (statementCompletedByUserId == null) {
            return Optional.empty();
        }
        return statementCompletedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("statement_status")
    private Optional<StatementStatusEnum> _getStatementStatus() {
        return statementStatus;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("statement_completed_at_timestamp")
    private Optional<OffsetDateTime> _getStatementCompletedAtTimestamp() {
        return statementCompletedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("statement_completed_by_user_id")
    private Optional<String> _getStatementCompletedByUserId() {
        return statementCompletedByUserId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierPayDriverStatementClientUpdate1
                && equalTo((CourierPayDriverStatementClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverStatementClientUpdate1 other) {
        return statementStatus.equals(other.statementStatus)
                && statementCompletedAtTimestamp.equals(other.statementCompletedAtTimestamp)
                && statementCompletedByUserId.equals(other.statementCompletedByUserId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.statementStatus, this.statementCompletedAtTimestamp, this.statementCompletedByUserId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<StatementStatusEnum> statementStatus = Optional.empty();

        private Optional<OffsetDateTime> statementCompletedAtTimestamp = Optional.empty();

        private Optional<String> statementCompletedByUserId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CourierPayDriverStatementClientUpdate1 other) {
            statementStatus(other.getStatementStatus());
            statementCompletedAtTimestamp(other.getStatementCompletedAtTimestamp());
            statementCompletedByUserId(other.getStatementCompletedByUserId());
            return this;
        }

        @JsonSetter(value = "statement_status", nulls = Nulls.SKIP)
        public Builder statementStatus(Optional<StatementStatusEnum> statementStatus) {
            this.statementStatus = statementStatus;
            return this;
        }

        public Builder statementStatus(StatementStatusEnum statementStatus) {
            this.statementStatus = Optional.ofNullable(statementStatus);
            return this;
        }

        public Builder statementStatus(Nullable<StatementStatusEnum> statementStatus) {
            if (statementStatus.isNull()) {
                this.statementStatus = null;
            } else if (statementStatus.isEmpty()) {
                this.statementStatus = Optional.empty();
            } else {
                this.statementStatus = Optional.of(statementStatus.get());
            }
            return this;
        }

        @JsonSetter(value = "statement_completed_at_timestamp", nulls = Nulls.SKIP)
        public Builder statementCompletedAtTimestamp(Optional<OffsetDateTime> statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = statementCompletedAtTimestamp;
            return this;
        }

        public Builder statementCompletedAtTimestamp(OffsetDateTime statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = Optional.ofNullable(statementCompletedAtTimestamp);
            return this;
        }

        public Builder statementCompletedAtTimestamp(Nullable<OffsetDateTime> statementCompletedAtTimestamp) {
            if (statementCompletedAtTimestamp.isNull()) {
                this.statementCompletedAtTimestamp = null;
            } else if (statementCompletedAtTimestamp.isEmpty()) {
                this.statementCompletedAtTimestamp = Optional.empty();
            } else {
                this.statementCompletedAtTimestamp = Optional.of(statementCompletedAtTimestamp.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @JsonSetter(value = "statement_completed_by_user_id", nulls = Nulls.SKIP)
        public Builder statementCompletedByUserId(Optional<String> statementCompletedByUserId) {
            this.statementCompletedByUserId = statementCompletedByUserId;
            return this;
        }

        public Builder statementCompletedByUserId(String statementCompletedByUserId) {
            this.statementCompletedByUserId = Optional.ofNullable(statementCompletedByUserId);
            return this;
        }

        public Builder statementCompletedByUserId(Nullable<String> statementCompletedByUserId) {
            if (statementCompletedByUserId.isNull()) {
                this.statementCompletedByUserId = null;
            } else if (statementCompletedByUserId.isEmpty()) {
                this.statementCompletedByUserId = Optional.empty();
            } else {
                this.statementCompletedByUserId = Optional.of(statementCompletedByUserId.get());
            }
            return this;
        }

        public CourierPayDriverStatementClientUpdate1 build() {
            return new CourierPayDriverStatementClientUpdate1(
                    statementStatus, statementCompletedAtTimestamp, statementCompletedByUserId, additionalProperties);
        }
    }
}
