/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Driver1.Builder.class)
public final class Driver1 {
    private final int schemaVersion;

    private final Optional<Boolean> active;

    private final Optional<String> emailAddressPrimary;

    private final Optional<String> emailAddressSecondary;

    private final Optional<String> phoneNumberPrimary;

    private final Optional<String> phoneNumberSecondary;

    private final Optional<String> firstName;

    private final Optional<String> lastName;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Optional<DriverStatusEnum> status;

    private final Optional<LocationFeature> lastSeenAtLocation;

    private final Optional<OffsetDateTime> lastSeenAtTimestamp;

    private final String id;

    private final String orgId;

    private final String userId;

    private final Map<String, Object> additionalProperties;

    private Driver1(
            int schemaVersion,
            Optional<Boolean> active,
            Optional<String> emailAddressPrimary,
            Optional<String> emailAddressSecondary,
            Optional<String> phoneNumberPrimary,
            Optional<String> phoneNumberSecondary,
            Optional<String> firstName,
            Optional<String> lastName,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Optional<DriverStatusEnum> status,
            Optional<LocationFeature> lastSeenAtLocation,
            Optional<OffsetDateTime> lastSeenAtTimestamp,
            String id,
            String orgId,
            String userId,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.active = active;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vehicleTypes = vehicleTypes;
        this.status = status;
        this.lastSeenAtLocation = lastSeenAtLocation;
        this.lastSeenAtTimestamp = lastSeenAtTimestamp;
        this.id = id;
        this.orgId = orgId;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<Boolean> getActive() {
        if (active == null) {
            return Optional.empty();
        }
        return active;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (emailAddressPrimary == null) {
            return Optional.empty();
        }
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (emailAddressSecondary == null) {
            return Optional.empty();
        }
        return emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (firstName == null) {
            return Optional.empty();
        }
        return firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (lastName == null) {
            return Optional.empty();
        }
        return lastName;
    }

    @JsonProperty("vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return vehicleTypes;
    }

    @JsonProperty("status")
    public Optional<DriverStatusEnum> getStatus() {
        return status;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLastSeenAtLocation() {
        if (lastSeenAtLocation == null) {
            return Optional.empty();
        }
        return lastSeenAtLocation;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenAtTimestamp() {
        if (lastSeenAtTimestamp == null) {
            return Optional.empty();
        }
        return lastSeenAtTimestamp;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("active")
    private Optional<Boolean> _getActive() {
        return active;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return emailAddressSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return phoneNumberSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("first_name")
    private Optional<String> _getFirstName() {
        return firstName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_name")
    private Optional<String> _getLastName() {
        return lastName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_seen_at_location")
    private Optional<LocationFeature> _getLastSeenAtLocation() {
        return lastSeenAtLocation;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_seen_at_timestamp")
    private Optional<OffsetDateTime> _getLastSeenAtTimestamp() {
        return lastSeenAtTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Driver1 && equalTo((Driver1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Driver1 other) {
        return schemaVersion == other.schemaVersion
                && active.equals(other.active)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && emailAddressSecondary.equals(other.emailAddressSecondary)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && phoneNumberSecondary.equals(other.phoneNumberSecondary)
                && firstName.equals(other.firstName)
                && lastName.equals(other.lastName)
                && vehicleTypes.equals(other.vehicleTypes)
                && status.equals(other.status)
                && lastSeenAtLocation.equals(other.lastSeenAtLocation)
                && lastSeenAtTimestamp.equals(other.lastSeenAtTimestamp)
                && id.equals(other.id)
                && orgId.equals(other.orgId)
                && userId.equals(other.userId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.active,
                this.emailAddressPrimary,
                this.emailAddressSecondary,
                this.phoneNumberPrimary,
                this.phoneNumberSecondary,
                this.firstName,
                this.lastName,
                this.vehicleTypes,
                this.status,
                this.lastSeenAtLocation,
                this.lastSeenAtTimestamp,
                this.id,
                this.orgId,
                this.userId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(Driver1 other);
    }

    public interface IdStage {
        OrgIdStage id(@NotNull String id);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        UserIdStage orgId(@NotNull String orgId);
    }

    public interface UserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage userId(@NotNull String userId);
    }

    public interface _FinalStage {
        Driver1 build();

        _FinalStage active(Optional<Boolean> active);

        _FinalStage active(Boolean active);

        _FinalStage active(Nullable<Boolean> active);

        _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary);

        _FinalStage emailAddressPrimary(String emailAddressPrimary);

        _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary);

        _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary);

        _FinalStage emailAddressSecondary(String emailAddressSecondary);

        _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary);

        _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(String phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary);

        _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(String phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary);

        _FinalStage firstName(Optional<String> firstName);

        _FinalStage firstName(String firstName);

        _FinalStage firstName(Nullable<String> firstName);

        _FinalStage lastName(Optional<String> lastName);

        _FinalStage lastName(String lastName);

        _FinalStage lastName(Nullable<String> lastName);

        _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes);

        _FinalStage status(Optional<DriverStatusEnum> status);

        _FinalStage status(DriverStatusEnum status);

        _FinalStage lastSeenAtLocation(Optional<LocationFeature> lastSeenAtLocation);

        _FinalStage lastSeenAtLocation(LocationFeature lastSeenAtLocation);

        _FinalStage lastSeenAtLocation(Nullable<LocationFeature> lastSeenAtLocation);

        _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> lastSeenAtTimestamp);

        _FinalStage lastSeenAtTimestamp(OffsetDateTime lastSeenAtTimestamp);

        _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> lastSeenAtTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, IdStage, OrgIdStage, UserIdStage, _FinalStage {
        private int schemaVersion;

        private String id;

        private String orgId;

        private String userId;

        private Optional<OffsetDateTime> lastSeenAtTimestamp = Optional.empty();

        private Optional<LocationFeature> lastSeenAtLocation = Optional.empty();

        private Optional<DriverStatusEnum> status = Optional.empty();

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        private Optional<String> lastName = Optional.empty();

        private Optional<String> firstName = Optional.empty();

        private Optional<String> phoneNumberSecondary = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        private Optional<String> emailAddressSecondary = Optional.empty();

        private Optional<String> emailAddressPrimary = Optional.empty();

        private Optional<Boolean> active = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Driver1 other) {
            schemaVersion(other.getSchemaVersion());
            active(other.getActive());
            emailAddressPrimary(other.getEmailAddressPrimary());
            emailAddressSecondary(other.getEmailAddressSecondary());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            phoneNumberSecondary(other.getPhoneNumberSecondary());
            firstName(other.getFirstName());
            lastName(other.getLastName());
            vehicleTypes(other.getVehicleTypes());
            status(other.getStatus());
            lastSeenAtLocation(other.getLastSeenAtLocation());
            lastSeenAtTimestamp(other.getLastSeenAtTimestamp());
            id(other.getId());
            orgId(other.getOrgId());
            userId(other.getUserId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OrgIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public UserIdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> lastSeenAtTimestamp) {
            if (lastSeenAtTimestamp.isNull()) {
                this.lastSeenAtTimestamp = null;
            } else if (lastSeenAtTimestamp.isEmpty()) {
                this.lastSeenAtTimestamp = Optional.empty();
            } else {
                this.lastSeenAtTimestamp = Optional.of(lastSeenAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtTimestamp(OffsetDateTime lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = Optional.ofNullable(lastSeenAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = lastSeenAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtLocation(Nullable<LocationFeature> lastSeenAtLocation) {
            if (lastSeenAtLocation.isNull()) {
                this.lastSeenAtLocation = null;
            } else if (lastSeenAtLocation.isEmpty()) {
                this.lastSeenAtLocation = Optional.empty();
            } else {
                this.lastSeenAtLocation = Optional.of(lastSeenAtLocation.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtLocation(LocationFeature lastSeenAtLocation) {
            this.lastSeenAtLocation = Optional.ofNullable(lastSeenAtLocation);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at_location", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAtLocation(Optional<LocationFeature> lastSeenAtLocation) {
            this.lastSeenAtLocation = lastSeenAtLocation;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(DriverStatusEnum status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<DriverStatusEnum> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastName(Nullable<String> lastName) {
            if (lastName.isNull()) {
                this.lastName = null;
            } else if (lastName.isEmpty()) {
                this.lastName = Optional.empty();
            } else {
                this.lastName = Optional.of(lastName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_name", nulls = Nulls.SKIP)
        public _FinalStage lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        @java.lang.Override
        public _FinalStage firstName(Nullable<String> firstName) {
            if (firstName.isNull()) {
                this.firstName = null;
            } else if (firstName.isEmpty()) {
                this.firstName = Optional.empty();
            } else {
                this.firstName = Optional.of(firstName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "first_name", nulls = Nulls.SKIP)
        public _FinalStage firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            if (phoneNumberSecondary.isNull()) {
                this.phoneNumberSecondary = null;
            } else if (phoneNumberSecondary.isEmpty()) {
                this.phoneNumberSecondary = Optional.empty();
            } else {
                this.phoneNumberSecondary = Optional.of(phoneNumberSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_secondary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            if (emailAddressSecondary.isNull()) {
                this.emailAddressSecondary = null;
            } else if (emailAddressSecondary.isEmpty()) {
                this.emailAddressSecondary = Optional.empty();
            } else {
                this.emailAddressSecondary = Optional.of(emailAddressSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_secondary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            if (emailAddressPrimary.isNull()) {
                this.emailAddressPrimary = null;
            } else if (emailAddressPrimary.isEmpty()) {
                this.emailAddressPrimary = Optional.empty();
            } else {
                this.emailAddressPrimary = Optional.of(emailAddressPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_primary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage active(Nullable<Boolean> active) {
            if (active.isNull()) {
                this.active = null;
            } else if (active.isEmpty()) {
                this.active = Optional.empty();
            } else {
                this.active = Optional.of(active.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage active(Boolean active) {
            this.active = Optional.ofNullable(active);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "active", nulls = Nulls.SKIP)
        public _FinalStage active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        @java.lang.Override
        public Driver1 build() {
            return new Driver1(
                    schemaVersion,
                    active,
                    emailAddressPrimary,
                    emailAddressSecondary,
                    phoneNumberPrimary,
                    phoneNumberSecondary,
                    firstName,
                    lastName,
                    vehicleTypes,
                    status,
                    lastSeenAtLocation,
                    lastSeenAtTimestamp,
                    id,
                    orgId,
                    userId,
                    additionalProperties);
        }
    }
}
