/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class DriverStatusEnum {
    public static final DriverStatusEnum ASSIGNED = new DriverStatusEnum(Value.ASSIGNED, "assigned");

    public static final DriverStatusEnum ROUTE_IN_PROGRESS =
            new DriverStatusEnum(Value.ROUTE_IN_PROGRESS, "route_in_progress");

    public static final DriverStatusEnum NOT_ASSIGNED = new DriverStatusEnum(Value.NOT_ASSIGNED, "not_assigned");

    private final Value value;

    private final String string;

    DriverStatusEnum(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return value;
    }

    @java.lang.Override
    @JsonValue
    public String toString() {
        return this.string;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        return (this == other)
                || (other instanceof DriverStatusEnum && this.string.equals(((DriverStatusEnum) other).string));
    }

    @java.lang.Override
    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (value) {
            case ASSIGNED:
                return visitor.visitAssigned();
            case ROUTE_IN_PROGRESS:
                return visitor.visitRouteInProgress();
            case NOT_ASSIGNED:
                return visitor.visitNotAssigned();
            case UNKNOWN:
            default:
                return visitor.visitUnknown(string);
        }
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static DriverStatusEnum valueOf(String value) {
        switch (value) {
            case "assigned":
                return ASSIGNED;
            case "route_in_progress":
                return ROUTE_IN_PROGRESS;
            case "not_assigned":
                return NOT_ASSIGNED;
            default:
                return new DriverStatusEnum(Value.UNKNOWN, value);
        }
    }

    public enum Value {
        NOT_ASSIGNED,

        ASSIGNED,

        ROUTE_IN_PROGRESS,

        UNKNOWN
    }

    public interface Visitor<T> {
        T visitNotAssigned();

        T visitAssigned();

        T visitRouteInProgress();

        T visitUnknown(String unknownType);
    }
}
