/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OffChrtShipperOrg1.Builder.class)
public final class OffChrtShipperOrg1 {
    private final int schemaVersion;

    private final Optional<String> companyName;

    private final Optional<String> industry;

    private final Optional<LocationFeature> streetAddress;

    private final Optional<String> contactFirstName;

    private final Optional<String> contactLastName;

    private final Optional<String> phoneNumberPrimary;

    private final Optional<String> phoneNumberSecondary;

    private final String emailAddressPrimary;

    private final Optional<String> emailAddressSecondary;

    private final Optional<String> jobTitle;

    private final Optional<String> notes;

    private final Optional<String> shipperCustomerIdForCourierStripeConnectAccount;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private OffChrtShipperOrg1(
            int schemaVersion,
            Optional<String> companyName,
            Optional<String> industry,
            Optional<LocationFeature> streetAddress,
            Optional<String> contactFirstName,
            Optional<String> contactLastName,
            Optional<String> phoneNumberPrimary,
            Optional<String> phoneNumberSecondary,
            String emailAddressPrimary,
            Optional<String> emailAddressSecondary,
            Optional<String> jobTitle,
            Optional<String> notes,
            Optional<String> shipperCustomerIdForCourierStripeConnectAccount,
            String createdByOrgId,
            String createdByUserId,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.companyName = companyName;
        this.industry = industry;
        this.streetAddress = streetAddress;
        this.contactFirstName = contactFirstName;
        this.contactLastName = contactLastName;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.jobTitle = jobTitle;
        this.notes = notes;
        this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (companyName == null) {
            return Optional.empty();
        }
        return companyName;
    }

    @JsonIgnore
    public Optional<String> getIndustry() {
        if (industry == null) {
            return Optional.empty();
        }
        return industry;
    }

    @JsonIgnore
    public Optional<LocationFeature> getStreetAddress() {
        if (streetAddress == null) {
            return Optional.empty();
        }
        return streetAddress;
    }

    @JsonIgnore
    public Optional<String> getContactFirstName() {
        if (contactFirstName == null) {
            return Optional.empty();
        }
        return contactFirstName;
    }

    @JsonIgnore
    public Optional<String> getContactLastName() {
        if (contactLastName == null) {
            return Optional.empty();
        }
        return contactLastName;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return phoneNumberSecondary;
    }

    @JsonProperty("email_address_primary")
    public String getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (emailAddressSecondary == null) {
            return Optional.empty();
        }
        return emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getJobTitle() {
        if (jobTitle == null) {
            return Optional.empty();
        }
        return jobTitle;
    }

    @JsonIgnore
    public Optional<String> getNotes() {
        if (notes == null) {
            return Optional.empty();
        }
        return notes;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForCourierStripeConnectAccount() {
        if (shipperCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return shipperCustomerIdForCourierStripeConnectAccount;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("company_name")
    private Optional<String> _getCompanyName() {
        return companyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("industry")
    private Optional<String> _getIndustry() {
        return industry;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("street_address")
    private Optional<LocationFeature> _getStreetAddress() {
        return streetAddress;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("contact_first_name")
    private Optional<String> _getContactFirstName() {
        return contactFirstName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("contact_last_name")
    private Optional<String> _getContactLastName() {
        return contactLastName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return phoneNumberSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return emailAddressSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("job_title")
    private Optional<String> _getJobTitle() {
        return jobTitle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("notes")
    private Optional<String> _getNotes() {
        return notes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForCourierStripeConnectAccount() {
        return shipperCustomerIdForCourierStripeConnectAccount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OffChrtShipperOrg1 && equalTo((OffChrtShipperOrg1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OffChrtShipperOrg1 other) {
        return schemaVersion == other.schemaVersion
                && companyName.equals(other.companyName)
                && industry.equals(other.industry)
                && streetAddress.equals(other.streetAddress)
                && contactFirstName.equals(other.contactFirstName)
                && contactLastName.equals(other.contactLastName)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && phoneNumberSecondary.equals(other.phoneNumberSecondary)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && emailAddressSecondary.equals(other.emailAddressSecondary)
                && jobTitle.equals(other.jobTitle)
                && notes.equals(other.notes)
                && shipperCustomerIdForCourierStripeConnectAccount.equals(
                        other.shipperCustomerIdForCourierStripeConnectAccount)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.companyName,
                this.industry,
                this.streetAddress,
                this.contactFirstName,
                this.contactLastName,
                this.phoneNumberPrimary,
                this.phoneNumberSecondary,
                this.emailAddressPrimary,
                this.emailAddressSecondary,
                this.jobTitle,
                this.notes,
                this.shipperCustomerIdForCourierStripeConnectAccount,
                this.createdByOrgId,
                this.createdByUserId,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        EmailAddressPrimaryStage schemaVersion(int schemaVersion);

        Builder from(OffChrtShipperOrg1 other);
    }

    public interface EmailAddressPrimaryStage {
        CreatedByOrgIdStage emailAddressPrimary(@NotNull String emailAddressPrimary);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        IdStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        OffChrtShipperOrg1 build();

        _FinalStage companyName(Optional<String> companyName);

        _FinalStage companyName(String companyName);

        _FinalStage companyName(Nullable<String> companyName);

        _FinalStage industry(Optional<String> industry);

        _FinalStage industry(String industry);

        _FinalStage industry(Nullable<String> industry);

        _FinalStage streetAddress(Optional<LocationFeature> streetAddress);

        _FinalStage streetAddress(LocationFeature streetAddress);

        _FinalStage streetAddress(Nullable<LocationFeature> streetAddress);

        _FinalStage contactFirstName(Optional<String> contactFirstName);

        _FinalStage contactFirstName(String contactFirstName);

        _FinalStage contactFirstName(Nullable<String> contactFirstName);

        _FinalStage contactLastName(Optional<String> contactLastName);

        _FinalStage contactLastName(String contactLastName);

        _FinalStage contactLastName(Nullable<String> contactLastName);

        _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(String phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary);

        _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(String phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary);

        _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary);

        _FinalStage emailAddressSecondary(String emailAddressSecondary);

        _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary);

        _FinalStage jobTitle(Optional<String> jobTitle);

        _FinalStage jobTitle(String jobTitle);

        _FinalStage jobTitle(Nullable<String> jobTitle);

        _FinalStage notes(Optional<String> notes);

        _FinalStage notes(String notes);

        _FinalStage notes(Nullable<String> notes);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Optional<String> shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                String shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Nullable<String> shipperCustomerIdForCourierStripeConnectAccount);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    EmailAddressPrimaryStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    IdStage,
                    _FinalStage {
        private int schemaVersion;

        private String emailAddressPrimary;

        private String createdByOrgId;

        private String createdByUserId;

        private String id;

        private Optional<String> shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();

        private Optional<String> notes = Optional.empty();

        private Optional<String> jobTitle = Optional.empty();

        private Optional<String> emailAddressSecondary = Optional.empty();

        private Optional<String> phoneNumberSecondary = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        private Optional<String> contactLastName = Optional.empty();

        private Optional<String> contactFirstName = Optional.empty();

        private Optional<LocationFeature> streetAddress = Optional.empty();

        private Optional<String> industry = Optional.empty();

        private Optional<String> companyName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OffChrtShipperOrg1 other) {
            schemaVersion(other.getSchemaVersion());
            companyName(other.getCompanyName());
            industry(other.getIndustry());
            streetAddress(other.getStreetAddress());
            contactFirstName(other.getContactFirstName());
            contactLastName(other.getContactLastName());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            phoneNumberSecondary(other.getPhoneNumberSecondary());
            emailAddressPrimary(other.getEmailAddressPrimary());
            emailAddressSecondary(other.getEmailAddressSecondary());
            jobTitle(other.getJobTitle());
            notes(other.getNotes());
            shipperCustomerIdForCourierStripeConnectAccount(other.getShipperCustomerIdForCourierStripeConnectAccount());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public EmailAddressPrimaryStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("email_address_primary")
        public CreatedByOrgIdStage emailAddressPrimary(@NotNull String emailAddressPrimary) {
            this.emailAddressPrimary =
                    Objects.requireNonNull(emailAddressPrimary, "emailAddressPrimary must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public IdStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Nullable<String> shipperCustomerIdForCourierStripeConnectAccount) {
            if (shipperCustomerIdForCourierStripeConnectAccount.isNull()) {
                this.shipperCustomerIdForCourierStripeConnectAccount = null;
            } else if (shipperCustomerIdForCourierStripeConnectAccount.isEmpty()) {
                this.shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();
            } else {
                this.shipperCustomerIdForCourierStripeConnectAccount =
                        Optional.of(shipperCustomerIdForCourierStripeConnectAccount.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                String shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount =
                    Optional.ofNullable(shipperCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_customer_id_for_courier_stripe_connect_account", nulls = Nulls.SKIP)
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Optional<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(Nullable<String> notes) {
            if (notes.isNull()) {
                this.notes = null;
            } else if (notes.isEmpty()) {
                this.notes = Optional.empty();
            } else {
                this.notes = Optional.of(notes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(String notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public _FinalStage notes(Optional<String> notes) {
            this.notes = notes;
            return this;
        }

        @java.lang.Override
        public _FinalStage jobTitle(Nullable<String> jobTitle) {
            if (jobTitle.isNull()) {
                this.jobTitle = null;
            } else if (jobTitle.isEmpty()) {
                this.jobTitle = Optional.empty();
            } else {
                this.jobTitle = Optional.of(jobTitle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "job_title", nulls = Nulls.SKIP)
        public _FinalStage jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            if (emailAddressSecondary.isNull()) {
                this.emailAddressSecondary = null;
            } else if (emailAddressSecondary.isEmpty()) {
                this.emailAddressSecondary = Optional.empty();
            } else {
                this.emailAddressSecondary = Optional.of(emailAddressSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_secondary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            if (phoneNumberSecondary.isNull()) {
                this.phoneNumberSecondary = null;
            } else if (phoneNumberSecondary.isEmpty()) {
                this.phoneNumberSecondary = Optional.empty();
            } else {
                this.phoneNumberSecondary = Optional.of(phoneNumberSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_secondary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage contactLastName(Nullable<String> contactLastName) {
            if (contactLastName.isNull()) {
                this.contactLastName = null;
            } else if (contactLastName.isEmpty()) {
                this.contactLastName = Optional.empty();
            } else {
                this.contactLastName = Optional.of(contactLastName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage contactLastName(String contactLastName) {
            this.contactLastName = Optional.ofNullable(contactLastName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "contact_last_name", nulls = Nulls.SKIP)
        public _FinalStage contactLastName(Optional<String> contactLastName) {
            this.contactLastName = contactLastName;
            return this;
        }

        @java.lang.Override
        public _FinalStage contactFirstName(Nullable<String> contactFirstName) {
            if (contactFirstName.isNull()) {
                this.contactFirstName = null;
            } else if (contactFirstName.isEmpty()) {
                this.contactFirstName = Optional.empty();
            } else {
                this.contactFirstName = Optional.of(contactFirstName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage contactFirstName(String contactFirstName) {
            this.contactFirstName = Optional.ofNullable(contactFirstName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "contact_first_name", nulls = Nulls.SKIP)
        public _FinalStage contactFirstName(Optional<String> contactFirstName) {
            this.contactFirstName = contactFirstName;
            return this;
        }

        @java.lang.Override
        public _FinalStage streetAddress(Nullable<LocationFeature> streetAddress) {
            if (streetAddress.isNull()) {
                this.streetAddress = null;
            } else if (streetAddress.isEmpty()) {
                this.streetAddress = Optional.empty();
            } else {
                this.streetAddress = Optional.of(streetAddress.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage streetAddress(LocationFeature streetAddress) {
            this.streetAddress = Optional.ofNullable(streetAddress);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "street_address", nulls = Nulls.SKIP)
        public _FinalStage streetAddress(Optional<LocationFeature> streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        @java.lang.Override
        public _FinalStage industry(Nullable<String> industry) {
            if (industry.isNull()) {
                this.industry = null;
            } else if (industry.isEmpty()) {
                this.industry = Optional.empty();
            } else {
                this.industry = Optional.of(industry.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "industry", nulls = Nulls.SKIP)
        public _FinalStage industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(Nullable<String> companyName) {
            if (companyName.isNull()) {
                this.companyName = null;
            } else if (companyName.isEmpty()) {
                this.companyName = Optional.empty();
            } else {
                this.companyName = Optional.of(companyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_name", nulls = Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @java.lang.Override
        public OffChrtShipperOrg1 build() {
            return new OffChrtShipperOrg1(
                    schemaVersion,
                    companyName,
                    industry,
                    streetAddress,
                    contactFirstName,
                    contactLastName,
                    phoneNumberPrimary,
                    phoneNumberSecondary,
                    emailAddressPrimary,
                    emailAddressSecondary,
                    jobTitle,
                    notes,
                    shipperCustomerIdForCourierStripeConnectAccount,
                    createdByOrgId,
                    createdByUserId,
                    id,
                    additionalProperties);
        }
    }
}
