/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderDraftExpandedRes.Builder.class)
public final class OrderDraftExpandedRes {
    private final Order1 order;

    private final Optional<List<TaskGroupDraftExpanded>> taskGroupsExpanded;

    private final Optional<String> shipperOrgCompanyName;

    private final Optional<String> shipperOrgHandle;

    private final Optional<String> offChrtShipperOrgCompanyName;

    private final Optional<String> forwarderOrgCompanyName;

    private final Optional<String> forwarderOrgHandle;

    private final Map<String, Object> additionalProperties;

    private OrderDraftExpandedRes(
            Order1 order,
            Optional<List<TaskGroupDraftExpanded>> taskGroupsExpanded,
            Optional<String> shipperOrgCompanyName,
            Optional<String> shipperOrgHandle,
            Optional<String> offChrtShipperOrgCompanyName,
            Optional<String> forwarderOrgCompanyName,
            Optional<String> forwarderOrgHandle,
            Map<String, Object> additionalProperties) {
        this.order = order;
        this.taskGroupsExpanded = taskGroupsExpanded;
        this.shipperOrgCompanyName = shipperOrgCompanyName;
        this.shipperOrgHandle = shipperOrgHandle;
        this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName;
        this.forwarderOrgCompanyName = forwarderOrgCompanyName;
        this.forwarderOrgHandle = forwarderOrgHandle;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order")
    public Order1 getOrder() {
        return order;
    }

    @JsonIgnore
    public Optional<List<TaskGroupDraftExpanded>> getTaskGroupsExpanded() {
        if (taskGroupsExpanded == null) {
            return Optional.empty();
        }
        return taskGroupsExpanded;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgCompanyName() {
        if (shipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return shipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgHandle() {
        if (shipperOrgHandle == null) {
            return Optional.empty();
        }
        return shipperOrgHandle;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgCompanyName() {
        if (offChrtShipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgCompanyName() {
        if (forwarderOrgCompanyName == null) {
            return Optional.empty();
        }
        return forwarderOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgHandle() {
        if (forwarderOrgHandle == null) {
            return Optional.empty();
        }
        return forwarderOrgHandle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_groups_expanded")
    private Optional<List<TaskGroupDraftExpanded>> _getTaskGroupsExpanded() {
        return taskGroupsExpanded;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_company_name")
    private Optional<String> _getShipperOrgCompanyName() {
        return shipperOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_handle")
    private Optional<String> _getShipperOrgHandle() {
        return shipperOrgHandle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_company_name")
    private Optional<String> _getOffChrtShipperOrgCompanyName() {
        return offChrtShipperOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_org_company_name")
    private Optional<String> _getForwarderOrgCompanyName() {
        return forwarderOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_org_handle")
    private Optional<String> _getForwarderOrgHandle() {
        return forwarderOrgHandle;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderDraftExpandedRes && equalTo((OrderDraftExpandedRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftExpandedRes other) {
        return order.equals(other.order)
                && taskGroupsExpanded.equals(other.taskGroupsExpanded)
                && shipperOrgCompanyName.equals(other.shipperOrgCompanyName)
                && shipperOrgHandle.equals(other.shipperOrgHandle)
                && offChrtShipperOrgCompanyName.equals(other.offChrtShipperOrgCompanyName)
                && forwarderOrgCompanyName.equals(other.forwarderOrgCompanyName)
                && forwarderOrgHandle.equals(other.forwarderOrgHandle);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.order,
                this.taskGroupsExpanded,
                this.shipperOrgCompanyName,
                this.shipperOrgHandle,
                this.offChrtShipperOrgCompanyName,
                this.forwarderOrgCompanyName,
                this.forwarderOrgHandle);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderStage builder() {
        return new Builder();
    }

    public interface OrderStage {
        _FinalStage order(@NotNull Order1 order);

        Builder from(OrderDraftExpandedRes other);
    }

    public interface _FinalStage {
        OrderDraftExpandedRes build();

        _FinalStage taskGroupsExpanded(Optional<List<TaskGroupDraftExpanded>> taskGroupsExpanded);

        _FinalStage taskGroupsExpanded(List<TaskGroupDraftExpanded> taskGroupsExpanded);

        _FinalStage taskGroupsExpanded(Nullable<List<TaskGroupDraftExpanded>> taskGroupsExpanded);

        _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName);

        _FinalStage shipperOrgHandle(Optional<String> shipperOrgHandle);

        _FinalStage shipperOrgHandle(String shipperOrgHandle);

        _FinalStage shipperOrgHandle(Nullable<String> shipperOrgHandle);

        _FinalStage offChrtShipperOrgCompanyName(Optional<String> offChrtShipperOrgCompanyName);

        _FinalStage offChrtShipperOrgCompanyName(String offChrtShipperOrgCompanyName);

        _FinalStage offChrtShipperOrgCompanyName(Nullable<String> offChrtShipperOrgCompanyName);

        _FinalStage forwarderOrgCompanyName(Optional<String> forwarderOrgCompanyName);

        _FinalStage forwarderOrgCompanyName(String forwarderOrgCompanyName);

        _FinalStage forwarderOrgCompanyName(Nullable<String> forwarderOrgCompanyName);

        _FinalStage forwarderOrgHandle(Optional<String> forwarderOrgHandle);

        _FinalStage forwarderOrgHandle(String forwarderOrgHandle);

        _FinalStage forwarderOrgHandle(Nullable<String> forwarderOrgHandle);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderStage, _FinalStage {
        private Order1 order;

        private Optional<String> forwarderOrgHandle = Optional.empty();

        private Optional<String> forwarderOrgCompanyName = Optional.empty();

        private Optional<String> offChrtShipperOrgCompanyName = Optional.empty();

        private Optional<String> shipperOrgHandle = Optional.empty();

        private Optional<String> shipperOrgCompanyName = Optional.empty();

        private Optional<List<TaskGroupDraftExpanded>> taskGroupsExpanded = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderDraftExpandedRes other) {
            order(other.getOrder());
            taskGroupsExpanded(other.getTaskGroupsExpanded());
            shipperOrgCompanyName(other.getShipperOrgCompanyName());
            shipperOrgHandle(other.getShipperOrgHandle());
            offChrtShipperOrgCompanyName(other.getOffChrtShipperOrgCompanyName());
            forwarderOrgCompanyName(other.getForwarderOrgCompanyName());
            forwarderOrgHandle(other.getForwarderOrgHandle());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order")
        public _FinalStage order(@NotNull Order1 order) {
            this.order = Objects.requireNonNull(order, "order must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgHandle(Nullable<String> forwarderOrgHandle) {
            if (forwarderOrgHandle.isNull()) {
                this.forwarderOrgHandle = null;
            } else if (forwarderOrgHandle.isEmpty()) {
                this.forwarderOrgHandle = Optional.empty();
            } else {
                this.forwarderOrgHandle = Optional.of(forwarderOrgHandle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgHandle(String forwarderOrgHandle) {
            this.forwarderOrgHandle = Optional.ofNullable(forwarderOrgHandle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_org_handle", nulls = Nulls.SKIP)
        public _FinalStage forwarderOrgHandle(Optional<String> forwarderOrgHandle) {
            this.forwarderOrgHandle = forwarderOrgHandle;
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgCompanyName(Nullable<String> forwarderOrgCompanyName) {
            if (forwarderOrgCompanyName.isNull()) {
                this.forwarderOrgCompanyName = null;
            } else if (forwarderOrgCompanyName.isEmpty()) {
                this.forwarderOrgCompanyName = Optional.empty();
            } else {
                this.forwarderOrgCompanyName = Optional.of(forwarderOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgCompanyName(String forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = Optional.ofNullable(forwarderOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage forwarderOrgCompanyName(Optional<String> forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = forwarderOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgCompanyName(Nullable<String> offChrtShipperOrgCompanyName) {
            if (offChrtShipperOrgCompanyName.isNull()) {
                this.offChrtShipperOrgCompanyName = null;
            } else if (offChrtShipperOrgCompanyName.isEmpty()) {
                this.offChrtShipperOrgCompanyName = Optional.empty();
            } else {
                this.offChrtShipperOrgCompanyName = Optional.of(offChrtShipperOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgCompanyName(String offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = Optional.ofNullable(offChrtShipperOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgCompanyName(Optional<String> offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgHandle(Nullable<String> shipperOrgHandle) {
            if (shipperOrgHandle.isNull()) {
                this.shipperOrgHandle = null;
            } else if (shipperOrgHandle.isEmpty()) {
                this.shipperOrgHandle = Optional.empty();
            } else {
                this.shipperOrgHandle = Optional.of(shipperOrgHandle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgHandle(String shipperOrgHandle) {
            this.shipperOrgHandle = Optional.ofNullable(shipperOrgHandle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_handle", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgHandle(Optional<String> shipperOrgHandle) {
            this.shipperOrgHandle = shipperOrgHandle;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName) {
            if (shipperOrgCompanyName.isNull()) {
                this.shipperOrgCompanyName = null;
            } else if (shipperOrgCompanyName.isEmpty()) {
                this.shipperOrgCompanyName = Optional.empty();
            } else {
                this.shipperOrgCompanyName = Optional.of(shipperOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName) {
            this.shipperOrgCompanyName = Optional.ofNullable(shipperOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName) {
            this.shipperOrgCompanyName = shipperOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupsExpanded(Nullable<List<TaskGroupDraftExpanded>> taskGroupsExpanded) {
            if (taskGroupsExpanded.isNull()) {
                this.taskGroupsExpanded = null;
            } else if (taskGroupsExpanded.isEmpty()) {
                this.taskGroupsExpanded = Optional.empty();
            } else {
                this.taskGroupsExpanded = Optional.of(taskGroupsExpanded.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupsExpanded(List<TaskGroupDraftExpanded> taskGroupsExpanded) {
            this.taskGroupsExpanded = Optional.ofNullable(taskGroupsExpanded);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_groups_expanded", nulls = Nulls.SKIP)
        public _FinalStage taskGroupsExpanded(Optional<List<TaskGroupDraftExpanded>> taskGroupsExpanded) {
            this.taskGroupsExpanded = taskGroupsExpanded;
            return this;
        }

        @java.lang.Override
        public OrderDraftExpandedRes build() {
            return new OrderDraftExpandedRes(
                    order,
                    taskGroupsExpanded,
                    shipperOrgCompanyName,
                    shipperOrgHandle,
                    offChrtShipperOrgCompanyName,
                    forwarderOrgCompanyName,
                    forwarderOrgHandle,
                    additionalProperties);
        }
    }
}
