/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderExpandedForOrderCreator.Builder.class)
public final class OrderExpandedForOrderCreator {
    private final Order1 order;

    private final Optional<List<TaskGroup1>> taskGroups;

    private final Optional<List<Task1>> tasks;

    private final Optional<List<TaskArtifact1>> taskArtifacts;

    private final Optional<List<Cargo1>> cargos;

    private final Optional<String> shipperOrgCompanyName;

    private final Optional<String> shipperOrgHandle;

    private final Map<String, Object> additionalProperties;

    private OrderExpandedForOrderCreator(
            Order1 order,
            Optional<List<TaskGroup1>> taskGroups,
            Optional<List<Task1>> tasks,
            Optional<List<TaskArtifact1>> taskArtifacts,
            Optional<List<Cargo1>> cargos,
            Optional<String> shipperOrgCompanyName,
            Optional<String> shipperOrgHandle,
            Map<String, Object> additionalProperties) {
        this.order = order;
        this.taskGroups = taskGroups;
        this.tasks = tasks;
        this.taskArtifacts = taskArtifacts;
        this.cargos = cargos;
        this.shipperOrgCompanyName = shipperOrgCompanyName;
        this.shipperOrgHandle = shipperOrgHandle;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order")
    public Order1 getOrder() {
        return order;
    }

    @JsonIgnore
    public Optional<List<TaskGroup1>> getTaskGroups() {
        if (taskGroups == null) {
            return Optional.empty();
        }
        return taskGroups;
    }

    @JsonIgnore
    public Optional<List<Task1>> getTasks() {
        if (tasks == null) {
            return Optional.empty();
        }
        return tasks;
    }

    @JsonIgnore
    public Optional<List<TaskArtifact1>> getTaskArtifacts() {
        if (taskArtifacts == null) {
            return Optional.empty();
        }
        return taskArtifacts;
    }

    @JsonIgnore
    public Optional<List<Cargo1>> getCargos() {
        if (cargos == null) {
            return Optional.empty();
        }
        return cargos;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgCompanyName() {
        if (shipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return shipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgHandle() {
        if (shipperOrgHandle == null) {
            return Optional.empty();
        }
        return shipperOrgHandle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_groups")
    private Optional<List<TaskGroup1>> _getTaskGroups() {
        return taskGroups;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("tasks")
    private Optional<List<Task1>> _getTasks() {
        return tasks;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_artifacts")
    private Optional<List<TaskArtifact1>> _getTaskArtifacts() {
        return taskArtifacts;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargos")
    private Optional<List<Cargo1>> _getCargos() {
        return cargos;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_company_name")
    private Optional<String> _getShipperOrgCompanyName() {
        return shipperOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_handle")
    private Optional<String> _getShipperOrgHandle() {
        return shipperOrgHandle;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderExpandedForOrderCreator && equalTo((OrderExpandedForOrderCreator) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderExpandedForOrderCreator other) {
        return order.equals(other.order)
                && taskGroups.equals(other.taskGroups)
                && tasks.equals(other.tasks)
                && taskArtifacts.equals(other.taskArtifacts)
                && cargos.equals(other.cargos)
                && shipperOrgCompanyName.equals(other.shipperOrgCompanyName)
                && shipperOrgHandle.equals(other.shipperOrgHandle);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.order,
                this.taskGroups,
                this.tasks,
                this.taskArtifacts,
                this.cargos,
                this.shipperOrgCompanyName,
                this.shipperOrgHandle);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderStage builder() {
        return new Builder();
    }

    public interface OrderStage {
        _FinalStage order(@NotNull Order1 order);

        Builder from(OrderExpandedForOrderCreator other);
    }

    public interface _FinalStage {
        OrderExpandedForOrderCreator build();

        _FinalStage taskGroups(Optional<List<TaskGroup1>> taskGroups);

        _FinalStage taskGroups(List<TaskGroup1> taskGroups);

        _FinalStage taskGroups(Nullable<List<TaskGroup1>> taskGroups);

        _FinalStage tasks(Optional<List<Task1>> tasks);

        _FinalStage tasks(List<Task1> tasks);

        _FinalStage tasks(Nullable<List<Task1>> tasks);

        _FinalStage taskArtifacts(Optional<List<TaskArtifact1>> taskArtifacts);

        _FinalStage taskArtifacts(List<TaskArtifact1> taskArtifacts);

        _FinalStage taskArtifacts(Nullable<List<TaskArtifact1>> taskArtifacts);

        _FinalStage cargos(Optional<List<Cargo1>> cargos);

        _FinalStage cargos(List<Cargo1> cargos);

        _FinalStage cargos(Nullable<List<Cargo1>> cargos);

        _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName);

        _FinalStage shipperOrgHandle(Optional<String> shipperOrgHandle);

        _FinalStage shipperOrgHandle(String shipperOrgHandle);

        _FinalStage shipperOrgHandle(Nullable<String> shipperOrgHandle);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderStage, _FinalStage {
        private Order1 order;

        private Optional<String> shipperOrgHandle = Optional.empty();

        private Optional<String> shipperOrgCompanyName = Optional.empty();

        private Optional<List<Cargo1>> cargos = Optional.empty();

        private Optional<List<TaskArtifact1>> taskArtifacts = Optional.empty();

        private Optional<List<Task1>> tasks = Optional.empty();

        private Optional<List<TaskGroup1>> taskGroups = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderExpandedForOrderCreator other) {
            order(other.getOrder());
            taskGroups(other.getTaskGroups());
            tasks(other.getTasks());
            taskArtifacts(other.getTaskArtifacts());
            cargos(other.getCargos());
            shipperOrgCompanyName(other.getShipperOrgCompanyName());
            shipperOrgHandle(other.getShipperOrgHandle());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order")
        public _FinalStage order(@NotNull Order1 order) {
            this.order = Objects.requireNonNull(order, "order must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgHandle(Nullable<String> shipperOrgHandle) {
            if (shipperOrgHandle.isNull()) {
                this.shipperOrgHandle = null;
            } else if (shipperOrgHandle.isEmpty()) {
                this.shipperOrgHandle = Optional.empty();
            } else {
                this.shipperOrgHandle = Optional.of(shipperOrgHandle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgHandle(String shipperOrgHandle) {
            this.shipperOrgHandle = Optional.ofNullable(shipperOrgHandle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_handle", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgHandle(Optional<String> shipperOrgHandle) {
            this.shipperOrgHandle = shipperOrgHandle;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName) {
            if (shipperOrgCompanyName.isNull()) {
                this.shipperOrgCompanyName = null;
            } else if (shipperOrgCompanyName.isEmpty()) {
                this.shipperOrgCompanyName = Optional.empty();
            } else {
                this.shipperOrgCompanyName = Optional.of(shipperOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName) {
            this.shipperOrgCompanyName = Optional.ofNullable(shipperOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName) {
            this.shipperOrgCompanyName = shipperOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage cargos(Nullable<List<Cargo1>> cargos) {
            if (cargos.isNull()) {
                this.cargos = null;
            } else if (cargos.isEmpty()) {
                this.cargos = Optional.empty();
            } else {
                this.cargos = Optional.of(cargos.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage cargos(List<Cargo1> cargos) {
            this.cargos = Optional.ofNullable(cargos);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargos", nulls = Nulls.SKIP)
        public _FinalStage cargos(Optional<List<Cargo1>> cargos) {
            this.cargos = cargos;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskArtifacts(Nullable<List<TaskArtifact1>> taskArtifacts) {
            if (taskArtifacts.isNull()) {
                this.taskArtifacts = null;
            } else if (taskArtifacts.isEmpty()) {
                this.taskArtifacts = Optional.empty();
            } else {
                this.taskArtifacts = Optional.of(taskArtifacts.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskArtifacts(List<TaskArtifact1> taskArtifacts) {
            this.taskArtifacts = Optional.ofNullable(taskArtifacts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_artifacts", nulls = Nulls.SKIP)
        public _FinalStage taskArtifacts(Optional<List<TaskArtifact1>> taskArtifacts) {
            this.taskArtifacts = taskArtifacts;
            return this;
        }

        @java.lang.Override
        public _FinalStage tasks(Nullable<List<Task1>> tasks) {
            if (tasks.isNull()) {
                this.tasks = null;
            } else if (tasks.isEmpty()) {
                this.tasks = Optional.empty();
            } else {
                this.tasks = Optional.of(tasks.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage tasks(List<Task1> tasks) {
            this.tasks = Optional.ofNullable(tasks);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tasks", nulls = Nulls.SKIP)
        public _FinalStage tasks(Optional<List<Task1>> tasks) {
            this.tasks = tasks;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroups(Nullable<List<TaskGroup1>> taskGroups) {
            if (taskGroups.isNull()) {
                this.taskGroups = null;
            } else if (taskGroups.isEmpty()) {
                this.taskGroups = Optional.empty();
            } else {
                this.taskGroups = Optional.of(taskGroups.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroups(List<TaskGroup1> taskGroups) {
            this.taskGroups = Optional.ofNullable(taskGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_groups", nulls = Nulls.SKIP)
        public _FinalStage taskGroups(Optional<List<TaskGroup1>> taskGroups) {
            this.taskGroups = taskGroups;
            return this;
        }

        @java.lang.Override
        public OrderExpandedForOrderCreator build() {
            return new OrderExpandedForOrderCreator(
                    order,
                    taskGroups,
                    tasks,
                    taskArtifacts,
                    cargos,
                    shipperOrgCompanyName,
                    shipperOrgHandle,
                    additionalProperties);
        }
    }
}
