/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderExpandedForShipperReq.Builder.class)
public final class OrderExpandedForShipperReq {
    private final Optional<Boolean> expandTaskGroups;

    private final Optional<Boolean> expandTasks;

    private final Optional<Boolean> expandTaskArtifacts;

    private final Optional<Boolean> expandCargos;

    private final Optional<Boolean> expandCourierOrgCompanyName;

    private final Optional<Boolean> expandCourierOrgHandle;

    private final Map<String, Object> additionalProperties;

    private OrderExpandedForShipperReq(
            Optional<Boolean> expandTaskGroups,
            Optional<Boolean> expandTasks,
            Optional<Boolean> expandTaskArtifacts,
            Optional<Boolean> expandCargos,
            Optional<Boolean> expandCourierOrgCompanyName,
            Optional<Boolean> expandCourierOrgHandle,
            Map<String, Object> additionalProperties) {
        this.expandTaskGroups = expandTaskGroups;
        this.expandTasks = expandTasks;
        this.expandTaskArtifacts = expandTaskArtifacts;
        this.expandCargos = expandCargos;
        this.expandCourierOrgCompanyName = expandCourierOrgCompanyName;
        this.expandCourierOrgHandle = expandCourierOrgHandle;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("expand_task_groups")
    public Optional<Boolean> getExpandTaskGroups() {
        return expandTaskGroups;
    }

    @JsonProperty("expand_tasks")
    public Optional<Boolean> getExpandTasks() {
        return expandTasks;
    }

    @JsonProperty("expand_task_artifacts")
    public Optional<Boolean> getExpandTaskArtifacts() {
        return expandTaskArtifacts;
    }

    @JsonProperty("expand_cargos")
    public Optional<Boolean> getExpandCargos() {
        return expandCargos;
    }

    @JsonProperty("expand_courier_org_company_name")
    public Optional<Boolean> getExpandCourierOrgCompanyName() {
        return expandCourierOrgCompanyName;
    }

    @JsonProperty("expand_courier_org_handle")
    public Optional<Boolean> getExpandCourierOrgHandle() {
        return expandCourierOrgHandle;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderExpandedForShipperReq && equalTo((OrderExpandedForShipperReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderExpandedForShipperReq other) {
        return expandTaskGroups.equals(other.expandTaskGroups)
                && expandTasks.equals(other.expandTasks)
                && expandTaskArtifacts.equals(other.expandTaskArtifacts)
                && expandCargos.equals(other.expandCargos)
                && expandCourierOrgCompanyName.equals(other.expandCourierOrgCompanyName)
                && expandCourierOrgHandle.equals(other.expandCourierOrgHandle);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.expandTaskGroups,
                this.expandTasks,
                this.expandTaskArtifacts,
                this.expandCargos,
                this.expandCourierOrgCompanyName,
                this.expandCourierOrgHandle);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Boolean> expandTaskGroups = Optional.empty();

        private Optional<Boolean> expandTasks = Optional.empty();

        private Optional<Boolean> expandTaskArtifacts = Optional.empty();

        private Optional<Boolean> expandCargos = Optional.empty();

        private Optional<Boolean> expandCourierOrgCompanyName = Optional.empty();

        private Optional<Boolean> expandCourierOrgHandle = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(OrderExpandedForShipperReq other) {
            expandTaskGroups(other.getExpandTaskGroups());
            expandTasks(other.getExpandTasks());
            expandTaskArtifacts(other.getExpandTaskArtifacts());
            expandCargos(other.getExpandCargos());
            expandCourierOrgCompanyName(other.getExpandCourierOrgCompanyName());
            expandCourierOrgHandle(other.getExpandCourierOrgHandle());
            return this;
        }

        @JsonSetter(value = "expand_task_groups", nulls = Nulls.SKIP)
        public Builder expandTaskGroups(Optional<Boolean> expandTaskGroups) {
            this.expandTaskGroups = expandTaskGroups;
            return this;
        }

        public Builder expandTaskGroups(Boolean expandTaskGroups) {
            this.expandTaskGroups = Optional.ofNullable(expandTaskGroups);
            return this;
        }

        @JsonSetter(value = "expand_tasks", nulls = Nulls.SKIP)
        public Builder expandTasks(Optional<Boolean> expandTasks) {
            this.expandTasks = expandTasks;
            return this;
        }

        public Builder expandTasks(Boolean expandTasks) {
            this.expandTasks = Optional.ofNullable(expandTasks);
            return this;
        }

        @JsonSetter(value = "expand_task_artifacts", nulls = Nulls.SKIP)
        public Builder expandTaskArtifacts(Optional<Boolean> expandTaskArtifacts) {
            this.expandTaskArtifacts = expandTaskArtifacts;
            return this;
        }

        public Builder expandTaskArtifacts(Boolean expandTaskArtifacts) {
            this.expandTaskArtifacts = Optional.ofNullable(expandTaskArtifacts);
            return this;
        }

        @JsonSetter(value = "expand_cargos", nulls = Nulls.SKIP)
        public Builder expandCargos(Optional<Boolean> expandCargos) {
            this.expandCargos = expandCargos;
            return this;
        }

        public Builder expandCargos(Boolean expandCargos) {
            this.expandCargos = Optional.ofNullable(expandCargos);
            return this;
        }

        @JsonSetter(value = "expand_courier_org_company_name", nulls = Nulls.SKIP)
        public Builder expandCourierOrgCompanyName(Optional<Boolean> expandCourierOrgCompanyName) {
            this.expandCourierOrgCompanyName = expandCourierOrgCompanyName;
            return this;
        }

        public Builder expandCourierOrgCompanyName(Boolean expandCourierOrgCompanyName) {
            this.expandCourierOrgCompanyName = Optional.ofNullable(expandCourierOrgCompanyName);
            return this;
        }

        @JsonSetter(value = "expand_courier_org_handle", nulls = Nulls.SKIP)
        public Builder expandCourierOrgHandle(Optional<Boolean> expandCourierOrgHandle) {
            this.expandCourierOrgHandle = expandCourierOrgHandle;
            return this;
        }

        public Builder expandCourierOrgHandle(Boolean expandCourierOrgHandle) {
            this.expandCourierOrgHandle = Optional.ofNullable(expandCourierOrgHandle);
            return this;
        }

        public OrderExpandedForShipperReq build() {
            return new OrderExpandedForShipperReq(
                    expandTaskGroups,
                    expandTasks,
                    expandTaskArtifacts,
                    expandCargos,
                    expandCourierOrgCompanyName,
                    expandCourierOrgHandle,
                    additionalProperties);
        }
    }
}
