/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrdersDraftUpdateRes.Builder.class)
public final class OrdersDraftUpdateRes {
    private final String orderId;

    private final String orderShortId;

    private final Optional<String> forwarderOrgId;

    private final Optional<String> shipperOrgId;

    private final Optional<String> offChrtShipperOrgId;

    private final Map<String, Object> additionalProperties;

    private OrdersDraftUpdateRes(
            String orderId,
            String orderShortId,
            Optional<String> forwarderOrgId,
            Optional<String> shipperOrgId,
            Optional<String> offChrtShipperOrgId,
            Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.forwarderOrgId = forwarderOrgId;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getForwarderOrgId() {
        if (forwarderOrgId == null) {
            return Optional.empty();
        }
        return forwarderOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_org_id")
    private Optional<String> _getForwarderOrgId() {
        return forwarderOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrdersDraftUpdateRes && equalTo((OrdersDraftUpdateRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrdersDraftUpdateRes other) {
        return orderId.equals(other.orderId)
                && orderShortId.equals(other.orderShortId)
                && forwarderOrgId.equals(other.forwarderOrgId)
                && shipperOrgId.equals(other.shipperOrgId)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.orderId, this.orderShortId, this.forwarderOrgId, this.shipperOrgId, this.offChrtShipperOrgId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);

        Builder from(OrdersDraftUpdateRes other);
    }

    public interface OrderShortIdStage {
        _FinalStage orderShortId(@NotNull String orderShortId);
    }

    public interface _FinalStage {
        OrdersDraftUpdateRes build();

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage forwarderOrgId(Optional<String> forwarderOrgId);

        _FinalStage forwarderOrgId(String forwarderOrgId);

        _FinalStage forwarderOrgId(Nullable<String> forwarderOrgId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage shipperOrgId(Optional<String> shipperOrgId);

        _FinalStage shipperOrgId(String shipperOrgId);

        _FinalStage shipperOrgId(Nullable<String> shipperOrgId);

        _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderIdStage, OrderShortIdStage, _FinalStage {
        private String orderId;

        private String orderShortId;

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        private Optional<String> shipperOrgId = Optional.empty();

        private Optional<String> forwarderOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrdersDraftUpdateRes other) {
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            forwarderOrgId(other.getForwarderOrgId());
            shipperOrgId(other.getShipperOrgId());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public _FinalStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage forwarderOrgId(Nullable<String> forwarderOrgId) {
            if (forwarderOrgId.isNull()) {
                this.forwarderOrgId = null;
            } else if (forwarderOrgId.isEmpty()) {
                this.forwarderOrgId = Optional.empty();
            } else {
                this.forwarderOrgId = Optional.of(forwarderOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage forwarderOrgId(String forwarderOrgId) {
            this.forwarderOrgId = Optional.ofNullable(forwarderOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "forwarder_org_id", nulls = Nulls.SKIP)
        public _FinalStage forwarderOrgId(Optional<String> forwarderOrgId) {
            this.forwarderOrgId = forwarderOrgId;
            return this;
        }

        @java.lang.Override
        public OrdersDraftUpdateRes build() {
            return new OrdersDraftUpdateRes(
                    orderId, orderShortId, forwarderOrgId, shipperOrgId, offChrtShipperOrgId, additionalProperties);
        }
    }
}
