/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskArtifact1.Builder.class)
public final class TaskArtifact1 {
    private final int schemaVersion;

    private final TaskArtifactTypeEnum1 type;

    private final String id;

    private final String orderId;

    private final String orderShortId;

    private final String taskGroupId;

    private final String taskId;

    private final Optional<List<String>> taskArtifactS3ObjectMetadataIds;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final Optional<String> requestedByOrgId;

    private final Optional<String> requestedByUserId;

    private final Optional<String> completedByOrgId;

    private final Optional<String> completedByUserId;

    private final Optional<TaskArtifactStatusEnum1> status;

    private final OffsetDateTime draftStartedAtTimestamp;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> completedAtTimestamp;

    private final Optional<OffsetDateTime> exceptionAtTimestamp;

    private final Map<String, Object> additionalProperties;

    private TaskArtifact1(
            int schemaVersion,
            TaskArtifactTypeEnum1 type,
            String id,
            String orderId,
            String orderShortId,
            String taskGroupId,
            String taskId,
            Optional<List<String>> taskArtifactS3ObjectMetadataIds,
            String createdByOrgId,
            String createdByUserId,
            Optional<String> requestedByOrgId,
            Optional<String> requestedByUserId,
            Optional<String> completedByOrgId,
            Optional<String> completedByUserId,
            Optional<TaskArtifactStatusEnum1> status,
            OffsetDateTime draftStartedAtTimestamp,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> completedAtTimestamp,
            Optional<OffsetDateTime> exceptionAtTimestamp,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.type = type;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskGroupId = taskGroupId;
        this.taskId = taskId;
        this.taskArtifactS3ObjectMetadataIds = taskArtifactS3ObjectMetadataIds;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.requestedByOrgId = requestedByOrgId;
        this.requestedByUserId = requestedByUserId;
        this.completedByOrgId = completedByOrgId;
        this.completedByUserId = completedByUserId;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("type")
    public TaskArtifactTypeEnum1 getType() {
        return type;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonProperty("task_id")
    public String getTaskId() {
        return taskId;
    }

    @JsonProperty("task_artifact_s3_object_metadata_ids")
    public Optional<List<String>> getTaskArtifactS3ObjectMetadataIds() {
        return taskArtifactS3ObjectMetadataIds;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getRequestedByOrgId() {
        if (requestedByOrgId == null) {
            return Optional.empty();
        }
        return requestedByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getRequestedByUserId() {
        if (requestedByUserId == null) {
            return Optional.empty();
        }
        return requestedByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getCompletedByOrgId() {
        if (completedByOrgId == null) {
            return Optional.empty();
        }
        return completedByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getCompletedByUserId() {
        if (completedByUserId == null) {
            return Optional.empty();
        }
        return completedByUserId;
    }

    @JsonProperty("status")
    public Optional<TaskArtifactStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (completedAtTimestamp == null) {
            return Optional.empty();
        }
        return completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return exceptionAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("requested_by_org_id")
    private Optional<String> _getRequestedByOrgId() {
        return requestedByOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("requested_by_user_id")
    private Optional<String> _getRequestedByUserId() {
        return requestedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_by_org_id")
    private Optional<String> _getCompletedByOrgId() {
        return completedByOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_by_user_id")
    private Optional<String> _getCompletedByUserId() {
        return completedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return completedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return exceptionAtTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskArtifact1 && equalTo((TaskArtifact1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskArtifact1 other) {
        return schemaVersion == other.schemaVersion
                && type.equals(other.type)
                && id.equals(other.id)
                && orderId.equals(other.orderId)
                && orderShortId.equals(other.orderShortId)
                && taskGroupId.equals(other.taskGroupId)
                && taskId.equals(other.taskId)
                && taskArtifactS3ObjectMetadataIds.equals(other.taskArtifactS3ObjectMetadataIds)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && requestedByOrgId.equals(other.requestedByOrgId)
                && requestedByUserId.equals(other.requestedByUserId)
                && completedByOrgId.equals(other.completedByOrgId)
                && completedByUserId.equals(other.completedByUserId)
                && status.equals(other.status)
                && draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && completedAtTimestamp.equals(other.completedAtTimestamp)
                && exceptionAtTimestamp.equals(other.exceptionAtTimestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.type,
                this.id,
                this.orderId,
                this.orderShortId,
                this.taskGroupId,
                this.taskId,
                this.taskArtifactS3ObjectMetadataIds,
                this.createdByOrgId,
                this.createdByUserId,
                this.requestedByOrgId,
                this.requestedByUserId,
                this.completedByOrgId,
                this.completedByUserId,
                this.status,
                this.draftStartedAtTimestamp,
                this.stagedAtTimestamp,
                this.completedAtTimestamp,
                this.exceptionAtTimestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        TypeStage schemaVersion(int schemaVersion);

        Builder from(TaskArtifact1 other);
    }

    public interface TypeStage {
        IdStage type(@NotNull TaskArtifactTypeEnum1 type);
    }

    public interface IdStage {
        OrderIdStage id(@NotNull String id);
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);
    }

    public interface OrderShortIdStage {
        TaskGroupIdStage orderShortId(@NotNull String orderShortId);
    }

    public interface TaskGroupIdStage {
        TaskIdStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface TaskIdStage {
        CreatedByOrgIdStage taskId(@NotNull String taskId);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface DraftStartedAtTimestampStage {
        _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp);
    }

    public interface _FinalStage {
        TaskArtifact1 build();

        _FinalStage taskArtifactS3ObjectMetadataIds(Optional<List<String>> taskArtifactS3ObjectMetadataIds);

        _FinalStage taskArtifactS3ObjectMetadataIds(List<String> taskArtifactS3ObjectMetadataIds);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage requestedByOrgId(Optional<String> requestedByOrgId);

        _FinalStage requestedByOrgId(String requestedByOrgId);

        _FinalStage requestedByOrgId(Nullable<String> requestedByOrgId);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage requestedByUserId(Optional<String> requestedByUserId);

        _FinalStage requestedByUserId(String requestedByUserId);

        _FinalStage requestedByUserId(Nullable<String> requestedByUserId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage completedByOrgId(Optional<String> completedByOrgId);

        _FinalStage completedByOrgId(String completedByOrgId);

        _FinalStage completedByOrgId(Nullable<String> completedByOrgId);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage completedByUserId(Optional<String> completedByUserId);

        _FinalStage completedByUserId(String completedByUserId);

        _FinalStage completedByUserId(Nullable<String> completedByUserId);

        _FinalStage status(Optional<TaskArtifactStatusEnum1> status);

        _FinalStage status(TaskArtifactStatusEnum1 status);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp);

        _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp);

        _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp);

        _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    TypeStage,
                    IdStage,
                    OrderIdStage,
                    OrderShortIdStage,
                    TaskGroupIdStage,
                    TaskIdStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    DraftStartedAtTimestampStage,
                    _FinalStage {
        private int schemaVersion;

        private TaskArtifactTypeEnum1 type;

        private String id;

        private String orderId;

        private String orderShortId;

        private String taskGroupId;

        private String taskId;

        private String createdByOrgId;

        private String createdByUserId;

        private OffsetDateTime draftStartedAtTimestamp;

        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<TaskArtifactStatusEnum1> status = Optional.empty();

        private Optional<String> completedByUserId = Optional.empty();

        private Optional<String> completedByOrgId = Optional.empty();

        private Optional<String> requestedByUserId = Optional.empty();

        private Optional<String> requestedByOrgId = Optional.empty();

        private Optional<List<String>> taskArtifactS3ObjectMetadataIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskArtifact1 other) {
            schemaVersion(other.getSchemaVersion());
            type(other.getType());
            id(other.getId());
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            taskGroupId(other.getTaskGroupId());
            taskId(other.getTaskId());
            taskArtifactS3ObjectMetadataIds(other.getTaskArtifactS3ObjectMetadataIds());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            requestedByOrgId(other.getRequestedByOrgId());
            requestedByUserId(other.getRequestedByUserId());
            completedByOrgId(other.getCompletedByOrgId());
            completedByUserId(other.getCompletedByUserId());
            status(other.getStatus());
            draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            completedAtTimestamp(other.getCompletedAtTimestamp());
            exceptionAtTimestamp(other.getExceptionAtTimestamp());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public TypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull TaskArtifactTypeEnum1 type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public TaskGroupIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public TaskIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_id")
        public CreatedByOrgIdStage taskId(@NotNull String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp =
                    Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            if (exceptionAtTimestamp.isNull()) {
                this.exceptionAtTimestamp = null;
            } else if (exceptionAtTimestamp.isEmpty()) {
                this.exceptionAtTimestamp = Optional.empty();
            } else {
                this.exceptionAtTimestamp = Optional.of(exceptionAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exception_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            if (completedAtTimestamp.isNull()) {
                this.completedAtTimestamp = null;
            } else if (completedAtTimestamp.isEmpty()) {
                this.completedAtTimestamp = Optional.empty();
            } else {
                this.completedAtTimestamp = Optional.of(completedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "completed_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(TaskArtifactStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<TaskArtifactStatusEnum1> status) {
            this.status = status;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByUserId(Nullable<String> completedByUserId) {
            if (completedByUserId.isNull()) {
                this.completedByUserId = null;
            } else if (completedByUserId.isEmpty()) {
                this.completedByUserId = Optional.empty();
            } else {
                this.completedByUserId = Optional.of(completedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByUserId(String completedByUserId) {
            this.completedByUserId = Optional.ofNullable(completedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "completed_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage completedByUserId(Optional<String> completedByUserId) {
            this.completedByUserId = completedByUserId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByOrgId(Nullable<String> completedByOrgId) {
            if (completedByOrgId.isNull()) {
                this.completedByOrgId = null;
            } else if (completedByOrgId.isEmpty()) {
                this.completedByOrgId = Optional.empty();
            } else {
                this.completedByOrgId = Optional.of(completedByOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByOrgId(String completedByOrgId) {
            this.completedByOrgId = Optional.ofNullable(completedByOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "completed_by_org_id", nulls = Nulls.SKIP)
        public _FinalStage completedByOrgId(Optional<String> completedByOrgId) {
            this.completedByOrgId = completedByOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requestedByUserId(Nullable<String> requestedByUserId) {
            if (requestedByUserId.isNull()) {
                this.requestedByUserId = null;
            } else if (requestedByUserId.isEmpty()) {
                this.requestedByUserId = Optional.empty();
            } else {
                this.requestedByUserId = Optional.of(requestedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requestedByUserId(String requestedByUserId) {
            this.requestedByUserId = Optional.ofNullable(requestedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "requested_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage requestedByUserId(Optional<String> requestedByUserId) {
            this.requestedByUserId = requestedByUserId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requestedByOrgId(Nullable<String> requestedByOrgId) {
            if (requestedByOrgId.isNull()) {
                this.requestedByOrgId = null;
            } else if (requestedByOrgId.isEmpty()) {
                this.requestedByOrgId = Optional.empty();
            } else {
                this.requestedByOrgId = Optional.of(requestedByOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requestedByOrgId(String requestedByOrgId) {
            this.requestedByOrgId = Optional.ofNullable(requestedByOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "requested_by_org_id", nulls = Nulls.SKIP)
        public _FinalStage requestedByOrgId(Optional<String> requestedByOrgId) {
            this.requestedByOrgId = requestedByOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskArtifactS3ObjectMetadataIds(List<String> taskArtifactS3ObjectMetadataIds) {
            this.taskArtifactS3ObjectMetadataIds = Optional.ofNullable(taskArtifactS3ObjectMetadataIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_artifact_s3_object_metadata_ids", nulls = Nulls.SKIP)
        public _FinalStage taskArtifactS3ObjectMetadataIds(Optional<List<String>> taskArtifactS3ObjectMetadataIds) {
            this.taskArtifactS3ObjectMetadataIds = taskArtifactS3ObjectMetadataIds;
            return this;
        }

        @java.lang.Override
        public TaskArtifact1 build() {
            return new TaskArtifact1(
                    schemaVersion,
                    type,
                    id,
                    orderId,
                    orderShortId,
                    taskGroupId,
                    taskId,
                    taskArtifactS3ObjectMetadataIds,
                    createdByOrgId,
                    createdByUserId,
                    requestedByOrgId,
                    requestedByUserId,
                    completedByOrgId,
                    completedByUserId,
                    status,
                    draftStartedAtTimestamp,
                    stagedAtTimestamp,
                    completedAtTimestamp,
                    exceptionAtTimestamp,
                    additionalProperties);
        }
    }
}
