/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskClientUpdate1.Builder.class)
public final class TaskClientUpdate1 {
    private final Optional<LocationFeature> location;

    private final Optional<Action> action;

    private final Optional<List<TimeWindow1>> timeWindows;

    private final Optional<List<String>> shipperContactInfoIds;

    private final Optional<String> flightNumber;

    private final Map<String, Object> additionalProperties;

    private TaskClientUpdate1(
            Optional<LocationFeature> location,
            Optional<Action> action,
            Optional<List<TimeWindow1>> timeWindows,
            Optional<List<String>> shipperContactInfoIds,
            Optional<String> flightNumber,
            Map<String, Object> additionalProperties) {
        this.location = location;
        this.action = action;
        this.timeWindows = timeWindows;
        this.shipperContactInfoIds = shipperContactInfoIds;
        this.flightNumber = flightNumber;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (location == null) {
            return Optional.empty();
        }
        return location;
    }

    @JsonIgnore
    public Optional<Action> getAction() {
        if (action == null) {
            return Optional.empty();
        }
        return action;
    }

    @JsonIgnore
    public Optional<List<TimeWindow1>> getTimeWindows() {
        if (timeWindows == null) {
            return Optional.empty();
        }
        return timeWindows;
    }

    @JsonIgnore
    public Optional<List<String>> getShipperContactInfoIds() {
        if (shipperContactInfoIds == null) {
            return Optional.empty();
        }
        return shipperContactInfoIds;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (flightNumber == null) {
            return Optional.empty();
        }
        return flightNumber;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("location")
    private Optional<LocationFeature> _getLocation() {
        return location;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("action")
    private Optional<Action> _getAction() {
        return action;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("time_windows")
    private Optional<List<TimeWindow1>> _getTimeWindows() {
        return timeWindows;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_contact_info_ids")
    private Optional<List<String>> _getShipperContactInfoIds() {
        return shipperContactInfoIds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("flight_number")
    private Optional<String> _getFlightNumber() {
        return flightNumber;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskClientUpdate1 && equalTo((TaskClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskClientUpdate1 other) {
        return location.equals(other.location)
                && action.equals(other.action)
                && timeWindows.equals(other.timeWindows)
                && shipperContactInfoIds.equals(other.shipperContactInfoIds)
                && flightNumber.equals(other.flightNumber);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.location, this.action, this.timeWindows, this.shipperContactInfoIds, this.flightNumber);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<LocationFeature> location = Optional.empty();

        private Optional<Action> action = Optional.empty();

        private Optional<List<TimeWindow1>> timeWindows = Optional.empty();

        private Optional<List<String>> shipperContactInfoIds = Optional.empty();

        private Optional<String> flightNumber = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TaskClientUpdate1 other) {
            location(other.getLocation());
            action(other.getAction());
            timeWindows(other.getTimeWindows());
            shipperContactInfoIds(other.getShipperContactInfoIds());
            flightNumber(other.getFlightNumber());
            return this;
        }

        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public Builder location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        public Builder location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public Builder location(Nullable<LocationFeature> location) {
            if (location.isNull()) {
                this.location = null;
            } else if (location.isEmpty()) {
                this.location = Optional.empty();
            } else {
                this.location = Optional.of(location.get());
            }
            return this;
        }

        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public Builder action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        public Builder action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        public Builder action(Nullable<Action> action) {
            if (action.isNull()) {
                this.action = null;
            } else if (action.isEmpty()) {
                this.action = Optional.empty();
            } else {
                this.action = Optional.of(action.get());
            }
            return this;
        }

        @JsonSetter(value = "time_windows", nulls = Nulls.SKIP)
        public Builder timeWindows(Optional<List<TimeWindow1>> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        public Builder timeWindows(List<TimeWindow1> timeWindows) {
            this.timeWindows = Optional.ofNullable(timeWindows);
            return this;
        }

        public Builder timeWindows(Nullable<List<TimeWindow1>> timeWindows) {
            if (timeWindows.isNull()) {
                this.timeWindows = null;
            } else if (timeWindows.isEmpty()) {
                this.timeWindows = Optional.empty();
            } else {
                this.timeWindows = Optional.of(timeWindows.get());
            }
            return this;
        }

        @JsonSetter(value = "shipper_contact_info_ids", nulls = Nulls.SKIP)
        public Builder shipperContactInfoIds(Optional<List<String>> shipperContactInfoIds) {
            this.shipperContactInfoIds = shipperContactInfoIds;
            return this;
        }

        public Builder shipperContactInfoIds(List<String> shipperContactInfoIds) {
            this.shipperContactInfoIds = Optional.ofNullable(shipperContactInfoIds);
            return this;
        }

        public Builder shipperContactInfoIds(Nullable<List<String>> shipperContactInfoIds) {
            if (shipperContactInfoIds.isNull()) {
                this.shipperContactInfoIds = null;
            } else if (shipperContactInfoIds.isEmpty()) {
                this.shipperContactInfoIds = Optional.empty();
            } else {
                this.shipperContactInfoIds = Optional.of(shipperContactInfoIds.get());
            }
            return this;
        }

        @JsonSetter(value = "flight_number", nulls = Nulls.SKIP)
        public Builder flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        public Builder flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        public Builder flightNumber(Nullable<String> flightNumber) {
            if (flightNumber.isNull()) {
                this.flightNumber = null;
            } else if (flightNumber.isEmpty()) {
                this.flightNumber = Optional.empty();
            } else {
                this.flightNumber = Optional.of(flightNumber.get());
            }
            return this;
        }

        public TaskClientUpdate1 build() {
            return new TaskClientUpdate1(
                    location, action, timeWindows, shipperContactInfoIds, flightNumber, additionalProperties);
        }
    }
}
