/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskDraftExpanded.Builder.class)
public final class TaskDraftExpanded {
    private final Task1 task;

    private final Optional<List<Cargo1>> cargos;

    private final Optional<List<TaskArtifact1>> taskArtifacts;

    private final Optional<List<ShipperContact1>> shipperContacts;

    private final Map<String, Object> additionalProperties;

    private TaskDraftExpanded(
            Task1 task,
            Optional<List<Cargo1>> cargos,
            Optional<List<TaskArtifact1>> taskArtifacts,
            Optional<List<ShipperContact1>> shipperContacts,
            Map<String, Object> additionalProperties) {
        this.task = task;
        this.cargos = cargos;
        this.taskArtifacts = taskArtifacts;
        this.shipperContacts = shipperContacts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task")
    public Task1 getTask() {
        return task;
    }

    @JsonIgnore
    public Optional<List<Cargo1>> getCargos() {
        if (cargos == null) {
            return Optional.empty();
        }
        return cargos;
    }

    @JsonIgnore
    public Optional<List<TaskArtifact1>> getTaskArtifacts() {
        if (taskArtifacts == null) {
            return Optional.empty();
        }
        return taskArtifacts;
    }

    @JsonIgnore
    public Optional<List<ShipperContact1>> getShipperContacts() {
        if (shipperContacts == null) {
            return Optional.empty();
        }
        return shipperContacts;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargos")
    private Optional<List<Cargo1>> _getCargos() {
        return cargos;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_artifacts")
    private Optional<List<TaskArtifact1>> _getTaskArtifacts() {
        return taskArtifacts;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_contacts")
    private Optional<List<ShipperContact1>> _getShipperContacts() {
        return shipperContacts;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskDraftExpanded && equalTo((TaskDraftExpanded) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskDraftExpanded other) {
        return task.equals(other.task)
                && cargos.equals(other.cargos)
                && taskArtifacts.equals(other.taskArtifacts)
                && shipperContacts.equals(other.shipperContacts);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.task, this.cargos, this.taskArtifacts, this.shipperContacts);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskStage builder() {
        return new Builder();
    }

    public interface TaskStage {
        _FinalStage task(@NotNull Task1 task);

        Builder from(TaskDraftExpanded other);
    }

    public interface _FinalStage {
        TaskDraftExpanded build();

        _FinalStage cargos(Optional<List<Cargo1>> cargos);

        _FinalStage cargos(List<Cargo1> cargos);

        _FinalStage cargos(Nullable<List<Cargo1>> cargos);

        _FinalStage taskArtifacts(Optional<List<TaskArtifact1>> taskArtifacts);

        _FinalStage taskArtifacts(List<TaskArtifact1> taskArtifacts);

        _FinalStage taskArtifacts(Nullable<List<TaskArtifact1>> taskArtifacts);

        _FinalStage shipperContacts(Optional<List<ShipperContact1>> shipperContacts);

        _FinalStage shipperContacts(List<ShipperContact1> shipperContacts);

        _FinalStage shipperContacts(Nullable<List<ShipperContact1>> shipperContacts);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskStage, _FinalStage {
        private Task1 task;

        private Optional<List<ShipperContact1>> shipperContacts = Optional.empty();

        private Optional<List<TaskArtifact1>> taskArtifacts = Optional.empty();

        private Optional<List<Cargo1>> cargos = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskDraftExpanded other) {
            task(other.getTask());
            cargos(other.getCargos());
            taskArtifacts(other.getTaskArtifacts());
            shipperContacts(other.getShipperContacts());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task")
        public _FinalStage task(@NotNull Task1 task) {
            this.task = Objects.requireNonNull(task, "task must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperContacts(Nullable<List<ShipperContact1>> shipperContacts) {
            if (shipperContacts.isNull()) {
                this.shipperContacts = null;
            } else if (shipperContacts.isEmpty()) {
                this.shipperContacts = Optional.empty();
            } else {
                this.shipperContacts = Optional.of(shipperContacts.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperContacts(List<ShipperContact1> shipperContacts) {
            this.shipperContacts = Optional.ofNullable(shipperContacts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_contacts", nulls = Nulls.SKIP)
        public _FinalStage shipperContacts(Optional<List<ShipperContact1>> shipperContacts) {
            this.shipperContacts = shipperContacts;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskArtifacts(Nullable<List<TaskArtifact1>> taskArtifacts) {
            if (taskArtifacts.isNull()) {
                this.taskArtifacts = null;
            } else if (taskArtifacts.isEmpty()) {
                this.taskArtifacts = Optional.empty();
            } else {
                this.taskArtifacts = Optional.of(taskArtifacts.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskArtifacts(List<TaskArtifact1> taskArtifacts) {
            this.taskArtifacts = Optional.ofNullable(taskArtifacts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_artifacts", nulls = Nulls.SKIP)
        public _FinalStage taskArtifacts(Optional<List<TaskArtifact1>> taskArtifacts) {
            this.taskArtifacts = taskArtifacts;
            return this;
        }

        @java.lang.Override
        public _FinalStage cargos(Nullable<List<Cargo1>> cargos) {
            if (cargos.isNull()) {
                this.cargos = null;
            } else if (cargos.isEmpty()) {
                this.cargos = Optional.empty();
            } else {
                this.cargos = Optional.of(cargos.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage cargos(List<Cargo1> cargos) {
            this.cargos = Optional.ofNullable(cargos);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargos", nulls = Nulls.SKIP)
        public _FinalStage cargos(Optional<List<Cargo1>> cargos) {
            this.cargos = cargos;
            return this;
        }

        @java.lang.Override
        public TaskDraftExpanded build() {
            return new TaskDraftExpanded(task, cargos, taskArtifacts, shipperContacts, additionalProperties);
        }
    }
}
