/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskGroup1.Builder.class)
public final class TaskGroup1 {
    private final int schemaVersion;

    private final String id;

    private final String orderId;

    private final String orderShortId;

    private final Optional<List<String>> taskIds;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final Optional<String> courierOrgId;

    private final Optional<String> driverId;

    private final Optional<List<String>> taskGroupS3ObjectMetadataIds;

    private final Optional<TaskGroupStatusEnum1> status;

    private final OffsetDateTime draftStartedAtTimestamp;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> inProgressAtTimestamp;

    private final Optional<OffsetDateTime> completedAtTimestamp;

    private final Optional<OffsetDateTime> exceptionAtTimestamp;

    private final Optional<Boolean> orderCancelled;

    private final TaskGroupTypeEnum1 taskGroupType;

    private final Optional<TaskGroupMileage1> taskGroupMileage;

    private final Optional<List<TaskGroupMessage1>> messages;

    private final Map<String, Object> additionalProperties;

    private TaskGroup1(
            int schemaVersion,
            String id,
            String orderId,
            String orderShortId,
            Optional<List<String>> taskIds,
            String createdByOrgId,
            String createdByUserId,
            Optional<String> courierOrgId,
            Optional<String> driverId,
            Optional<List<String>> taskGroupS3ObjectMetadataIds,
            Optional<TaskGroupStatusEnum1> status,
            OffsetDateTime draftStartedAtTimestamp,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> inProgressAtTimestamp,
            Optional<OffsetDateTime> completedAtTimestamp,
            Optional<OffsetDateTime> exceptionAtTimestamp,
            Optional<Boolean> orderCancelled,
            TaskGroupTypeEnum1 taskGroupType,
            Optional<TaskGroupMileage1> taskGroupMileage,
            Optional<List<TaskGroupMessage1>> messages,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskIds = taskIds;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.courierOrgId = courierOrgId;
        this.driverId = driverId;
        this.taskGroupS3ObjectMetadataIds = taskGroupS3ObjectMetadataIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inProgressAtTimestamp = inProgressAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.taskGroupType = taskGroupType;
        this.taskGroupMileage = taskGroupMileage;
        this.messages = messages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    @JsonProperty("task_ids")
    public Optional<List<String>> getTaskIds() {
        return taskIds;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getCourierOrgId() {
        if (courierOrgId == null) {
            return Optional.empty();
        }
        return courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getDriverId() {
        if (driverId == null) {
            return Optional.empty();
        }
        return driverId;
    }

    @JsonProperty("task_group_s3_object_metadata_ids")
    public Optional<List<String>> getTaskGroupS3ObjectMetadataIds() {
        return taskGroupS3ObjectMetadataIds;
    }

    @JsonProperty("status")
    public Optional<TaskGroupStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInProgressAtTimestamp() {
        if (inProgressAtTimestamp == null) {
            return Optional.empty();
        }
        return inProgressAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (completedAtTimestamp == null) {
            return Optional.empty();
        }
        return completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return exceptionAtTimestamp;
    }

    @JsonProperty("order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return orderCancelled;
    }

    @JsonProperty("task_group_type")
    public TaskGroupTypeEnum1 getTaskGroupType() {
        return taskGroupType;
    }

    @JsonIgnore
    public Optional<TaskGroupMileage1> getTaskGroupMileage() {
        if (taskGroupMileage == null) {
            return Optional.empty();
        }
        return taskGroupMileage;
    }

    @JsonProperty("messages")
    public Optional<List<TaskGroupMessage1>> getMessages() {
        return messages;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_org_id")
    private Optional<String> _getCourierOrgId() {
        return courierOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("driver_id")
    private Optional<String> _getDriverId() {
        return driverId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("in_progress_at_timestamp")
    private Optional<OffsetDateTime> _getInProgressAtTimestamp() {
        return inProgressAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return completedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return exceptionAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_group_mileage")
    private Optional<TaskGroupMileage1> _getTaskGroupMileage() {
        return taskGroupMileage;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskGroup1 && equalTo((TaskGroup1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroup1 other) {
        return schemaVersion == other.schemaVersion
                && id.equals(other.id)
                && orderId.equals(other.orderId)
                && orderShortId.equals(other.orderShortId)
                && taskIds.equals(other.taskIds)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && courierOrgId.equals(other.courierOrgId)
                && driverId.equals(other.driverId)
                && taskGroupS3ObjectMetadataIds.equals(other.taskGroupS3ObjectMetadataIds)
                && status.equals(other.status)
                && draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && inProgressAtTimestamp.equals(other.inProgressAtTimestamp)
                && completedAtTimestamp.equals(other.completedAtTimestamp)
                && exceptionAtTimestamp.equals(other.exceptionAtTimestamp)
                && orderCancelled.equals(other.orderCancelled)
                && taskGroupType.equals(other.taskGroupType)
                && taskGroupMileage.equals(other.taskGroupMileage)
                && messages.equals(other.messages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.id,
                this.orderId,
                this.orderShortId,
                this.taskIds,
                this.createdByOrgId,
                this.createdByUserId,
                this.courierOrgId,
                this.driverId,
                this.taskGroupS3ObjectMetadataIds,
                this.status,
                this.draftStartedAtTimestamp,
                this.stagedAtTimestamp,
                this.inProgressAtTimestamp,
                this.completedAtTimestamp,
                this.exceptionAtTimestamp,
                this.orderCancelled,
                this.taskGroupType,
                this.taskGroupMileage,
                this.messages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(TaskGroup1 other);
    }

    public interface IdStage {
        OrderIdStage id(@NotNull String id);
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);
    }

    public interface OrderShortIdStage {
        CreatedByOrgIdStage orderShortId(@NotNull String orderShortId);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface DraftStartedAtTimestampStage {
        TaskGroupTypeStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp);
    }

    public interface TaskGroupTypeStage {
        _FinalStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType);
    }

    public interface _FinalStage {
        TaskGroup1 build();

        _FinalStage taskIds(Optional<List<String>> taskIds);

        _FinalStage taskIds(List<String> taskIds);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage courierOrgId(Optional<String> courierOrgId);

        _FinalStage courierOrgId(String courierOrgId);

        _FinalStage courierOrgId(Nullable<String> courierOrgId);

        _FinalStage driverId(Optional<String> driverId);

        _FinalStage driverId(String driverId);

        _FinalStage driverId(Nullable<String> driverId);

        _FinalStage taskGroupS3ObjectMetadataIds(Optional<List<String>> taskGroupS3ObjectMetadataIds);

        _FinalStage taskGroupS3ObjectMetadataIds(List<String> taskGroupS3ObjectMetadataIds);

        _FinalStage status(Optional<TaskGroupStatusEnum1> status);

        _FinalStage status(TaskGroupStatusEnum1 status);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp);

        _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp);

        _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp);

        _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp);

        _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp);

        _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp);

        _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage orderCancelled(Optional<Boolean> orderCancelled);

        _FinalStage orderCancelled(Boolean orderCancelled);

        _FinalStage taskGroupMileage(Optional<TaskGroupMileage1> taskGroupMileage);

        _FinalStage taskGroupMileage(TaskGroupMileage1 taskGroupMileage);

        _FinalStage taskGroupMileage(Nullable<TaskGroupMileage1> taskGroupMileage);

        _FinalStage messages(Optional<List<TaskGroupMessage1>> messages);

        _FinalStage messages(List<TaskGroupMessage1> messages);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    OrderIdStage,
                    OrderShortIdStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    DraftStartedAtTimestampStage,
                    TaskGroupTypeStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String orderId;

        private String orderShortId;

        private String createdByOrgId;

        private String createdByUserId;

        private OffsetDateTime draftStartedAtTimestamp;

        private TaskGroupTypeEnum1 taskGroupType;

        private Optional<List<TaskGroupMessage1>> messages = Optional.empty();

        private Optional<TaskGroupMileage1> taskGroupMileage = Optional.empty();

        private Optional<Boolean> orderCancelled = Optional.empty();

        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> inProgressAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<TaskGroupStatusEnum1> status = Optional.empty();

        private Optional<List<String>> taskGroupS3ObjectMetadataIds = Optional.empty();

        private Optional<String> driverId = Optional.empty();

        private Optional<String> courierOrgId = Optional.empty();

        private Optional<List<String>> taskIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskGroup1 other) {
            schemaVersion(other.getSchemaVersion());
            id(other.getId());
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            taskIds(other.getTaskIds());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            courierOrgId(other.getCourierOrgId());
            driverId(other.getDriverId());
            taskGroupS3ObjectMetadataIds(other.getTaskGroupS3ObjectMetadataIds());
            status(other.getStatus());
            draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            inProgressAtTimestamp(other.getInProgressAtTimestamp());
            completedAtTimestamp(other.getCompletedAtTimestamp());
            exceptionAtTimestamp(other.getExceptionAtTimestamp());
            orderCancelled(other.getOrderCancelled());
            taskGroupType(other.getTaskGroupType());
            taskGroupMileage(other.getTaskGroupMileage());
            messages(other.getMessages());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public CreatedByOrgIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("draft_started_at_timestamp")
        public TaskGroupTypeStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp =
                    Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_type")
        public _FinalStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType) {
            this.taskGroupType = Objects.requireNonNull(taskGroupType, "taskGroupType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage messages(List<TaskGroupMessage1> messages) {
            this.messages = Optional.ofNullable(messages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "messages", nulls = Nulls.SKIP)
        public _FinalStage messages(Optional<List<TaskGroupMessage1>> messages) {
            this.messages = messages;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupMileage(Nullable<TaskGroupMileage1> taskGroupMileage) {
            if (taskGroupMileage.isNull()) {
                this.taskGroupMileage = null;
            } else if (taskGroupMileage.isEmpty()) {
                this.taskGroupMileage = Optional.empty();
            } else {
                this.taskGroupMileage = Optional.of(taskGroupMileage.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupMileage(TaskGroupMileage1 taskGroupMileage) {
            this.taskGroupMileage = Optional.ofNullable(taskGroupMileage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_mileage", nulls = Nulls.SKIP)
        public _FinalStage taskGroupMileage(Optional<TaskGroupMileage1> taskGroupMileage) {
            this.taskGroupMileage = taskGroupMileage;
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            if (exceptionAtTimestamp.isNull()) {
                this.exceptionAtTimestamp = null;
            } else if (exceptionAtTimestamp.isEmpty()) {
                this.exceptionAtTimestamp = Optional.empty();
            } else {
                this.exceptionAtTimestamp = Optional.of(exceptionAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exception_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            if (completedAtTimestamp.isNull()) {
                this.completedAtTimestamp = null;
            } else if (completedAtTimestamp.isEmpty()) {
                this.completedAtTimestamp = Optional.empty();
            } else {
                this.completedAtTimestamp = Optional.of(completedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "completed_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp) {
            if (inProgressAtTimestamp.isNull()) {
                this.inProgressAtTimestamp = null;
            } else if (inProgressAtTimestamp.isEmpty()) {
                this.inProgressAtTimestamp = Optional.empty();
            } else {
                this.inProgressAtTimestamp = Optional.of(inProgressAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp) {
            this.inProgressAtTimestamp = Optional.ofNullable(inProgressAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "in_progress_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(TaskGroupStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<TaskGroupStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupS3ObjectMetadataIds(List<String> taskGroupS3ObjectMetadataIds) {
            this.taskGroupS3ObjectMetadataIds = Optional.ofNullable(taskGroupS3ObjectMetadataIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_s3_object_metadata_ids", nulls = Nulls.SKIP)
        public _FinalStage taskGroupS3ObjectMetadataIds(Optional<List<String>> taskGroupS3ObjectMetadataIds) {
            this.taskGroupS3ObjectMetadataIds = taskGroupS3ObjectMetadataIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage driverId(Nullable<String> driverId) {
            if (driverId.isNull()) {
                this.driverId = null;
            } else if (driverId.isEmpty()) {
                this.driverId = Optional.empty();
            } else {
                this.driverId = Optional.of(driverId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage driverId(String driverId) {
            this.driverId = Optional.ofNullable(driverId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "driver_id", nulls = Nulls.SKIP)
        public _FinalStage driverId(Optional<String> driverId) {
            this.driverId = driverId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage courierOrgId(Nullable<String> courierOrgId) {
            if (courierOrgId.isNull()) {
                this.courierOrgId = null;
            } else if (courierOrgId.isEmpty()) {
                this.courierOrgId = Optional.empty();
            } else {
                this.courierOrgId = Optional.of(courierOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage courierOrgId(String courierOrgId) {
            this.courierOrgId = Optional.ofNullable(courierOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "courier_org_id", nulls = Nulls.SKIP)
        public _FinalStage courierOrgId(Optional<String> courierOrgId) {
            this.courierOrgId = courierOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskIds(List<String> taskIds) {
            this.taskIds = Optional.ofNullable(taskIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_ids", nulls = Nulls.SKIP)
        public _FinalStage taskIds(Optional<List<String>> taskIds) {
            this.taskIds = taskIds;
            return this;
        }

        @java.lang.Override
        public TaskGroup1 build() {
            return new TaskGroup1(
                    schemaVersion,
                    id,
                    orderId,
                    orderShortId,
                    taskIds,
                    createdByOrgId,
                    createdByUserId,
                    courierOrgId,
                    driverId,
                    taskGroupS3ObjectMetadataIds,
                    status,
                    draftStartedAtTimestamp,
                    stagedAtTimestamp,
                    inProgressAtTimestamp,
                    completedAtTimestamp,
                    exceptionAtTimestamp,
                    orderCancelled,
                    taskGroupType,
                    taskGroupMileage,
                    messages,
                    additionalProperties);
        }
    }
}
