/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskGroupExpandedForCourierAdministrator.Builder.class)
public final class TaskGroupExpandedForCourierAdministrator {
    private final TaskGroup1 taskGroup;

    private final Optional<List<TaskExpanded>> tasksExpanded;

    private final Optional<String> shipperOrgCompanyName;

    private final Optional<String> shipperOrgHandle;

    private final Optional<Double> taskGroupMileage;

    private final Optional<Driver1> driver;

    private final Optional<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup;

    private final Optional<CourierPayDriverRateSheet1> courierPayDriverRateSheet;

    private final Optional<CourierPayDriverStatement1> courierPayDriverPayout;

    private final Map<String, Object> additionalProperties;

    private TaskGroupExpandedForCourierAdministrator(
            TaskGroup1 taskGroup,
            Optional<List<TaskExpanded>> tasksExpanded,
            Optional<String> shipperOrgCompanyName,
            Optional<String> shipperOrgHandle,
            Optional<Double> taskGroupMileage,
            Optional<Driver1> driver,
            Optional<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup,
            Optional<CourierPayDriverRateSheet1> courierPayDriverRateSheet,
            Optional<CourierPayDriverStatement1> courierPayDriverPayout,
            Map<String, Object> additionalProperties) {
        this.taskGroup = taskGroup;
        this.tasksExpanded = tasksExpanded;
        this.shipperOrgCompanyName = shipperOrgCompanyName;
        this.shipperOrgHandle = shipperOrgHandle;
        this.taskGroupMileage = taskGroupMileage;
        this.driver = driver;
        this.courierPayDriverLineItemGroup = courierPayDriverLineItemGroup;
        this.courierPayDriverRateSheet = courierPayDriverRateSheet;
        this.courierPayDriverPayout = courierPayDriverPayout;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group")
    public TaskGroup1 getTaskGroup() {
        return taskGroup;
    }

    @JsonIgnore
    public Optional<List<TaskExpanded>> getTasksExpanded() {
        if (tasksExpanded == null) {
            return Optional.empty();
        }
        return tasksExpanded;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgCompanyName() {
        if (shipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return shipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgHandle() {
        if (shipperOrgHandle == null) {
            return Optional.empty();
        }
        return shipperOrgHandle;
    }

    @JsonIgnore
    public Optional<Double> getTaskGroupMileage() {
        if (taskGroupMileage == null) {
            return Optional.empty();
        }
        return taskGroupMileage;
    }

    @JsonIgnore
    public Optional<Driver1> getDriver() {
        if (driver == null) {
            return Optional.empty();
        }
        return driver;
    }

    @JsonIgnore
    public Optional<CourierPayDriverLineItemGroup1> getCourierPayDriverLineItemGroup() {
        if (courierPayDriverLineItemGroup == null) {
            return Optional.empty();
        }
        return courierPayDriverLineItemGroup;
    }

    @JsonIgnore
    public Optional<CourierPayDriverRateSheet1> getCourierPayDriverRateSheet() {
        if (courierPayDriverRateSheet == null) {
            return Optional.empty();
        }
        return courierPayDriverRateSheet;
    }

    @JsonIgnore
    public Optional<CourierPayDriverStatement1> getCourierPayDriverPayout() {
        if (courierPayDriverPayout == null) {
            return Optional.empty();
        }
        return courierPayDriverPayout;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("tasks_expanded")
    private Optional<List<TaskExpanded>> _getTasksExpanded() {
        return tasksExpanded;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_company_name")
    private Optional<String> _getShipperOrgCompanyName() {
        return shipperOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_handle")
    private Optional<String> _getShipperOrgHandle() {
        return shipperOrgHandle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_group_mileage")
    private Optional<Double> _getTaskGroupMileage() {
        return taskGroupMileage;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("driver")
    private Optional<Driver1> _getDriver() {
        return driver;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_pay_driver_line_item_group")
    private Optional<CourierPayDriverLineItemGroup1> _getCourierPayDriverLineItemGroup() {
        return courierPayDriverLineItemGroup;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_pay_driver_rate_sheet")
    private Optional<CourierPayDriverRateSheet1> _getCourierPayDriverRateSheet() {
        return courierPayDriverRateSheet;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_pay_driver_payout")
    private Optional<CourierPayDriverStatement1> _getCourierPayDriverPayout() {
        return courierPayDriverPayout;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskGroupExpandedForCourierAdministrator
                && equalTo((TaskGroupExpandedForCourierAdministrator) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupExpandedForCourierAdministrator other) {
        return taskGroup.equals(other.taskGroup)
                && tasksExpanded.equals(other.tasksExpanded)
                && shipperOrgCompanyName.equals(other.shipperOrgCompanyName)
                && shipperOrgHandle.equals(other.shipperOrgHandle)
                && taskGroupMileage.equals(other.taskGroupMileage)
                && driver.equals(other.driver)
                && courierPayDriverLineItemGroup.equals(other.courierPayDriverLineItemGroup)
                && courierPayDriverRateSheet.equals(other.courierPayDriverRateSheet)
                && courierPayDriverPayout.equals(other.courierPayDriverPayout);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.taskGroup,
                this.tasksExpanded,
                this.shipperOrgCompanyName,
                this.shipperOrgHandle,
                this.taskGroupMileage,
                this.driver,
                this.courierPayDriverLineItemGroup,
                this.courierPayDriverRateSheet,
                this.courierPayDriverPayout);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupStage builder() {
        return new Builder();
    }

    public interface TaskGroupStage {
        _FinalStage taskGroup(@NotNull TaskGroup1 taskGroup);

        Builder from(TaskGroupExpandedForCourierAdministrator other);
    }

    public interface _FinalStage {
        TaskGroupExpandedForCourierAdministrator build();

        _FinalStage tasksExpanded(Optional<List<TaskExpanded>> tasksExpanded);

        _FinalStage tasksExpanded(List<TaskExpanded> tasksExpanded);

        _FinalStage tasksExpanded(Nullable<List<TaskExpanded>> tasksExpanded);

        _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName);

        _FinalStage shipperOrgHandle(Optional<String> shipperOrgHandle);

        _FinalStage shipperOrgHandle(String shipperOrgHandle);

        _FinalStage shipperOrgHandle(Nullable<String> shipperOrgHandle);

        _FinalStage taskGroupMileage(Optional<Double> taskGroupMileage);

        _FinalStage taskGroupMileage(Double taskGroupMileage);

        _FinalStage taskGroupMileage(Nullable<Double> taskGroupMileage);

        _FinalStage driver(Optional<Driver1> driver);

        _FinalStage driver(Driver1 driver);

        _FinalStage driver(Nullable<Driver1> driver);

        _FinalStage courierPayDriverLineItemGroup(
                Optional<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup);

        _FinalStage courierPayDriverLineItemGroup(CourierPayDriverLineItemGroup1 courierPayDriverLineItemGroup);

        _FinalStage courierPayDriverLineItemGroup(
                Nullable<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup);

        _FinalStage courierPayDriverRateSheet(Optional<CourierPayDriverRateSheet1> courierPayDriverRateSheet);

        _FinalStage courierPayDriverRateSheet(CourierPayDriverRateSheet1 courierPayDriverRateSheet);

        _FinalStage courierPayDriverRateSheet(Nullable<CourierPayDriverRateSheet1> courierPayDriverRateSheet);

        _FinalStage courierPayDriverPayout(Optional<CourierPayDriverStatement1> courierPayDriverPayout);

        _FinalStage courierPayDriverPayout(CourierPayDriverStatement1 courierPayDriverPayout);

        _FinalStage courierPayDriverPayout(Nullable<CourierPayDriverStatement1> courierPayDriverPayout);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupStage, _FinalStage {
        private TaskGroup1 taskGroup;

        private Optional<CourierPayDriverStatement1> courierPayDriverPayout = Optional.empty();

        private Optional<CourierPayDriverRateSheet1> courierPayDriverRateSheet = Optional.empty();

        private Optional<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup = Optional.empty();

        private Optional<Driver1> driver = Optional.empty();

        private Optional<Double> taskGroupMileage = Optional.empty();

        private Optional<String> shipperOrgHandle = Optional.empty();

        private Optional<String> shipperOrgCompanyName = Optional.empty();

        private Optional<List<TaskExpanded>> tasksExpanded = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskGroupExpandedForCourierAdministrator other) {
            taskGroup(other.getTaskGroup());
            tasksExpanded(other.getTasksExpanded());
            shipperOrgCompanyName(other.getShipperOrgCompanyName());
            shipperOrgHandle(other.getShipperOrgHandle());
            taskGroupMileage(other.getTaskGroupMileage());
            driver(other.getDriver());
            courierPayDriverLineItemGroup(other.getCourierPayDriverLineItemGroup());
            courierPayDriverRateSheet(other.getCourierPayDriverRateSheet());
            courierPayDriverPayout(other.getCourierPayDriverPayout());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group")
        public _FinalStage taskGroup(@NotNull TaskGroup1 taskGroup) {
            this.taskGroup = Objects.requireNonNull(taskGroup, "taskGroup must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverPayout(Nullable<CourierPayDriverStatement1> courierPayDriverPayout) {
            if (courierPayDriverPayout.isNull()) {
                this.courierPayDriverPayout = null;
            } else if (courierPayDriverPayout.isEmpty()) {
                this.courierPayDriverPayout = Optional.empty();
            } else {
                this.courierPayDriverPayout = Optional.of(courierPayDriverPayout.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverPayout(CourierPayDriverStatement1 courierPayDriverPayout) {
            this.courierPayDriverPayout = Optional.ofNullable(courierPayDriverPayout);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_payout", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverPayout(Optional<CourierPayDriverStatement1> courierPayDriverPayout) {
            this.courierPayDriverPayout = courierPayDriverPayout;
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverRateSheet(Nullable<CourierPayDriverRateSheet1> courierPayDriverRateSheet) {
            if (courierPayDriverRateSheet.isNull()) {
                this.courierPayDriverRateSheet = null;
            } else if (courierPayDriverRateSheet.isEmpty()) {
                this.courierPayDriverRateSheet = Optional.empty();
            } else {
                this.courierPayDriverRateSheet = Optional.of(courierPayDriverRateSheet.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverRateSheet(CourierPayDriverRateSheet1 courierPayDriverRateSheet) {
            this.courierPayDriverRateSheet = Optional.ofNullable(courierPayDriverRateSheet);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_rate_sheet", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverRateSheet(Optional<CourierPayDriverRateSheet1> courierPayDriverRateSheet) {
            this.courierPayDriverRateSheet = courierPayDriverRateSheet;
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverLineItemGroup(
                Nullable<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup) {
            if (courierPayDriverLineItemGroup.isNull()) {
                this.courierPayDriverLineItemGroup = null;
            } else if (courierPayDriverLineItemGroup.isEmpty()) {
                this.courierPayDriverLineItemGroup = Optional.empty();
            } else {
                this.courierPayDriverLineItemGroup = Optional.of(courierPayDriverLineItemGroup.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverLineItemGroup(CourierPayDriverLineItemGroup1 courierPayDriverLineItemGroup) {
            this.courierPayDriverLineItemGroup = Optional.ofNullable(courierPayDriverLineItemGroup);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_line_item_group", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverLineItemGroup(
                Optional<CourierPayDriverLineItemGroup1> courierPayDriverLineItemGroup) {
            this.courierPayDriverLineItemGroup = courierPayDriverLineItemGroup;
            return this;
        }

        @java.lang.Override
        public _FinalStage driver(Nullable<Driver1> driver) {
            if (driver.isNull()) {
                this.driver = null;
            } else if (driver.isEmpty()) {
                this.driver = Optional.empty();
            } else {
                this.driver = Optional.of(driver.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage driver(Driver1 driver) {
            this.driver = Optional.ofNullable(driver);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "driver", nulls = Nulls.SKIP)
        public _FinalStage driver(Optional<Driver1> driver) {
            this.driver = driver;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupMileage(Nullable<Double> taskGroupMileage) {
            if (taskGroupMileage.isNull()) {
                this.taskGroupMileage = null;
            } else if (taskGroupMileage.isEmpty()) {
                this.taskGroupMileage = Optional.empty();
            } else {
                this.taskGroupMileage = Optional.of(taskGroupMileage.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupMileage(Double taskGroupMileage) {
            this.taskGroupMileage = Optional.ofNullable(taskGroupMileage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_mileage", nulls = Nulls.SKIP)
        public _FinalStage taskGroupMileage(Optional<Double> taskGroupMileage) {
            this.taskGroupMileage = taskGroupMileage;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgHandle(Nullable<String> shipperOrgHandle) {
            if (shipperOrgHandle.isNull()) {
                this.shipperOrgHandle = null;
            } else if (shipperOrgHandle.isEmpty()) {
                this.shipperOrgHandle = Optional.empty();
            } else {
                this.shipperOrgHandle = Optional.of(shipperOrgHandle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgHandle(String shipperOrgHandle) {
            this.shipperOrgHandle = Optional.ofNullable(shipperOrgHandle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_handle", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgHandle(Optional<String> shipperOrgHandle) {
            this.shipperOrgHandle = shipperOrgHandle;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName) {
            if (shipperOrgCompanyName.isNull()) {
                this.shipperOrgCompanyName = null;
            } else if (shipperOrgCompanyName.isEmpty()) {
                this.shipperOrgCompanyName = Optional.empty();
            } else {
                this.shipperOrgCompanyName = Optional.of(shipperOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName) {
            this.shipperOrgCompanyName = Optional.ofNullable(shipperOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName) {
            this.shipperOrgCompanyName = shipperOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage tasksExpanded(Nullable<List<TaskExpanded>> tasksExpanded) {
            if (tasksExpanded.isNull()) {
                this.tasksExpanded = null;
            } else if (tasksExpanded.isEmpty()) {
                this.tasksExpanded = Optional.empty();
            } else {
                this.tasksExpanded = Optional.of(tasksExpanded.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage tasksExpanded(List<TaskExpanded> tasksExpanded) {
            this.tasksExpanded = Optional.ofNullable(tasksExpanded);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tasks_expanded", nulls = Nulls.SKIP)
        public _FinalStage tasksExpanded(Optional<List<TaskExpanded>> tasksExpanded) {
            this.tasksExpanded = tasksExpanded;
            return this;
        }

        @java.lang.Override
        public TaskGroupExpandedForCourierAdministrator build() {
            return new TaskGroupExpandedForCourierAdministrator(
                    taskGroup,
                    tasksExpanded,
                    shipperOrgCompanyName,
                    shipperOrgHandle,
                    taskGroupMileage,
                    driver,
                    courierPayDriverLineItemGroup,
                    courierPayDriverRateSheet,
                    courierPayDriverPayout,
                    additionalProperties);
        }
    }
}
