/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskGroupMessage1.Builder.class)
public final class TaskGroupMessage1 {
    private final String message;

    private final String userId;

    private final String orgId;

    private final OffsetDateTime timestamp;

    private final Map<String, Object> additionalProperties;

    private TaskGroupMessage1(
            String message,
            String userId,
            String orgId,
            OffsetDateTime timestamp,
            Map<String, Object> additionalProperties) {
        this.message = message;
        this.userId = userId;
        this.orgId = orgId;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    @JsonProperty("timestamp")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskGroupMessage1 && equalTo((TaskGroupMessage1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupMessage1 other) {
        return message.equals(other.message)
                && userId.equals(other.userId)
                && orgId.equals(other.orgId)
                && timestamp.equals(other.timestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.message, this.userId, this.orgId, this.timestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    public interface MessageStage {
        UserIdStage message(@NotNull String message);

        Builder from(TaskGroupMessage1 other);
    }

    public interface UserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        OrgIdStage userId(@NotNull String userId);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        TimestampStage orgId(@NotNull String orgId);
    }

    public interface TimestampStage {
        _FinalStage timestamp(@NotNull OffsetDateTime timestamp);
    }

    public interface _FinalStage {
        TaskGroupMessage1 build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements MessageStage, UserIdStage, OrgIdStage, TimestampStage, _FinalStage {
        private String message;

        private String userId;

        private String orgId;

        private OffsetDateTime timestamp;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskGroupMessage1 other) {
            message(other.getMessage());
            userId(other.getUserId());
            orgId(other.getOrgId());
            timestamp(other.getTimestamp());
            return this;
        }

        @java.lang.Override
        @JsonSetter("message")
        public UserIdStage message(@NotNull String message) {
            this.message = Objects.requireNonNull(message, "message must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public OrgIdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public TimestampStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @java.lang.Override
        public TaskGroupMessage1 build() {
            return new TaskGroupMessage1(message, userId, orgId, timestamp, additionalProperties);
        }
    }
}
