/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TemplateRes.Builder.class)
public final class TemplateRes {
    private final String message;

    private final int number;

    private final OffsetDateTime timestamp;

    private final Map<String, Object> additionalProperties;

    private TemplateRes(
            String message, int number, OffsetDateTime timestamp, Map<String, Object> additionalProperties) {
        this.message = message;
        this.number = number;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    @JsonProperty("number")
    public int getNumber() {
        return number;
    }

    @JsonProperty("timestamp")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TemplateRes && equalTo((TemplateRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TemplateRes other) {
        return message.equals(other.message) && number == other.number && timestamp.equals(other.timestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.message, this.number, this.timestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    public interface MessageStage {
        NumberStage message(@NotNull String message);

        Builder from(TemplateRes other);
    }

    public interface NumberStage {
        TimestampStage number(int number);
    }

    public interface TimestampStage {
        _FinalStage timestamp(@NotNull OffsetDateTime timestamp);
    }

    public interface _FinalStage {
        TemplateRes build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements MessageStage, NumberStage, TimestampStage, _FinalStage {
        private String message;

        private int number;

        private OffsetDateTime timestamp;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TemplateRes other) {
            message(other.getMessage());
            number(other.getNumber());
            timestamp(other.getTimestamp());
            return this;
        }

        @java.lang.Override
        @JsonSetter("message")
        public NumberStage message(@NotNull String message) {
            this.message = Objects.requireNonNull(message, "message must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("number")
        public TimestampStage number(int number) {
            this.number = number;
            return this;
        }

        @java.lang.Override
        @JsonSetter("timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @java.lang.Override
        public TemplateRes build() {
            return new TemplateRes(message, number, timestamp, additionalProperties);
        }
    }
}
