/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TrackingCargoByDeviceDataPoint1.Builder.class)
public final class TrackingCargoByDeviceDataPoint1 {
    private final int schemaVersion;

    private final OffsetDateTime timestamp;

    private final TrackingCargoByDeviceDataPointMetadata1 metadata;

    private final LocationFeature location;

    private final Optional<Double> temperature;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private TrackingCargoByDeviceDataPoint1(
            int schemaVersion,
            OffsetDateTime timestamp,
            TrackingCargoByDeviceDataPointMetadata1 metadata,
            LocationFeature location,
            Optional<Double> temperature,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.location = location;
        this.temperature = temperature;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("timestamp")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    @JsonProperty("metadata")
    public TrackingCargoByDeviceDataPointMetadata1 getMetadata() {
        return metadata;
    }

    @JsonProperty("location")
    public LocationFeature getLocation() {
        return location;
    }

    @JsonIgnore
    public Optional<Double> getTemperature() {
        if (temperature == null) {
            return Optional.empty();
        }
        return temperature;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("temperature")
    private Optional<Double> _getTemperature() {
        return temperature;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TrackingCargoByDeviceDataPoint1 && equalTo((TrackingCargoByDeviceDataPoint1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TrackingCargoByDeviceDataPoint1 other) {
        return schemaVersion == other.schemaVersion
                && timestamp.equals(other.timestamp)
                && metadata.equals(other.metadata)
                && location.equals(other.location)
                && temperature.equals(other.temperature)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion, this.timestamp, this.metadata, this.location, this.temperature, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        TimestampStage schemaVersion(int schemaVersion);

        Builder from(TrackingCargoByDeviceDataPoint1 other);
    }

    public interface TimestampStage {
        MetadataStage timestamp(@NotNull OffsetDateTime timestamp);
    }

    public interface MetadataStage {
        LocationStage metadata(@NotNull TrackingCargoByDeviceDataPointMetadata1 metadata);
    }

    public interface LocationStage {
        IdStage location(@NotNull LocationFeature location);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        TrackingCargoByDeviceDataPoint1 build();

        _FinalStage temperature(Optional<Double> temperature);

        _FinalStage temperature(Double temperature);

        _FinalStage temperature(Nullable<Double> temperature);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, TimestampStage, MetadataStage, LocationStage, IdStage, _FinalStage {
        private int schemaVersion;

        private OffsetDateTime timestamp;

        private TrackingCargoByDeviceDataPointMetadata1 metadata;

        private LocationFeature location;

        private String id;

        private Optional<Double> temperature = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TrackingCargoByDeviceDataPoint1 other) {
            schemaVersion(other.getSchemaVersion());
            timestamp(other.getTimestamp());
            metadata(other.getMetadata());
            location(other.getLocation());
            temperature(other.getTemperature());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public TimestampStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("timestamp")
        public MetadataStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("metadata")
        public LocationStage metadata(@NotNull TrackingCargoByDeviceDataPointMetadata1 metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("location")
        public IdStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage temperature(Nullable<Double> temperature) {
            if (temperature.isNull()) {
                this.temperature = null;
            } else if (temperature.isEmpty()) {
                this.temperature = Optional.empty();
            } else {
                this.temperature = Optional.of(temperature.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.ofNullable(temperature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "temperature", nulls = Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @java.lang.Override
        public TrackingCargoByDeviceDataPoint1 build() {
            return new TrackingCargoByDeviceDataPoint1(
                    schemaVersion, timestamp, metadata, location, temperature, id, additionalProperties);
        }
    }
}
