/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TrackingCargoByDeviceDataPointMetadata1.Builder.class)
public final class TrackingCargoByDeviceDataPointMetadata1 {
    private final String deviceId;

    private final String cargoId;

    private final String taskGroupId;

    private final Optional<Boolean> outlier;

    private final Optional<OutlierLabellerEnum> outlierLabeller;

    private final Optional<Boolean> pytest;

    private final Map<String, Object> additionalProperties;

    private TrackingCargoByDeviceDataPointMetadata1(
            String deviceId,
            String cargoId,
            String taskGroupId,
            Optional<Boolean> outlier,
            Optional<OutlierLabellerEnum> outlierLabeller,
            Optional<Boolean> pytest,
            Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.cargoId = cargoId;
        this.taskGroupId = taskGroupId;
        this.outlier = outlier;
        this.outlierLabeller = outlierLabeller;
        this.pytest = pytest;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("device_id")
    public String getDeviceId() {
        return deviceId;
    }

    @JsonProperty("cargo_id")
    public String getCargoId() {
        return cargoId;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonIgnore
    public Optional<Boolean> getOutlier() {
        if (outlier == null) {
            return Optional.empty();
        }
        return outlier;
    }

    @JsonIgnore
    public Optional<OutlierLabellerEnum> getOutlierLabeller() {
        if (outlierLabeller == null) {
            return Optional.empty();
        }
        return outlierLabeller;
    }

    @JsonIgnore
    public Optional<Boolean> getPytest() {
        if (pytest == null) {
            return Optional.empty();
        }
        return pytest;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("outlier")
    private Optional<Boolean> _getOutlier() {
        return outlier;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("outlier_labeller")
    private Optional<OutlierLabellerEnum> _getOutlierLabeller() {
        return outlierLabeller;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("pytest")
    private Optional<Boolean> _getPytest() {
        return pytest;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TrackingCargoByDeviceDataPointMetadata1
                && equalTo((TrackingCargoByDeviceDataPointMetadata1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TrackingCargoByDeviceDataPointMetadata1 other) {
        return deviceId.equals(other.deviceId)
                && cargoId.equals(other.cargoId)
                && taskGroupId.equals(other.taskGroupId)
                && outlier.equals(other.outlier)
                && outlierLabeller.equals(other.outlierLabeller)
                && pytest.equals(other.pytest);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.deviceId, this.cargoId, this.taskGroupId, this.outlier, this.outlierLabeller, this.pytest);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    public interface DeviceIdStage {
        CargoIdStage deviceId(@NotNull String deviceId);

        Builder from(TrackingCargoByDeviceDataPointMetadata1 other);
    }

    public interface CargoIdStage {
        TaskGroupIdStage cargoId(@NotNull String cargoId);
    }

    public interface TaskGroupIdStage {
        _FinalStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface _FinalStage {
        TrackingCargoByDeviceDataPointMetadata1 build();

        _FinalStage outlier(Optional<Boolean> outlier);

        _FinalStage outlier(Boolean outlier);

        _FinalStage outlier(Nullable<Boolean> outlier);

        _FinalStage outlierLabeller(Optional<OutlierLabellerEnum> outlierLabeller);

        _FinalStage outlierLabeller(OutlierLabellerEnum outlierLabeller);

        _FinalStage outlierLabeller(Nullable<OutlierLabellerEnum> outlierLabeller);

        _FinalStage pytest(Optional<Boolean> pytest);

        _FinalStage pytest(Boolean pytest);

        _FinalStage pytest(Nullable<Boolean> pytest);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DeviceIdStage, CargoIdStage, TaskGroupIdStage, _FinalStage {
        private String deviceId;

        private String cargoId;

        private String taskGroupId;

        private Optional<Boolean> pytest = Optional.empty();

        private Optional<OutlierLabellerEnum> outlierLabeller = Optional.empty();

        private Optional<Boolean> outlier = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TrackingCargoByDeviceDataPointMetadata1 other) {
            deviceId(other.getDeviceId());
            cargoId(other.getCargoId());
            taskGroupId(other.getTaskGroupId());
            outlier(other.getOutlier());
            outlierLabeller(other.getOutlierLabeller());
            pytest(other.getPytest());
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_id")
        public CargoIdStage deviceId(@NotNull String deviceId) {
            this.deviceId = Objects.requireNonNull(deviceId, "deviceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_id")
        public TaskGroupIdStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage pytest(Nullable<Boolean> pytest) {
            if (pytest.isNull()) {
                this.pytest = null;
            } else if (pytest.isEmpty()) {
                this.pytest = Optional.empty();
            } else {
                this.pytest = Optional.of(pytest.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pytest(Boolean pytest) {
            this.pytest = Optional.ofNullable(pytest);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pytest", nulls = Nulls.SKIP)
        public _FinalStage pytest(Optional<Boolean> pytest) {
            this.pytest = pytest;
            return this;
        }

        @java.lang.Override
        public _FinalStage outlierLabeller(Nullable<OutlierLabellerEnum> outlierLabeller) {
            if (outlierLabeller.isNull()) {
                this.outlierLabeller = null;
            } else if (outlierLabeller.isEmpty()) {
                this.outlierLabeller = Optional.empty();
            } else {
                this.outlierLabeller = Optional.of(outlierLabeller.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage outlierLabeller(OutlierLabellerEnum outlierLabeller) {
            this.outlierLabeller = Optional.ofNullable(outlierLabeller);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "outlier_labeller", nulls = Nulls.SKIP)
        public _FinalStage outlierLabeller(Optional<OutlierLabellerEnum> outlierLabeller) {
            this.outlierLabeller = outlierLabeller;
            return this;
        }

        @java.lang.Override
        public _FinalStage outlier(Nullable<Boolean> outlier) {
            if (outlier.isNull()) {
                this.outlier = null;
            } else if (outlier.isEmpty()) {
                this.outlier = Optional.empty();
            } else {
                this.outlier = Optional.of(outlier.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage outlier(Boolean outlier) {
            this.outlier = Optional.ofNullable(outlier);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "outlier", nulls = Nulls.SKIP)
        public _FinalStage outlier(Optional<Boolean> outlier) {
            this.outlier = outlier;
            return this;
        }

        @java.lang.Override
        public TrackingCargoByDeviceDataPointMetadata1 build() {
            return new TrackingCargoByDeviceDataPointMetadata1(
                    deviceId, cargoId, taskGroupId, outlier, outlierLabeller, pytest, additionalProperties);
        }
    }
}
