/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TrackingCargoByDriverDataPoint1.Builder.class)
public final class TrackingCargoByDriverDataPoint1 {
    private final int schemaVersion;

    private final OffsetDateTime timestamp;

    private final TrackingCargoByDriverDataPointMetadata1 metadata;

    private final LocationFeature location;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private TrackingCargoByDriverDataPoint1(
            int schemaVersion,
            OffsetDateTime timestamp,
            TrackingCargoByDriverDataPointMetadata1 metadata,
            LocationFeature location,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.location = location;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("timestamp")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    @JsonProperty("metadata")
    public TrackingCargoByDriverDataPointMetadata1 getMetadata() {
        return metadata;
    }

    @JsonProperty("location")
    public LocationFeature getLocation() {
        return location;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TrackingCargoByDriverDataPoint1 && equalTo((TrackingCargoByDriverDataPoint1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TrackingCargoByDriverDataPoint1 other) {
        return schemaVersion == other.schemaVersion
                && timestamp.equals(other.timestamp)
                && metadata.equals(other.metadata)
                && location.equals(other.location)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.timestamp, this.metadata, this.location, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        TimestampStage schemaVersion(int schemaVersion);

        Builder from(TrackingCargoByDriverDataPoint1 other);
    }

    public interface TimestampStage {
        MetadataStage timestamp(@NotNull OffsetDateTime timestamp);
    }

    public interface MetadataStage {
        LocationStage metadata(@NotNull TrackingCargoByDriverDataPointMetadata1 metadata);
    }

    public interface LocationStage {
        IdStage location(@NotNull LocationFeature location);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        TrackingCargoByDriverDataPoint1 build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, TimestampStage, MetadataStage, LocationStage, IdStage, _FinalStage {
        private int schemaVersion;

        private OffsetDateTime timestamp;

        private TrackingCargoByDriverDataPointMetadata1 metadata;

        private LocationFeature location;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TrackingCargoByDriverDataPoint1 other) {
            schemaVersion(other.getSchemaVersion());
            timestamp(other.getTimestamp());
            metadata(other.getMetadata());
            location(other.getLocation());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public TimestampStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("timestamp")
        public MetadataStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("metadata")
        public LocationStage metadata(@NotNull TrackingCargoByDriverDataPointMetadata1 metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("location")
        public IdStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public TrackingCargoByDriverDataPoint1 build() {
            return new TrackingCargoByDriverDataPoint1(
                    schemaVersion, timestamp, metadata, location, id, additionalProperties);
        }
    }
}
