/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UserPublicData1.Builder.class)
public final class UserPublicData1 {
    private final int schemaVersion;

    private final Optional<String> primaryEmailAddress;

    private final String userId;

    private final Optional<String> customerId;

    private final Optional<Map<String, Object>> notes;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private UserPublicData1(
            int schemaVersion,
            Optional<String> primaryEmailAddress,
            String userId,
            Optional<String> customerId,
            Optional<Map<String, Object>> notes,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.primaryEmailAddress = primaryEmailAddress;
        this.userId = userId;
        this.customerId = customerId;
        this.notes = notes;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getPrimaryEmailAddress() {
        if (primaryEmailAddress == null) {
            return Optional.empty();
        }
        return primaryEmailAddress;
    }

    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (customerId == null) {
            return Optional.empty();
        }
        return customerId;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getNotes() {
        if (notes == null) {
            return Optional.empty();
        }
        return notes;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("primary_email_address")
    private Optional<String> _getPrimaryEmailAddress() {
        return primaryEmailAddress;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("customer_id")
    private Optional<String> _getCustomerId() {
        return customerId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("notes")
    private Optional<Map<String, Object>> _getNotes() {
        return notes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UserPublicData1 && equalTo((UserPublicData1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserPublicData1 other) {
        return schemaVersion == other.schemaVersion
                && primaryEmailAddress.equals(other.primaryEmailAddress)
                && userId.equals(other.userId)
                && customerId.equals(other.customerId)
                && notes.equals(other.notes)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion, this.primaryEmailAddress, this.userId, this.customerId, this.notes, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        UserIdStage schemaVersion(int schemaVersion);

        Builder from(UserPublicData1 other);
    }

    public interface UserIdStage {
        IdStage userId(@NotNull String userId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        UserPublicData1 build();

        _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress);

        _FinalStage primaryEmailAddress(String primaryEmailAddress);

        _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress);

        _FinalStage customerId(Optional<String> customerId);

        _FinalStage customerId(String customerId);

        _FinalStage customerId(Nullable<String> customerId);

        _FinalStage notes(Optional<Map<String, Object>> notes);

        _FinalStage notes(Map<String, Object> notes);

        _FinalStage notes(Nullable<Map<String, Object>> notes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, UserIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String userId;

        private String id;

        private Optional<Map<String, Object>> notes = Optional.empty();

        private Optional<String> customerId = Optional.empty();

        private Optional<String> primaryEmailAddress = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UserPublicData1 other) {
            schemaVersion(other.getSchemaVersion());
            primaryEmailAddress(other.getPrimaryEmailAddress());
            userId(other.getUserId());
            customerId(other.getCustomerId());
            notes(other.getNotes());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public UserIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("user_id")
        public IdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(Nullable<Map<String, Object>> notes) {
            if (notes.isNull()) {
                this.notes = null;
            } else if (notes.isEmpty()) {
                this.notes = Optional.empty();
            } else {
                this.notes = Optional.of(notes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(Map<String, Object> notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public _FinalStage notes(Optional<Map<String, Object>> notes) {
            this.notes = notes;
            return this;
        }

        @java.lang.Override
        public _FinalStage customerId(Nullable<String> customerId) {
            if (customerId.isNull()) {
                this.customerId = null;
            } else if (customerId.isEmpty()) {
                this.customerId = Optional.empty();
            } else {
                this.customerId = Optional.of(customerId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "customer_id", nulls = Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @java.lang.Override
        public _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress) {
            if (primaryEmailAddress.isNull()) {
                this.primaryEmailAddress = null;
            } else if (primaryEmailAddress.isEmpty()) {
                this.primaryEmailAddress = Optional.empty();
            } else {
                this.primaryEmailAddress = Optional.of(primaryEmailAddress.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage primaryEmailAddress(String primaryEmailAddress) {
            this.primaryEmailAddress = Optional.ofNullable(primaryEmailAddress);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "primary_email_address", nulls = Nulls.SKIP)
        public _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress;
            return this;
        }

        @java.lang.Override
        public UserPublicData1 build() {
            return new UserPublicData1(
                    schemaVersion, primaryEmailAddress, userId, customerId, notes, id, additionalProperties);
        }
    }
}
