/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.core;

import com.citrsw.annatation.ApiClass;
import com.citrsw.annatation.ApiIgnore;
import com.citrsw.core.ApiContext;
import com.citrsw.core.MethodHandle;
import com.citrsw.definition.DocClass;
import com.citrsw.definition.DocMethod;
import java.io.File;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Component
public class ControllerHandle {
    private static final Logger log = LoggerFactory.getLogger(ControllerHandle.class);
    private final MethodHandle handleMethod;

    public ControllerHandle(MethodHandle handleMethod) {
        this.handleMethod = handleMethod;
    }

    public List<String> takePackages(Class<?> mainApplicationClass) {
        ArrayList<String> packageNames = new ArrayList<String>();
        SpringBootApplication applicationClassAnnotation = mainApplicationClass.getAnnotation(SpringBootApplication.class);
        String name = mainApplicationClass.getPackage().getName();
        packageNames.add(name);
        log.info("\u5df2\u83b7\u53d6\u542f\u52a8\u7c7b\u6240\u5728\u7684\u5305:{}", (Object)name);
        Object[] packages = applicationClassAnnotation.scanBasePackages();
        if (packages.length > 0) {
            log.info("\u5df2\u83b7\u53d6applicationClassAnnotation\u914d\u7f6e\u4e2d\u9700\u8981\u626b\u63cf\u7684\u5305:{}", (Object)Arrays.toString(packages));
            for (Object packageName : packages) {
                if (((String)packageName).length() > name.length() && ((String)packageName).startsWith(name) || name.startsWith((String)packageName)) continue;
                packageNames.add((String)packageName);
            }
        }
        log.info("\u5df2\u83b7\u53d6\u5230\u9700\u8981\u626b\u63cf\u7684\u5305\uff1a{}", packageNames);
        return packageNames;
    }

    public void scanner(String packageName, Set<Class<?>> classes) {
        block9: {
            String protocol;
            String packageDirName;
            URL url;
            block8: {
                String s = packageName.replace(".", "/");
                url = ApiContext.class.getClassLoader().getResource(s);
                if (url == null) {
                    return;
                }
                packageDirName = packageName.replace('.', '/');
                protocol = url.getProtocol();
                if (!"file".equals(protocol)) break block8;
                File[] files = new File(url.getFile()).listFiles();
                assert (files != null);
                for (File classFile : files) {
                    Class<?> clazz;
                    if (classFile.isDirectory()) {
                        this.scanner(packageName + "." + classFile.getName(), classes);
                        continue;
                    }
                    String path = classFile.getPath();
                    if (!path.endsWith(".class") || !Objects.nonNull(clazz = this.getClazz(packageName + "." + classFile.getName().replace(".class", ""))) || !clazz.isAnnotationPresent(RestController.class) || clazz.isAnnotationPresent(ApiIgnore.class)) continue;
                    classes.add(clazz);
                }
                break block9;
            }
            if (!"jar".equals(protocol)) break block9;
            try {
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    Class<?> clazz;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.charAt(0) == '/') {
                        name = name.substring(1);
                    }
                    if (!name.startsWith(packageDirName) || !name.endsWith(".class") || entry.isDirectory() || !Objects.nonNull(clazz = this.getClazz(name.replace("/", ".").replace("\\", ".").replace(".class", ""))) || !clazz.isAnnotationPresent(RestController.class) || clazz.isAnnotationPresent(ApiIgnore.class)) continue;
                    classes.add(clazz);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u626b\u63cf\u5305[{}]\u51fa\u73b0\u5f02\u5e38", (Object)packageName);
            }
        }
    }

    private Class<?> getClazz(String beanClassName) {
        try {
            return Class.forName(beanClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<DocClass> handleClass(Set<Class<?>> classes) {
        TreeSet<DocClass> docClasses = new TreeSet<DocClass>();
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(ApiIgnore.class) != null) continue;
            DocClass docClass = new DocClass();
            ApiClass aClassAnnotation = aClass.getAnnotation(ApiClass.class);
            if (aClassAnnotation != null && StringUtils.isNotBlank((CharSequence)aClassAnnotation.value())) {
                docClass.setDescription(aClassAnnotation.value());
            } else {
                docClass.setDescription(aClass.getSimpleName());
            }
            RequestMapping requestMapping = aClass.getAnnotation(RequestMapping.class);
            Method[] methods = aClass.getDeclaredMethods();
            Set<DocMethod> docMethods = this.handleMethod.handleMethod(methods, requestMapping);
            docClass.setDocMethods(docMethods);
            docClasses.add(docClass);
        }
        return docClasses;
    }
}

