/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.core;

import com.citrsw.annatation.ApiIgnore;
import com.citrsw.annatation.ApiMapProperty;
import com.citrsw.annatation.ApiModel;
import com.citrsw.annatation.ApiParam;
import com.citrsw.annatation.ApiParamModelProperty;
import com.citrsw.annatation.ApiProperty;
import com.citrsw.annatation.ApiReturn;
import com.citrsw.annatation.ApiReturnModelProperty;
import com.citrsw.common.ApiConstant;
import com.citrsw.common.ApiUtils;
import com.citrsw.common.ParameterizedTypeImpl;
import com.citrsw.definition.DocModel;
import com.citrsw.definition.DocProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ModelHandle {
    private static final Logger log = LoggerFactory.getLogger(ModelHandle.class);
    @Value(value="${spring.mvc.date-format:}")
    private String dateFormat;
    @Value(value="${spring.jackson.date-format:}")
    private String jsonFormat;
    private final Pattern pattern = Pattern.compile("[A-Z]");

    /*
     * WARNING - void declaration
     */
    public DocProperty handleModel(Validated validated, DocProperty docProperty, Class<?> aClass, Type type, Map<String, Boolean> propertyMap, boolean isParam, boolean isJson, Set<Class<?>> repeats, Map<String, ApiParamModelProperty> apiModelPropertyMap, Map<String, ApiReturnModelProperty> apiReturnModelPropertyMap, Map<String, ApiMapProperty> apiMapPropertyMap, Map<String, ApiParam> apiMapParamMap, Map<String, ApiReturn> apiMapReturnMap, Map<String, ApiProperty> paramGlobalApiPropertyMap, Map<String, ApiProperty> returnGlobalApiPropertyMap) {
        Method[] methods;
        String value;
        if (repeats.contains(aClass)) {
            return docProperty;
        }
        if (Map.class.isAssignableFrom(aClass)) {
            return this.handleMap(validated, docProperty, type, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
        }
        if (Collection.class.isAssignableFrom(aClass)) {
            docProperty.setType(docProperty.getType() + "[0]");
            return this.handleGeneric(validated, docProperty, type, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
        }
        if (aClass.isArray()) {
            docProperty.setType(docProperty.getType() + "[0]");
            return this.handleGeneric(validated, docProperty, aClass.getComponentType(), propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
        }
        if (aClass.isEnum()) {
            ?[] enums = aClass.getEnumConstants();
            Field[] fields = aClass.getDeclaredFields();
            StringBuilder fieldBuilder = new StringBuilder();
            StringBuilder nameBuilder = new StringBuilder();
            block6: for (Object object : enums) {
                nameBuilder.append(object.toString());
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(JsonValue.class)) continue;
                    field.setAccessible(true);
                    try {
                        fieldBuilder.append(field.get(object)).append(",");
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    continue block6;
                }
            }
            if (fieldBuilder.length() == 0) {
                fieldBuilder = nameBuilder;
            }
            fieldBuilder.insert(0, "\u53d6\u503c\u8303\u56f4:[");
            fieldBuilder.deleteCharAt(fieldBuilder.length() - 1);
            fieldBuilder.append("]");
            String typeString = docProperty.getType();
            docProperty.setFormat(fieldBuilder.toString());
            docProperty.setType("enum" + typeString);
            docProperty.setClassName(aClass.getSimpleName());
            return docProperty;
        }
        if (Integer.TYPE.isAssignableFrom(aClass) || Long.TYPE.isAssignableFrom(aClass) || Double.TYPE.isAssignableFrom(aClass) || Float.TYPE.isAssignableFrom(aClass) || Short.TYPE.isAssignableFrom(aClass) || Boolean.TYPE.isAssignableFrom(aClass) || aClass.getPackage().getName().startsWith("java.lang") || Date.class.isAssignableFrom(aClass) || LocalDateTime.class.isAssignableFrom(aClass) || BigDecimal.class.isAssignableFrom(aClass) || LocalDate.class.isAssignableFrom(aClass) || MultipartFile.class.isAssignableFrom(aClass) || LocalTime.class.isAssignableFrom(aClass)) {
            String typeString = docProperty.getType();
            docProperty.setType(ApiConstant.baseTypeMap.get(aClass) + typeString);
            docProperty.setClassName(aClass.getSimpleName());
            return docProperty;
        }
        DocModel docModel = new DocModel();
        ApiModel apiModel = aClass.getAnnotation(ApiModel.class);
        if (StringUtils.isBlank((CharSequence)docProperty.getDescription()) && apiModel != null && StringUtils.isNotBlank((CharSequence)(value = apiModel.value()))) {
            docProperty.setDescription(value);
        }
        if (apiModel != null && StringUtils.isNotBlank((CharSequence)apiModel.value())) {
            docModel.setDescription(apiModel.value());
        }
        docModel.setClassName(aClass.getSimpleName());
        docProperty.setClassName(aClass.getSimpleName());
        TreeSet<DocProperty> apiProperties = new TreeSet<DocProperty>();
        for (Method method : methods = aClass.getMethods()) {
            void var31_59;
            Annotation modelProperty;
            Boolean validatedRequited;
            JsonProperty jsonProperty;
            JsonFormat jsonFormat;
            DateTimeFormat dateTimeFormat;
            ApiProperty apiProperty;
            ApiMapProperty[] apiMapProperties;
            HashMap<String, ApiParam> childApiMapParamMap;
            HashMap<String, ApiProperty> childReturnGlobalApiPropertyMap;
            HashMap<String, ApiProperty> childParamGlobalApiPropertyMap;
            HashMap<String, Boolean> childPropertyMap;
            DocProperty property;
            String methodName;
            ApiIgnore apiIgnore;
            block173: {
                String example;
                ApiProperty apiPropertyConf;
                Map<String, ApiProperty> apiPropertyMap;
                apiIgnore = method.getAnnotation(ApiIgnore.class);
                if (apiIgnore != null || "getDeclaringClass".equals(methodName = method.getName()) || "getClass".equals(methodName) || !methodName.startsWith("set") && !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
                if (isParam) {
                    if (!methodName.startsWith("set")) continue;
                    methodName = StringUtils.uncapitalize((String)methodName.replaceFirst("set", ""));
                } else if (methodName.startsWith("get")) {
                    methodName = StringUtils.uncapitalize((String)methodName.replaceFirst("get", ""));
                } else {
                    if (!methodName.startsWith("is")) continue;
                    methodName = StringUtils.uncapitalize((String)methodName.replaceFirst("is", ""));
                }
                property = new DocProperty();
                property.setClassName(method.getReturnType().getSimpleName());
                childPropertyMap = new HashMap<String, Boolean>(256);
                if (!propertyMap.isEmpty()) {
                    Set<String> strings2 = propertyMap.keySet();
                    boolean pass = false;
                    for (String string : strings2) {
                        if (string.contains(".")) {
                            if (!string.startsWith(methodName + ".")) continue;
                            childPropertyMap.put(string.replaceFirst(methodName + ".", ""), propertyMap.get(string));
                            pass = true;
                            continue;
                        }
                        if (!string.equals(methodName)) continue;
                        pass = true;
                    }
                    if (!pass) continue;
                    property.setRequited(propertyMap.get(methodName));
                }
                childParamGlobalApiPropertyMap = new HashMap<String, ApiProperty>(256);
                if (paramGlobalApiPropertyMap != null && !paramGlobalApiPropertyMap.isEmpty()) {
                    Set<String> strings3 = paramGlobalApiPropertyMap.keySet();
                    for (String string : strings3) {
                        String example2;
                        String defaultValue;
                        if (string.contains(".")) {
                            if (string.startsWith(methodName + ".")) {
                                childParamGlobalApiPropertyMap.put(string.replaceFirst(methodName + ".", ""), paramGlobalApiPropertyMap.get(string));
                                continue;
                            }
                            childParamGlobalApiPropertyMap.put(string, paramGlobalApiPropertyMap.get(string));
                            continue;
                        }
                        if (!string.equals(methodName)) continue;
                        ApiProperty apiPropertyConf2 = paramGlobalApiPropertyMap.get(methodName);
                        String string2 = apiPropertyConf2.description();
                        if (StringUtils.isNotBlank((CharSequence)string2)) {
                            property.setDescription(string2);
                        }
                        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiPropertyConf2.defaultValue())) {
                            property.setDefaultValue(defaultValue);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(example2 = apiPropertyConf2.example()))) {
                            property.setExample(example2);
                        }
                        boolean required = apiPropertyConf2.required();
                        if (property.getRequited() != null) continue;
                        property.setRequited(required);
                    }
                }
                childReturnGlobalApiPropertyMap = new HashMap<String, ApiProperty>(256);
                if (returnGlobalApiPropertyMap != null && !returnGlobalApiPropertyMap.isEmpty()) {
                    Set<String> strings4 = returnGlobalApiPropertyMap.keySet();
                    for (String string2 : strings4) {
                        String example3;
                        String defaultValue;
                        if (string2.contains(".")) {
                            if (string2.startsWith(methodName + ".")) {
                                childReturnGlobalApiPropertyMap.put(string2.replaceFirst(methodName + ".", ""), returnGlobalApiPropertyMap.get(string2));
                                continue;
                            }
                            childReturnGlobalApiPropertyMap.put(string2, returnGlobalApiPropertyMap.get(string2));
                            continue;
                        }
                        if (!string2.equals(methodName)) continue;
                        ApiProperty apiProperty2 = returnGlobalApiPropertyMap.get(methodName);
                        String description = apiProperty2.description();
                        if (StringUtils.isNotBlank((CharSequence)description)) {
                            property.setDescription(description);
                        }
                        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiProperty2.defaultValue())) {
                            property.setDefaultValue(defaultValue);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(example3 = apiProperty2.example()))) {
                            property.setExample(example3);
                        }
                        boolean required = apiProperty2.required();
                        if (property.getRequited() != null) continue;
                        property.setRequited(required);
                    }
                }
                if (isParam) {
                    if (ApiConstant.PARAM_GLOBAL_CLASS_MAP.containsKey(aClass)) {
                        apiPropertyMap = ApiConstant.PARAM_GLOBAL_CLASS_MAP.get(aClass);
                        Set<String> set = apiPropertyMap.keySet();
                        boolean contain = false;
                        for (String string3 : set) {
                            String defaultValue;
                            if (string3.contains(".")) {
                                if (!string3.startsWith(methodName + ".")) continue;
                                childParamGlobalApiPropertyMap.put(string3.replaceFirst(methodName + ".", ""), apiPropertyMap.get(string3));
                                contain = true;
                                continue;
                            }
                            if (!string3.equals(methodName)) continue;
                            contain = true;
                            apiPropertyConf = apiPropertyMap.get(methodName);
                            String description = apiPropertyConf.description();
                            if (StringUtils.isNotBlank((CharSequence)description)) {
                                property.setDescription(description);
                            }
                            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiPropertyConf.defaultValue())) {
                                property.setDefaultValue(defaultValue);
                            }
                            if (StringUtils.isNotBlank((CharSequence)(example = apiPropertyConf.example()))) {
                                property.setExample(example);
                            }
                            boolean required = apiPropertyConf.required();
                            if (property.getRequited() != null) continue;
                            property.setRequited(required);
                        }
                        if (!contain) continue;
                        String string = ApiConstant.PARAM_GLOBAL_CLASS_DESCRIPTION_MAP.get(aClass);
                        if (StringUtils.isNotBlank((CharSequence)string)) {
                            docModel.setDescription(string);
                            docProperty.setDescription(string);
                        }
                    }
                } else if (ApiConstant.RETURN_GLOBAL_CLASS_MAP.containsKey(aClass)) {
                    apiPropertyMap = ApiConstant.RETURN_GLOBAL_CLASS_MAP.get(aClass);
                    Set<String> set = apiPropertyMap.keySet();
                    boolean contain = false;
                    for (String string : set) {
                        String defaultValue;
                        if (string.contains(".")) {
                            if (!string.startsWith(methodName + ".")) continue;
                            childReturnGlobalApiPropertyMap.put(string.replaceFirst(methodName + ".", ""), apiPropertyMap.get(string));
                            contain = true;
                            continue;
                        }
                        if (!string.equals(methodName)) continue;
                        contain = true;
                        apiPropertyConf = apiPropertyMap.get(methodName);
                        String description = apiPropertyConf.description();
                        if (StringUtils.isNotBlank((CharSequence)description)) {
                            property.setDescription(description);
                        }
                        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiPropertyConf.defaultValue())) {
                            property.setDefaultValue(defaultValue);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(example = apiPropertyConf.example()))) {
                            property.setExample(example);
                        }
                        boolean required = apiPropertyConf.required();
                        if (property.getRequited() != null) continue;
                        property.setRequited(required);
                    }
                    if (!contain) continue;
                    String string = ApiConstant.RETURN_GLOBAL_CLASS_DESCRIPTION_MAP.get(aClass);
                    if (StringUtils.isNotBlank((CharSequence)string)) {
                        docModel.setDescription(string);
                        docProperty.setDescription(string);
                    }
                }
                childApiMapParamMap = null;
                if (apiMapParamMap != null && !apiMapParamMap.isEmpty()) {
                    childApiMapParamMap = new HashMap<String, ApiParam>(256);
                    Set<String> set = apiMapParamMap.keySet();
                    for (String string : set) {
                        if (!string.contains(".") || !string.startsWith(methodName + ".")) continue;
                        childApiMapParamMap.put(string.replaceFirst(methodName + ".", ""), apiMapParamMap.get(string));
                    }
                }
                Object var31_57 = null;
                if (apiMapReturnMap != null && !apiMapReturnMap.isEmpty()) {
                    HashMap<String, ApiReturn> hashMap = new HashMap<String, ApiReturn>(256);
                    Set<String> strings5 = apiMapReturnMap.keySet();
                    for (String string : strings5) {
                        if (!string.contains(".") || !string.startsWith(methodName + ".")) continue;
                        hashMap.put(string.replaceFirst(methodName + ".", ""), apiMapReturnMap.get(string));
                    }
                }
                apiMapPropertyMap = new HashMap<String, ApiMapProperty>(256);
                apiMapProperties = (ApiMapProperty[])method.getAnnotationsByType(ApiMapProperty.class);
                if (apiMapProperties != null && apiMapProperties.length > 0) {
                    for (ApiMapProperty apiMapProperty : apiMapProperties) {
                        String value3 = apiMapProperty.name();
                        apiMapPropertyMap.put(value3, apiMapProperty);
                    }
                }
                apiProperty = method.getAnnotation(ApiProperty.class);
                dateTimeFormat = method.getAnnotation(DateTimeFormat.class);
                jsonFormat = method.getAnnotation(JsonFormat.class);
                jsonProperty = method.getAnnotation(JsonProperty.class);
                validatedRequited = false;
                if (validated != null) {
                    Class[] groupClass = validated.value();
                    try {
                        NotNull[] notNulls;
                        NotBlank[] notBlanks;
                        Method returnMethod = aClass.getMethod("get" + StringUtils.capitalize((String)methodName), new Class[0]);
                        for (NotBlank notBlank : notBlanks = (NotBlank[])returnMethod.getAnnotationsByType(NotBlank.class)) {
                            if (groupClass.length == 0 && notBlank.groups().length == 0) {
                                validatedRequited = true;
                                break;
                            }
                            if (Collections.disjoint(Arrays.asList(notBlank.groups()), Arrays.asList(groupClass))) continue;
                            validatedRequited = true;
                            break;
                        }
                        if (validatedRequited == null) {
                            NotEmpty[] notEmptys;
                            for (NotEmpty notEmpty : notEmptys = (NotEmpty[])returnMethod.getAnnotationsByType(NotEmpty.class)) {
                                if (groupClass.length == 0 && notEmpty.groups().length == 0) {
                                    validatedRequited = true;
                                    break;
                                }
                                if (Collections.disjoint(Arrays.asList(notEmpty.groups()), Arrays.asList(groupClass))) continue;
                                validatedRequited = true;
                                break;
                            }
                        }
                        if (validatedRequited != null) break block173;
                        for (NotNull notNull : notNulls = (NotNull[])returnMethod.getAnnotationsByType(NotNull.class)) {
                            if (groupClass.length == 0 && notNull.groups().length == 0) {
                                validatedRequited = true;
                            } else {
                                if (Collections.disjoint(Arrays.asList(notNull.groups()), Arrays.asList(groupClass))) continue;
                                validatedRequited = true;
                            }
                            break;
                        }
                    }
                    catch (NoSuchMethodException returnMethod) {
                        // empty catch block
                    }
                }
            }
            if (ApiConstant.underscore) {
                property.setName(this.humpToLine(methodName));
            } else {
                property.setName(methodName);
            }
            try {
                String value4;
                void var33_84;
                Field field = this.getParentField(aClass, methodName);
                if (field == null) {
                    throw new NoSuchFieldException();
                }
                apiIgnore = field.getAnnotation(ApiIgnore.class);
                if (apiIgnore != null) continue;
                if (apiMapPropertyMap.isEmpty() && (apiMapProperties = (ApiMapProperty[])field.getAnnotationsByType(ApiMapProperty.class)) != null && apiMapProperties.length > 0) {
                    for (ApiMapProperty apiMapProperty : apiMapProperties) {
                        String value5 = apiMapProperty.name();
                        apiMapPropertyMap.put(value5, apiMapProperty);
                    }
                }
                if (apiProperty == null) {
                    ApiProperty apiProperty3 = field.getAnnotation(ApiProperty.class);
                }
                if (dateTimeFormat == null) {
                    dateTimeFormat = field.getAnnotation(DateTimeFormat.class);
                }
                if (jsonFormat == null) {
                    jsonFormat = field.getAnnotation(JsonFormat.class);
                }
                if (var33_84 != null) {
                    String example;
                    String defaultValue;
                    String description;
                    String value6 = var33_84.name();
                    if (StringUtils.isNotBlank((CharSequence)value6)) {
                        property.setName(value6);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(description = var33_84.description()))) {
                        property.setDescription(description);
                    }
                    if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = var33_84.defaultValue())) {
                        property.setDefaultValue(defaultValue);
                    }
                    if (propertyMap.isEmpty()) {
                        boolean required = var33_84.required();
                        property.setRequited(required);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(example = var33_84.example()))) {
                        property.setExample(example);
                    }
                }
                Boolean tempBoolean = false;
                if (validated != null) {
                    Class[] groupClass = validated.value();
                    if (!tempBoolean.booleanValue()) {
                        NotBlank[] notBlanks;
                        for (NotBlank notBlank : notBlanks = (NotBlank[])field.getAnnotationsByType(NotBlank.class)) {
                            if (groupClass.length == 0 && notBlank.groups().length == 0) {
                                tempBoolean = true;
                                break;
                            }
                            if (Collections.disjoint(Arrays.asList(notBlank.groups()), Arrays.asList(groupClass))) continue;
                            tempBoolean = true;
                            break;
                        }
                    }
                    if (!tempBoolean.booleanValue()) {
                        NotEmpty[] notEmptys;
                        for (NotEmpty notEmpty : notEmptys = (NotEmpty[])field.getAnnotationsByType(NotEmpty.class)) {
                            if (groupClass.length == 0 && notEmpty.groups().length == 0) {
                                tempBoolean = true;
                                break;
                            }
                            if (Collections.disjoint(Arrays.asList(notEmpty.groups()), Arrays.asList(groupClass))) continue;
                            tempBoolean = true;
                            break;
                        }
                    }
                    if (!tempBoolean.booleanValue()) {
                        NotNull[] notNulls;
                        for (NotNull notNull : notNulls = (NotNull[])field.getAnnotationsByType(NotNull.class)) {
                            if (groupClass.length == 0 && notNull.groups().length == 0) {
                                tempBoolean = true;
                                break;
                            }
                            if (Collections.disjoint(Arrays.asList(notNull.groups()), Arrays.asList(groupClass))) continue;
                            tempBoolean = true;
                            break;
                        }
                    }
                }
                property.setRequited(validatedRequited != false || tempBoolean != false);
                if (jsonProperty == null) {
                    jsonProperty = method.getAnnotation(JsonProperty.class);
                }
                if (jsonProperty != null && StringUtils.isNotBlank((CharSequence)(value4 = jsonProperty.value()))) {
                    property.setName(value4);
                }
                if (isParam && method.getName().startsWith("set")) {
                    DocProperty returnDocProperty;
                    Parameter[] parameters = method.getParameters();
                    if (!StringUtils.equals((CharSequence)field.getGenericType().getTypeName(), (CharSequence)parameters[0].getParameterizedType().getTypeName())) continue;
                    HashMap<String, ApiParamModelProperty> childApiModelPropertyMap = null;
                    if (apiModelPropertyMap != null && !apiModelPropertyMap.isEmpty()) {
                        childApiModelPropertyMap = new HashMap<String, ApiParamModelProperty>(256);
                        Set<String> strings = apiModelPropertyMap.keySet();
                        for (String string : strings) {
                            String example;
                            if (string.contains(".")) {
                                if (!string.startsWith(methodName + ".")) continue;
                                childApiModelPropertyMap.put(string.replaceFirst(methodName + ".", ""), apiModelPropertyMap.get(string));
                                continue;
                            }
                            if (!string.equals(methodName)) continue;
                            modelProperty = apiModelPropertyMap.get(string);
                            String description = modelProperty.description();
                            if (StringUtils.isNotBlank((CharSequence)description)) {
                                property.setDescription(description);
                            }
                            boolean required = modelProperty.required();
                            property.setRequited(required);
                            String defaultValue = modelProperty.defaultValue();
                            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue)) {
                                property.setDefaultValue(defaultValue);
                            }
                            if (!StringUtils.isNotBlank((CharSequence)(example = modelProperty.example()))) continue;
                            property.setExample(example);
                        }
                    }
                    HashSet copyRepeats = new HashSet(repeats);
                    copyRepeats.add(aClass);
                    if (type instanceof ParameterizedType && aClass.getTypeParameters().length > 0) {
                        Class paramClass = parameters[0].getType();
                        Type realType = this.realType(parameters[0].getParameterizedType(), aClass.getTypeParameters(), type);
                        if (realType instanceof ParameterizedType) {
                            paramClass = (Class)((ParameterizedType)realType).getRawType();
                        } else if (realType instanceof Class) {
                            paramClass = (Class)realType;
                        }
                        returnDocProperty = this.handleModel(validated, property, paramClass, realType, childPropertyMap, isParam, isJson, copyRepeats, childApiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    } else {
                        returnDocProperty = this.handleModel(validated, property, parameters[0].getType(), parameters[0].getParameterizedType(), childPropertyMap, isParam, isJson, copyRepeats, childApiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    }
                    if (returnDocProperty.getType().contains("date") || returnDocProperty.getType().contains("time")) {
                        if (isJson && jsonFormat != null) {
                            String pattern = jsonFormat.pattern();
                            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                                returnDocProperty.setFormat(pattern);
                            }
                        } else if (!isJson && dateTimeFormat != null) {
                            String pattern = dateTimeFormat.pattern();
                            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                                returnDocProperty.setFormat(pattern);
                            }
                        } else if (isJson) {
                            if (StringUtils.isNotBlank((CharSequence)this.jsonFormat)) {
                                returnDocProperty.setFormat(this.jsonFormat);
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)this.dateFormat)) {
                            returnDocProperty.setFormat(this.dateFormat);
                        }
                    }
                    apiProperties.add(returnDocProperty);
                    continue;
                }
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                Class returnType = method.getReturnType();
                Type genericReturnType = method.getGenericReturnType();
                if (!StringUtils.equals((CharSequence)field.getGenericType().getTypeName(), (CharSequence)genericReturnType.getTypeName())) continue;
                HashMap<String, ApiReturnModelProperty> childApiReturnModelPropertyMap = null;
                if (apiReturnModelPropertyMap != null && !apiReturnModelPropertyMap.isEmpty()) {
                    childApiReturnModelPropertyMap = new HashMap<String, ApiReturnModelProperty>(256);
                    Set<String> strings = apiReturnModelPropertyMap.keySet();
                    for (String string : strings) {
                        ApiReturnModelProperty modelProperty2;
                        String description;
                        if (string.contains(".")) {
                            if (!string.startsWith(methodName + ".")) continue;
                            childApiReturnModelPropertyMap.put(string.replaceFirst(methodName + ".", ""), apiReturnModelPropertyMap.get(string));
                            continue;
                        }
                        if (!string.equals(methodName) || !StringUtils.isNotBlank((CharSequence)(description = (modelProperty2 = apiReturnModelPropertyMap.get(string)).description()))) continue;
                        property.setDescription(description);
                    }
                }
                HashSet copyRepeats = new HashSet(repeats);
                copyRepeats.add(aClass);
                if (type instanceof ParameterizedType && aClass.getTypeParameters().length > 0) {
                    Type realType = this.realType(genericReturnType, aClass.getTypeParameters(), type);
                    if (realType instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)realType).getRawType();
                    } else if (realType instanceof Class) {
                        returnType = (Class)realType;
                    }
                    property = this.handleModel(validated, property, returnType, realType, childPropertyMap, isParam, isJson, copyRepeats, apiModelPropertyMap, childApiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                } else {
                    property = this.handleModel(validated, property, returnType, ApiUtils.regenerateType(genericReturnType), childPropertyMap, isParam, isJson, copyRepeats, apiModelPropertyMap, childApiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                }
                if (property.getType().contains("date") || property.getType().contains("time")) {
                    if (isJson && jsonFormat != null) {
                        String pattern = jsonFormat.pattern();
                        if (StringUtils.isNotBlank((CharSequence)pattern)) {
                            property.setFormat(pattern);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)this.jsonFormat)) {
                        property.setFormat(this.jsonFormat);
                    }
                }
                apiProperties.add(property);
            }
            catch (NoSuchFieldException exception) {
                String value7;
                if (apiProperty != null) {
                    String example;
                    String defaultValue;
                    String description;
                    String value8 = apiProperty.name();
                    if (StringUtils.isNotBlank((CharSequence)value8)) {
                        property.setName(value8);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(description = apiProperty.description()))) {
                        property.setDescription(description);
                    }
                    if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiProperty.defaultValue())) {
                        property.setDefaultValue(defaultValue);
                    }
                    if (propertyMap.isEmpty()) {
                        boolean required = apiProperty.required();
                        property.setRequited(required);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(example = apiProperty.example()))) {
                        property.setExample(example);
                    }
                }
                if (jsonProperty != null && StringUtils.isNotBlank((CharSequence)(value7 = jsonProperty.value()))) {
                    property.setName(value7);
                }
                if (isParam && method.getName().startsWith("set")) {
                    DocProperty returnDocProperty;
                    Parameter[] parameters = method.getParameters();
                    HashMap<String, ApiParamModelProperty> childApiModelPropertyMap = null;
                    if (apiModelPropertyMap != null && !apiModelPropertyMap.isEmpty()) {
                        childApiModelPropertyMap = new HashMap<String, ApiParamModelProperty>(256);
                        Set<String> strings = apiModelPropertyMap.keySet();
                        for (String string : strings) {
                            String example;
                            if (string.contains(".")) {
                                if (!string.startsWith(methodName + ".")) continue;
                                childApiModelPropertyMap.put(string.replaceFirst(methodName + ".", ""), apiModelPropertyMap.get(string));
                                continue;
                            }
                            if (!string.equals(methodName)) continue;
                            ApiParamModelProperty modelProperty3 = apiModelPropertyMap.get(string);
                            String description = modelProperty3.description();
                            if (StringUtils.isNotBlank((CharSequence)description)) {
                                property.setDescription(description);
                            }
                            boolean required = modelProperty3.required();
                            property.setRequited(required);
                            String defaultValue = modelProperty3.defaultValue();
                            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue)) {
                                property.setDefaultValue(defaultValue);
                            }
                            if (!StringUtils.isNotBlank((CharSequence)(example = modelProperty3.example()))) continue;
                            property.setExample(example);
                        }
                    }
                    HashSet copyRepeats = new HashSet(repeats);
                    copyRepeats.add(aClass);
                    if (type instanceof ParameterizedType && aClass.getTypeParameters().length > 0) {
                        Class paramClass = parameters[0].getType();
                        Type realType = this.realType(parameters[0].getParameterizedType(), aClass.getTypeParameters(), type);
                        if (realType instanceof ParameterizedType) {
                            paramClass = (Class)((ParameterizedType)realType).getRawType();
                        } else if (realType instanceof Class) {
                            paramClass = (Class)realType;
                        }
                        returnDocProperty = this.handleModel(validated, property, paramClass, realType, childPropertyMap, isParam, isJson, copyRepeats, childApiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    } else {
                        returnDocProperty = this.handleModel(validated, property, parameters[0].getType(), parameters[0].getParameterizedType(), childPropertyMap, isParam, isJson, copyRepeats, childApiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    }
                    if (returnDocProperty.getType().contains("date") || returnDocProperty.getType().contains("time")) {
                        if (isJson && jsonFormat != null) {
                            String pattern = jsonFormat.pattern();
                            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                                returnDocProperty.setFormat(pattern);
                            }
                        } else if (!isJson && dateTimeFormat != null) {
                            String pattern = dateTimeFormat.pattern();
                            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                                returnDocProperty.setFormat(pattern);
                            }
                        } else if (isJson) {
                            if (StringUtils.isNotBlank((CharSequence)this.jsonFormat)) {
                                returnDocProperty.setFormat(this.jsonFormat);
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)this.dateFormat)) {
                            returnDocProperty.setFormat(this.dateFormat);
                        }
                    }
                    apiProperties.add(returnDocProperty);
                    continue;
                }
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                Class returnType = method.getReturnType();
                Type genericReturnType = method.getGenericReturnType();
                HashMap<String, ApiReturnModelProperty> childApiReturnModelPropertyMap = null;
                if (apiReturnModelPropertyMap != null && !apiReturnModelPropertyMap.isEmpty()) {
                    childApiReturnModelPropertyMap = new HashMap<String, ApiReturnModelProperty>(256);
                    Set<String> strings = apiReturnModelPropertyMap.keySet();
                    for (String string : strings) {
                        String description;
                        if (string.contains(".")) {
                            if (!string.startsWith(methodName + ".")) continue;
                            childApiReturnModelPropertyMap.put(string.replaceFirst(methodName + ".", ""), apiReturnModelPropertyMap.get(string));
                            continue;
                        }
                        if (!string.equals(methodName) || !StringUtils.isNotBlank((CharSequence)(description = (modelProperty = apiReturnModelPropertyMap.get(string)).description()))) continue;
                        property.setDescription(description);
                    }
                }
                HashSet copyRepeats = new HashSet(repeats);
                copyRepeats.add(aClass);
                if (type instanceof ParameterizedType && aClass.getTypeParameters().length > 0) {
                    Type realType = this.realType(genericReturnType, aClass.getTypeParameters(), type);
                    if (realType instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)realType).getRawType();
                    } else if (realType instanceof Class) {
                        returnType = (Class)realType;
                    }
                    property = this.handleModel(validated, property, returnType, realType, childPropertyMap, isParam, isJson, copyRepeats, apiModelPropertyMap, childApiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                } else {
                    property = this.handleModel(validated, property, returnType, ApiUtils.regenerateType(genericReturnType), childPropertyMap, isParam, isJson, copyRepeats, apiModelPropertyMap, childApiReturnModelPropertyMap, apiMapPropertyMap, childApiMapParamMap, (Map<String, ApiReturn>)var31_59, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                }
                if (property.getType().contains("date") || property.getType().contains("time")) {
                    if (isJson && jsonFormat != null) {
                        String pattern = jsonFormat.pattern();
                        if (StringUtils.isNotBlank((CharSequence)pattern)) {
                            property.setFormat(pattern);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)this.jsonFormat)) {
                        property.setFormat(this.jsonFormat);
                    }
                }
                apiProperties.add(property);
            }
        }
        docModel.setApiProperties(apiProperties);
        docProperty.setDocModel(docModel);
        return docProperty;
    }

    public Field getParentField(Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException exception) {
            try {
                return clazz.getDeclaredField(StringUtils.capitalize((String)fieldName));
            }
            catch (NoSuchFieldException exception2) {
                return this.getParentField(clazz.getSuperclass(), fieldName);
            }
        }
    }

    public Type realType(Type type, TypeVariable<? extends Class<?>>[] typeParameters, Type genericType) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type rawType = pType.getRawType();
            ArrayList<Type> types = new ArrayList<Type>();
            for (Type actualTypeArgument : pType.getActualTypeArguments()) {
                types.add(this.realType(actualTypeArgument, typeParameters, genericType));
            }
            return ParameterizedTypeImpl.make((Class)rawType, types.toArray(new Type[0]), null);
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!type.getTypeName().equals(typeParameters[i].getName())) continue;
            return ((ParameterizedType)genericType).getActualTypeArguments()[i];
        }
        return type;
    }

    public DocProperty handleGeneric(Validated validated, DocProperty docProperty, Type gType, Map<String, Boolean> propertyMap, boolean isParam, boolean isJson, Set<Class<?>> repeats, Map<String, ApiParamModelProperty> apiModelPropertyMap, Map<String, ApiReturnModelProperty> apiReturnModelPropertyMap, Map<String, ApiMapProperty> apiMapPropertyMap, Map<String, ApiParam> apiMapParamMap, Map<String, ApiReturn> apiMapReturnMap, Map<String, ApiProperty> paramGlobalApiPropertyMap, Map<String, ApiProperty> returnGlobalApiPropertyMap) {
        if (gType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)gType;
            Type[] tArgs = pType.getActualTypeArguments();
            Type tArg = tArgs[0];
            if (tArg instanceof Class && ((Class)tArg).isArray()) {
                docProperty.setType(docProperty.getType() + "[0]");
                return this.handleGeneric(validated, docProperty, ((Class)tArg).getComponentType(), propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
            }
            if (tArg instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)tArg).getRawType())) {
                docProperty.setType(docProperty.getType() + "[0]");
                return this.handleGeneric(validated, docProperty, tArg, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
            }
            if (!(tArg instanceof Class) && !(tArg instanceof ParameterizedType)) {
                return docProperty;
            }
            Class aClass = tArg instanceof Class ? (Class)tArg : (Class)((ParameterizedType)tArg).getRawType();
            return this.handleModel(validated, docProperty, aClass, tArg, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
        }
        return this.handleModel(validated, docProperty, (Class)gType, gType, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
    }

    public DocProperty handleMap(Validated validated, DocProperty docProperty, Type gType, Map<String, Boolean> propertyMap, boolean isParam, boolean isJson, Set<Class<?>> repeats, Map<String, ApiParamModelProperty> apiModelPropertyMap, Map<String, ApiReturnModelProperty> apiReturnModelPropertyMap, Map<String, ApiMapProperty> apiMapPropertyMap, Map<String, ApiParam> apiMapParamMap, Map<String, ApiReturn> apiMapReturnMap, Map<String, ApiProperty> paramGlobalApiPropertyMap, Map<String, ApiProperty> returnGlobalApiPropertyMap) {
        Object childProperty;
        Set childKeySet;
        String type;
        String description;
        DocProperty property;
        String[] split;
        TreeSet<DocProperty> docProperties;
        HashMap mapMap;
        Set<String> keySet;
        DocModel docModel = new DocModel();
        docModel.setClassName("Map");
        docModel.setDescription(docProperty.getDescription());
        TreeSet<DocProperty> apiProperties = new TreeSet<DocProperty>();
        Class keyClass = Object.class;
        if (gType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)gType;
            Type[] tArgs = pType.getActualTypeArguments();
            if (tArgs.length == 0) {
                return docProperty;
            }
            keyClass = tArgs[1] instanceof ParameterizedType ? (Class)((ParameterizedType)tArgs[1]).getRawType() : (Class)tArgs[1];
        }
        if (!(apiMapPropertyMap != null && !apiMapPropertyMap.isEmpty() || apiMapParamMap != null && !apiMapParamMap.isEmpty() || apiMapReturnMap != null && !apiMapReturnMap.isEmpty())) {
            return this.handleModel(validated, docProperty, keyClass, keyClass, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, apiMapParamMap, apiMapReturnMap, paramGlobalApiPropertyMap, returnGlobalApiPropertyMap);
        }
        HashMap<String, ApiProperty> childParamGlobalApiPropertyMap = new HashMap<String, ApiProperty>(256);
        if (paramGlobalApiPropertyMap != null && !paramGlobalApiPropertyMap.isEmpty()) {
            Set<String> strings = paramGlobalApiPropertyMap.keySet();
            for (String string : strings) {
                if (!string.contains(".")) continue;
                String[] split2 = string.split("\\.");
                childParamGlobalApiPropertyMap.put(string.replaceFirst(split2[0] + ".", ""), paramGlobalApiPropertyMap.get(string));
            }
        }
        HashMap<String, ApiProperty> childReturnGlobalApiPropertyMap = new HashMap<String, ApiProperty>(256);
        if (returnGlobalApiPropertyMap != null && !returnGlobalApiPropertyMap.isEmpty()) {
            Set<String> strings = returnGlobalApiPropertyMap.keySet();
            for (String string : strings) {
                if (!string.contains(".")) continue;
                String[] split3 = string.split("\\.");
                childReturnGlobalApiPropertyMap.put(string.replaceFirst(split3[0] + ".", ""), returnGlobalApiPropertyMap.get(string));
            }
        }
        Set<Object> fieldKeySet = new HashSet();
        HashMap<String, ApiMapProperty> hashMap = new HashMap<String, ApiMapProperty>(256);
        if (apiMapPropertyMap != null && !apiMapPropertyMap.isEmpty()) {
            hashMap.putAll(apiMapPropertyMap);
            fieldKeySet = apiMapPropertyMap.keySet();
        }
        if (apiMapParamMap != null && !apiMapParamMap.isEmpty() && isParam) {
            keySet = apiMapParamMap.keySet();
            mapMap = new HashMap(256);
            docProperties = new TreeSet<DocProperty>();
            for (String string : keySet) {
                String example;
                String type2;
                String defaultValue;
                split = string.split("\\.");
                for (String string2 : fieldKeySet) {
                    if (!split[0].equals(string.split("\\.")[0])) continue;
                    hashMap.remove(string2);
                }
                if (split.length > 1) {
                    Map<String, ApiParam> childApiMapParamMap;
                    if (mapMap.containsKey(split[0])) {
                        childApiMapParamMap = (Map)mapMap.get(split[0]);
                        childApiMapParamMap.put(string.replaceFirst(split[0] + ".", ""), apiMapParamMap.get(string));
                        continue;
                    }
                    childApiMapParamMap = new HashMap<String, ApiParam>(256);
                    childApiMapParamMap.put(string.replaceFirst(split[0] + ".", ""), apiMapParamMap.get(string));
                    mapMap.put(split[0], childApiMapParamMap);
                    continue;
                }
                property = new DocProperty();
                property.setName(split[0]);
                ApiParam apiParam = apiMapParamMap.get(string);
                description = apiParam.description();
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    property.setDescription(description);
                }
                if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiParam.defaultValue())) {
                    property.setDefaultValue(defaultValue);
                }
                if (StringUtils.isNotBlank((CharSequence)(type2 = apiParam.type()))) {
                    property.setType(type2);
                } else {
                    property.setType("");
                }
                String format = apiParam.format();
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    property.setFormat(format);
                }
                if (StringUtils.isNotBlank((CharSequence)(example = apiParam.example()))) {
                    property.setExample(example);
                }
                boolean required = apiParam.required();
                property.setRequited(required);
                docProperties.add(property);
            }
            if (!docProperties.isEmpty()) {
                for (DocProperty docProperty2 : docProperties) {
                    type = docProperty2.getType();
                    docProperty2.setType("");
                    DocProperty docProperty3 = this.handleModel(validated, docProperty2, keyClass, gType, propertyMap, true, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, (Map)mapMap.get(docProperty2.getName()), apiMapReturnMap, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isBlank((CharSequence)docProperty3.getType())) {
                        docProperty3.setType(type);
                    }
                    if (StringUtils.isNotBlank((CharSequence)type) && (StringUtils.isBlank((CharSequence)docProperty3.getClassName()) || "Object".equals(docProperty3.getClassName()))) {
                        docProperty3.setClassName(ApiConstant.typeReverseMap.get(docProperty3.getType()));
                    }
                    apiProperties.add(docProperty3);
                }
            }
            if (!mapMap.isEmpty()) {
                childKeySet = mapMap.keySet();
                for (Object key : childKeySet) {
                    childProperty = new DocProperty();
                    ((DocProperty)childProperty).setName((String)key);
                    childProperty = this.handleModel(validated, (DocProperty)childProperty, keyClass, gType, propertyMap, true, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, apiMapPropertyMap, (Map)mapMap.get(key), apiMapReturnMap, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    apiProperties.add((DocProperty)childProperty);
                }
            }
        } else if (apiMapReturnMap != null && !apiMapReturnMap.isEmpty() && !isParam) {
            keySet = apiMapReturnMap.keySet();
            mapMap = new HashMap(256);
            docProperties = new TreeSet();
            for (String string : keySet) {
                Object type3;
                split = string.split("\\.");
                for (String string3 : fieldKeySet) {
                    if (!split[0].equals(string.split("\\.")[0])) continue;
                    hashMap.remove(string3);
                }
                if (split.length > 1) {
                    Map<String, ApiReturn> childApiMapReturnMap;
                    if (mapMap.containsKey(split[0])) {
                        childApiMapReturnMap = (Map)mapMap.get(split[0]);
                        childApiMapReturnMap.put(string.replaceFirst(split[0] + ".", ""), apiMapReturnMap.get(string));
                        continue;
                    }
                    childApiMapReturnMap = new HashMap<String, ApiReturn>(256);
                    childApiMapReturnMap.put(string.replaceFirst(split[0] + ".", ""), apiMapReturnMap.get(string));
                    mapMap.put(split[0], childApiMapReturnMap);
                    continue;
                }
                property = new DocProperty();
                property.setName(split[0]);
                ApiReturn apiReturn = apiMapReturnMap.get(string);
                description = apiReturn.description();
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    property.setDescription(description);
                }
                if (StringUtils.isNotBlank((CharSequence)(type3 = apiReturn.type()))) {
                    property.setType((String)type3);
                } else {
                    property.setType("");
                }
                String format = apiReturn.format();
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    property.setFormat(format);
                }
                docProperties.add(property);
            }
            if (!docProperties.isEmpty()) {
                for (DocProperty docProperty4 : docProperties) {
                    type = docProperty4.getType();
                    docProperty4.setType("");
                    DocProperty docProperty5 = this.handleModel(validated, docProperty4, keyClass, gType, propertyMap, false, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, hashMap, apiMapParamMap, (Map)mapMap.get(docProperty4.getName()), childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isBlank((CharSequence)docProperty5.getType())) {
                        docProperty5.setType(type);
                    }
                    if (StringUtils.isNotBlank((CharSequence)type) && (StringUtils.isBlank((CharSequence)docProperty5.getClassName()) || "Object".equals(docProperty5.getClassName()))) {
                        docProperty5.setClassName(ApiConstant.typeReverseMap.get(docProperty5.getType()));
                    }
                    apiProperties.add(docProperty5);
                }
            }
            if (!mapMap.isEmpty()) {
                childKeySet = mapMap.keySet();
                for (Object key : childKeySet) {
                    childProperty = new DocProperty();
                    ((DocProperty)childProperty).setName((String)key);
                    childProperty = this.handleModel(validated, (DocProperty)childProperty, keyClass, gType, propertyMap, false, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, hashMap, apiMapParamMap, (Map)mapMap.get(key), childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    apiProperties.add((DocProperty)childProperty);
                }
            }
        }
        if (!hashMap.isEmpty()) {
            keySet = hashMap.keySet();
            mapMap = new HashMap(256);
            HashMap<String, ApiParam> childApiMapParamMap = null;
            HashMap<String, ApiReturn> childApiMapReturnMap = null;
            TreeSet<DocProperty> treeSet = new TreeSet<DocProperty>();
            for (String key : keySet) {
                String example;
                String type4;
                String defaultValue;
                Set<String> strings;
                String[] stringArray = key.split("\\.");
                if (apiMapParamMap != null && !apiMapParamMap.isEmpty() && isParam) {
                    childApiMapParamMap = new HashMap<String, ApiParam>(256);
                    strings = apiMapParamMap.keySet();
                    for (String string : strings) {
                        if (string.contains(".")) {
                            if (string.startsWith(stringArray[0] + ".")) {
                                childApiMapParamMap.put(string.replaceFirst(stringArray[0] + ".", ""), apiMapParamMap.get(string));
                                continue;
                            }
                            childApiMapParamMap.put(string, apiMapParamMap.get(string));
                            continue;
                        }
                        childApiMapParamMap.put(string, apiMapParamMap.get(string));
                    }
                }
                if (apiMapReturnMap != null && !apiMapReturnMap.isEmpty() && !isParam) {
                    childApiMapReturnMap = new HashMap<String, ApiReturn>(256);
                    strings = apiMapReturnMap.keySet();
                    for (String string : strings) {
                        if (string.contains(".")) {
                            if (string.startsWith(stringArray[0] + ".")) {
                                childApiMapReturnMap.put(string.replaceFirst(stringArray[0] + ".", ""), apiMapReturnMap.get(string));
                                continue;
                            }
                            childApiMapReturnMap.put(string, apiMapReturnMap.get(string));
                            continue;
                        }
                        childApiMapReturnMap.put(string, apiMapReturnMap.get(string));
                    }
                }
                if (stringArray.length > 1) {
                    Map childApiMapPropertyMap;
                    if (mapMap.containsKey(stringArray[0])) {
                        childApiMapPropertyMap = (Map)mapMap.get(stringArray[0]);
                        childApiMapPropertyMap.put(key.replaceFirst(stringArray[0] + ".", ""), hashMap.get(key));
                        continue;
                    }
                    childApiMapPropertyMap = new HashMap(256);
                    childApiMapPropertyMap.put(key.replaceFirst(stringArray[0] + ".", ""), hashMap.get(key));
                    mapMap.put(stringArray[0], childApiMapPropertyMap);
                    continue;
                }
                DocProperty property3 = new DocProperty();
                property3.setName(stringArray[0]);
                ApiMapProperty apiReturn = (ApiMapProperty)hashMap.get(key);
                String description2 = apiReturn.description();
                if (StringUtils.isNotBlank((CharSequence)description2)) {
                    property3.setDescription(description2);
                }
                if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue = apiReturn.defaultValue())) {
                    property3.setDefaultValue(defaultValue);
                }
                if (StringUtils.isNotBlank((CharSequence)(type4 = apiReturn.type()))) {
                    property3.setType(type4);
                } else {
                    property3.setType("");
                }
                String format = apiReturn.format();
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    property3.setFormat(format);
                }
                if (StringUtils.isNotBlank((CharSequence)(example = apiReturn.example()))) {
                    property3.setExample(example);
                }
                boolean required = apiReturn.required();
                property3.setRequited(required);
                treeSet.add(property3);
            }
            if (!treeSet.isEmpty()) {
                for (DocProperty property4 : treeSet) {
                    String string = property4.getType();
                    property4.setType("");
                    property4 = this.handleModel(validated, property4, keyClass, gType, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, (Map)mapMap.get(property4.getName()), null, null, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isBlank((CharSequence)property4.getType())) {
                        property4.setType(string);
                    }
                    if (StringUtils.isNotBlank((CharSequence)string) && (StringUtils.isBlank((CharSequence)property4.getClassName()) || "Object".equals(property4.getClassName()))) {
                        property4.setClassName(ApiConstant.typeReverseMap.get(property4.getType()));
                    }
                    apiProperties.add(property4);
                }
            }
            if (!mapMap.isEmpty()) {
                Set childKeySet2 = mapMap.keySet();
                for (String string : childKeySet2) {
                    DocProperty childProperty2 = new DocProperty();
                    childProperty2.setName(string);
                    childProperty2 = this.handleModel(validated, childProperty2, keyClass, gType, propertyMap, isParam, isJson, repeats, apiModelPropertyMap, apiReturnModelPropertyMap, (Map)mapMap.get(string), childApiMapParamMap, childApiMapReturnMap, childParamGlobalApiPropertyMap, childReturnGlobalApiPropertyMap);
                    apiProperties.add(childProperty2);
                }
            }
        }
        docModel.setApiProperties(apiProperties);
        docProperty.setDocModel(docModel);
        return docProperty;
    }

    public String humpToLine(String str) {
        Matcher matcher = this.pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

