/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.controller;

import com.citrsw.annatation.ApiMethod;
import com.citrsw.common.ApiConstant;
import com.citrsw.core.ApiContext;
import com.citrsw.core.MarkdownHandler;
import com.citrsw.definition.Doc;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApiController {
    private final ApiContext apiContext;

    public ApiController(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    @GetMapping(value={"/citrsw/api"})
    @ApiMethod(value="Api\u6587\u6863\u6570\u636e")
    public Doc api() {
        if (!ApiConstant.apiEnable) {
            return null;
        }
        return this.apiContext.getDoc();
    }

    @GetMapping(value={"/citrsw/api/down/markdown"})
    @ApiMethod(value="Api\u6587\u6863markdown\u4e0b\u8f7d")
    public ResponseEntity<InputStreamResource> down() throws UnsupportedEncodingException {
        if (!ApiConstant.apiEnable) {
            return null;
        }
        String generate = new MarkdownHandler().generate(this.apiContext.getDoc());
        byte[] bytes = generate.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        String newName = URLEncoder.encode(StringUtils.isBlank((CharSequence)this.apiContext.getDoc().getName()) ? "Api\u6587\u6863.md" : this.apiContext.getDoc().getName() + ".md", "utf-8").replaceAll("\\+", "%20").replaceAll("%28", "\\(").replaceAll("%29", "\\)").replaceAll("%3B", ";").replaceAll("%40", "@").replaceAll("%23", "\\#").replaceAll("%26", "\\&").replaceAll("%2C", "\\,");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", newName));
        headers.add("Expires", "0");
        headers.add("Pragma", "no-cache");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)bytes.length).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new InputStreamResource((InputStream)byteArrayInputStream));
    }
}

